/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.text.SimpleDateFormat;
import java.util.Date;

public class CompactionTaskSummary {
    protected long timeCost = 0L;
    protected volatile Status status = Status.NOT_STARTED;
    protected long startTime = -1L;
    protected int processChunkNum = 0;
    protected int directlyFlushChunkNum = 0;
    protected int deserializeChunkCount = 0;
    protected int deserializePageCount = 0;
    protected int mergedChunkNum = 0;
    protected long processPointNum = 0L;
    protected long temporalFileSize = 0L;
    protected int temporalFileNum = 0;

    public void start() {
        this.status = Status.STARTED;
        this.startTime = System.currentTimeMillis();
    }

    public void finish(boolean success) {
        this.status = success ? Status.SUCCESS : Status.FAILED;
        this.timeCost = System.currentTimeMillis() - this.startTime;
    }

    public void cancel() {
        if (this.status != Status.SUCCESS && this.status != Status.FAILED) {
            this.status = Status.CANCELED;
            if (this.startTime != -1L) {
                this.timeCost = System.currentTimeMillis() - this.startTime;
            }
        }
    }

    public boolean isCancel() {
        return this.status == Status.CANCELED;
    }

    public boolean isFinished() {
        return this.status == Status.SUCCESS || this.status == Status.FAILED;
    }

    public boolean isRan() {
        return this.status != Status.NOT_STARTED;
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public long getTimeCost() {
        return this.timeCost;
    }

    public void increaseProcessChunkNum(int increment) {
        this.processChunkNum += increment;
    }

    public void increaseDirectlyFlushChunkNum(int increment) {
        this.directlyFlushChunkNum += increment;
    }

    public void increaseDeserializedChunkNum(int increment) {
        this.deserializeChunkCount += increment;
    }

    public void increaseProcessPointNum(long increment) {
        this.processPointNum += increment;
    }

    public void increaseMergedChunkNum(int increment) {
        this.mergedChunkNum += increment;
    }

    public void setDirectlyFlushChunkNum(int directlyFlushChunkNum) {
        this.directlyFlushChunkNum = directlyFlushChunkNum;
    }

    public void setDeserializeChunkCount(int deserializeChunkCount) {
        this.deserializeChunkCount = deserializeChunkCount;
    }

    public void setProcessPointNum(int processPointNum) {
        this.processPointNum = processPointNum;
    }

    public int getProcessChunkNum() {
        return this.processChunkNum;
    }

    public int getDirectlyFlushChunkNum() {
        return this.directlyFlushChunkNum;
    }

    public int getDeserializeChunkCount() {
        return this.deserializeChunkCount;
    }

    public int getMergedChunkNum() {
        return this.mergedChunkNum;
    }

    public long getProcessPointNum() {
        return this.processPointNum;
    }

    public void setTemporalFileSize(long temporalFileSize) {
        this.temporalFileSize = temporalFileSize;
    }

    public long getTemporalFileSize() {
        return this.temporalFileSize;
    }

    public void setTemporalFileNum(int temporalFileNum) {
        this.temporalFileNum = temporalFileNum;
    }

    public int getTemporalFileNum() {
        return this.temporalFileNum;
    }

    public String toString() {
        String startTimeInStr = new SimpleDateFormat().format(new Date(this.startTime));
        return String.format("Task start time: %s, total process chunk num: %d, directly flush chunk num: %d, merge chunk num: %d, deserialize chunk num: %d, total process point num: %d", startTimeInStr, this.processChunkNum, this.directlyFlushChunkNum, this.mergedChunkNum, this.deserializeChunkCount, this.processPointNum);
    }

    static enum Status {
        NOT_STARTED,
        STARTED,
        SUCCESS,
        FAILED,
        CANCELED;

    }
}

