/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.file;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class CompactionFileMetrics
implements IMetricSet {
    private static final String INNER_SEQ_TEMP = "inner-seq-temp";
    private static final String INNER_UNSEQ_TEMP = "inner-unseq-temp";
    private static final String CROSS_TEMP = "cross-temp";
    private final AtomicLong innerSeqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong innerUnseqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong crossCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicInteger innerSeqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger innerUnseqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger crossCompactionTempFileNum = new AtomicInteger(0);
    private long lastUpdateTime = 0L;

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileSize(true), new String[]{Tag.NAME.toString(), INNER_SEQ_TEMP});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileSize(false), new String[]{Tag.NAME.toString(), INNER_UNSEQ_TEMP});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, CompactionFileMetrics::getCrossCompactionTempFileSize, new String[]{Tag.NAME.toString(), CROSS_TEMP});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileNum(true), new String[]{Tag.NAME.toString(), INNER_SEQ_TEMP});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileNum(false), new String[]{Tag.NAME.toString(), INNER_UNSEQ_TEMP});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, CompactionFileMetrics::getCrossCompactionTempFileNum, new String[]{Tag.NAME.toString(), CROSS_TEMP});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), INNER_SEQ_TEMP});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), INNER_UNSEQ_TEMP});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), CROSS_TEMP});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), INNER_SEQ_TEMP});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), INNER_UNSEQ_TEMP});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), CROSS_TEMP});
    }

    public long getInnerCompactionTempFileSize(boolean seq) {
        this.updateCompactionTempSize();
        return seq ? this.innerSeqCompactionTempFileSize.get() : this.innerUnseqCompactionTempFileSize.get();
    }

    private synchronized void updateCompactionTempSize() {
        if (System.currentTimeMillis() - this.lastUpdateTime <= 10000L) {
            return;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        this.innerSeqCompactionTempFileSize.set(0L);
        this.innerSeqCompactionTempFileNum.set(0);
        this.innerUnseqCompactionTempFileSize.set(0L);
        this.innerUnseqCompactionTempFileNum.set(0);
        this.crossCompactionTempFileSize.set(0L);
        this.crossCompactionTempFileNum.set(0);
        List<AbstractCompactionTask> runningTasks = CompactionTaskManager.getInstance().getRunningCompactionTaskList();
        for (AbstractCompactionTask task : runningTasks) {
            CompactionTaskSummary summary = task.getSummary();
            if (task instanceof InnerSpaceCompactionTask) {
                if (task.isInnerSeqTask()) {
                    this.innerSeqCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
                    this.innerSeqCompactionTempFileNum.addAndGet(1);
                    continue;
                }
                this.innerUnseqCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
                this.innerUnseqCompactionTempFileNum.addAndGet(1);
                continue;
            }
            this.crossCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
            this.crossCompactionTempFileNum.addAndGet(summary.getTemporalFileNum());
        }
    }

    public long getCrossCompactionTempFileSize() {
        this.updateCompactionTempSize();
        return this.crossCompactionTempFileSize.get();
    }

    public long getInnerCompactionTempFileNum(boolean seq) {
        this.updateCompactionTempSize();
        return seq ? (long)this.innerSeqCompactionTempFileNum.get() : (long)this.innerUnseqCompactionTempFileNum.get();
    }

    public long getCrossCompactionTempFileNum() {
        this.updateCompactionTempSize();
        return this.crossCompactionTempFileNum.get();
    }
}

