/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentOverflowException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AliasIndexPage
extends SchemaPage
implements ISegment<String, String> {
    private static final int OFFSET_LEN = 2;
    long nextPage = ReadWriteIOUtils.readLong((ByteBuffer)this.pageBuffer);
    String penultKey = null;
    String lastKey = null;

    protected AliasIndexPage(ByteBuffer pageBuffer) {
        super(pageBuffer);
    }

    @Override
    public int insertRecord(String alias, String name) throws RecordDuplicatedException {
        if (this.spareSize < 10 + alias.getBytes().length + name.getBytes().length) {
            return -1;
        }
        int pos = this.getIndexByKey(alias);
        if (this.memberNum > 0 && pos < this.memberNum && this.getKeyByIndex(pos).equals(alias)) {
            return this.spareSize;
        }
        if (32 + 2 * (this.memberNum + 1) + 8 + alias.getBytes().length + name.getBytes().length > this.spareOffset) {
            this.compactKeys();
        }
        this.pageBuffer.clear();
        this.spareOffset = (short)(this.spareOffset - alias.getBytes().length - name.getBytes().length - 8);
        this.pageBuffer.position(this.spareOffset);
        ReadWriteIOUtils.write((String)alias, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((String)name, (ByteBuffer)this.pageBuffer);
        int migNum = this.memberNum - pos;
        if (migNum > 0) {
            ByteBuffer buf = ByteBuffer.allocate(migNum * 2);
            this.pageBuffer.limit(32 + 2 * this.memberNum);
            this.pageBuffer.position(32 + 2 * pos);
            buf.put(this.pageBuffer);
            this.pageBuffer.position(32 + 2 * pos);
            ReadWriteIOUtils.write((short)this.spareOffset, (ByteBuffer)this.pageBuffer);
            buf.clear();
            this.pageBuffer.limit(this.pageBuffer.limit() + 2);
            this.pageBuffer.put(buf);
        } else {
            this.pageBuffer.limit(this.pageBuffer.capacity());
            this.pageBuffer.position(32 + this.memberNum * 2);
            ReadWriteIOUtils.write((short)this.spareOffset, (ByteBuffer)this.pageBuffer);
        }
        this.spareSize = (short)(this.spareSize - (alias.getBytes().length + name.getBytes().length + 8 + 2));
        this.memberNum = (short)(this.memberNum + 1);
        this.penultKey = this.lastKey;
        this.lastKey = alias;
        return this.spareSize;
    }

    @Override
    public int updateRecord(String key, String buffer) throws SegmentOverflowException, RecordDuplicatedException {
        return -1;
    }

    @Override
    public int removeRecord(String key) {
        if (this.memberNum <= 0) {
            return this.spareSize;
        }
        int pos = this.getIndexByKey(key);
        if (!key.equals(this.getKeyByIndex(pos))) {
            return this.spareSize;
        }
        int migNum = this.memberNum - pos - 1;
        if (migNum > 0) {
            ByteBuffer temBuf = ByteBuffer.allocate(migNum * 2);
            this.pageBuffer.clear().limit(32 + 2 * this.memberNum);
            this.pageBuffer.position(32 + pos * 2 + 2);
            temBuf.put(this.pageBuffer).clear();
            this.pageBuffer.clear().position(32 + pos * 2);
            this.pageBuffer.put(temBuf);
        }
        this.memberNum = (short)(this.memberNum - 1);
        this.spareSize = (short)(this.spareSize + (10 + key.getBytes().length + this.getNameByIndex(pos).getBytes().length));
        return this.spareSize;
    }

    @Override
    public String getRecordByKey(String key) throws MetadataException {
        int pos = this.getIndexByKey(key);
        if (this.memberNum <= 0 || pos > this.memberNum) {
            return null;
        }
        if (pos == 0 || pos == this.memberNum) {
            pos = pos == this.memberNum ? pos - 1 : pos;
        }
        return key.equals(this.getKeyByIndex(pos)) ? this.getNameByIndex(pos) : null;
    }

    @Override
    public String getRecordByAlias(String alias) throws MetadataException {
        return this.getRecordByKey(alias);
    }

    @Override
    public boolean hasRecordKey(String key) {
        int idx = this.getIndexByKey(key);
        return this.memberNum > 0 && idx < this.memberNum && key.equals(this.getKeyByIndex(idx));
    }

    @Override
    public boolean hasRecordAlias(String alias) {
        return this.hasRecordKey(alias);
    }

    @Override
    public Queue<String> getAllRecords() throws MetadataException {
        ArrayDeque<String> res = new ArrayDeque<String>(this.memberNum);
        for (int i = 0; i < this.memberNum; ++i) {
            res.add(this.getNameByIndex(i));
        }
        return res;
    }

    @Override
    public void syncPageBuffer() {
        super.syncPageBuffer();
        ReadWriteIOUtils.write((long)this.nextPage, (ByteBuffer)this.pageBuffer);
    }

    @Override
    public void syncBuffer() {
        super.syncPageBuffer();
        ReadWriteIOUtils.write((long)this.nextPage, (ByteBuffer)this.pageBuffer);
    }

    @Override
    public short size() {
        return (short)this.pageBuffer.capacity();
    }

    @Override
    public short getSpareSize() {
        return this.spareSize;
    }

    @Override
    public void delete() {
    }

    @Override
    public long getNextSegAddress() {
        return this.nextPage;
    }

    @Override
    public void setNextSegAddress(long nextSegAddress) {
        this.nextPage = nextSegAddress;
    }

    @Override
    public void extendsTo(ByteBuffer newBuffer) throws MetadataException {
        if (newBuffer.capacity() != this.pageBuffer.capacity()) {
            throw new MetadataException("AliasIndexPage can only extend to buffer with same capacity.");
        }
        this.syncPageBuffer();
        this.pageBuffer.clear();
        newBuffer.clear();
        newBuffer.put(this.pageBuffer);
    }

    @Override
    public String splitByKey(String key, String entry, ByteBuffer dstBuffer, boolean inclineSplit) throws MetadataException {
        int pos;
        if (this.pageBuffer.capacity() != dstBuffer.capacity()) {
            throw new MetadataException("Segments only splits with same capacity.");
        }
        if (this.memberNum == 0) {
            throw new MetadataException("Segment can not be split with no records.");
        }
        if (key == null && this.memberNum <= 1) {
            throw new MetadataException("Segment can not be split with only one record.");
        }
        boolean monotonic = this.penultKey != null && key != null && this.lastKey != null && inclineSplit && key.compareTo(this.lastKey) * this.lastKey.compareTo(this.penultKey) > 0;
        int n = this.memberNum;
        int n2 = pos = key != null ? this.getIndexByKey(key) : -2;
        int sp = monotonic ? (key.compareTo(this.lastKey) > 0 ? Math.max(pos, n >> 1) : Math.min(pos, n >> 1)) : n >> 1;
        sp = sp <= 0 ? 1 : sp;
        short memberNum = 0;
        short spareOffset = (short)dstBuffer.capacity();
        short spareSize = (short)(spareOffset - 32);
        dstBuffer.clear();
        String sKey = null;
        n = key == null ? n - 1 : n;
        for (int ix = sp; ix <= n; ++ix) {
            int recSize;
            String mKey;
            if (ix == pos) {
                mKey = key;
                recSize = 8 + entry.getBytes().length + mKey.getBytes().length;
                spareOffset = (short)(spareOffset - recSize);
                dstBuffer.position(spareOffset);
                ReadWriteIOUtils.write((String)mKey, (ByteBuffer)dstBuffer);
                ReadWriteIOUtils.write((String)entry, (ByteBuffer)dstBuffer);
            } else {
                int aix = ix > pos && pos != -2 ? ix - 1 : ix;
                mKey = this.getKeyByIndex(aix);
                short offset = this.getOffsetByIndex(aix);
                this.pageBuffer.clear().position(offset);
                recSize = ReadWriteIOUtils.readInt((ByteBuffer)this.pageBuffer);
                this.pageBuffer.position(this.pageBuffer.position() + recSize);
                this.pageBuffer.position(offset);
                this.pageBuffer.limit(offset + (recSize += ReadWriteIOUtils.readInt((ByteBuffer)this.pageBuffer) + 8));
                spareOffset = (short)(spareOffset - recSize);
                dstBuffer.position(spareOffset);
                dstBuffer.put(this.pageBuffer);
            }
            dstBuffer.position(32 + memberNum * 2);
            ReadWriteIOUtils.write((short)spareOffset, (ByteBuffer)dstBuffer);
            if (ix == sp) {
                sKey = mKey;
            }
            memberNum = (short)(memberNum + 1);
            spareSize = (short)(spareSize - (recSize + 2));
        }
        this.memberNum = (short)(this.memberNum - memberNum);
        if (key != null && sp <= pos) {
            this.memberNum = (short)(this.memberNum + 1);
        }
        this.compactKeys();
        if (key != null && sp > pos && this.insertRecord(key, entry) < 0) {
            throw new SegmentOverflowException(key);
        }
        dstBuffer.clear();
        ReadWriteIOUtils.write((byte)2, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((int)-1, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)spareOffset, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)spareSize, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)memberNum, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((long)this.nextPage, (ByteBuffer)dstBuffer);
        this.penultKey = null;
        this.lastKey = null;
        return sKey;
    }

    @Override
    public ByteBuffer resetBuffer(int ptr) {
        return null;
    }

    @Override
    public String inspect() {
        this.syncPageBuffer();
        ByteBuffer bufferR = this.pageBuffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder(String.format("page_id:%d, total_seg:%d, spare_before:%d%n", this.pageIndex, 1, this.spareOffset));
        builder.append(String.format("[AliasIndexSegment, total_alias: %d, spare_size:%d,", this.memberNum, this.spareSize));
        bufferR.clear();
        for (int i = 0; i < this.memberNum; ++i) {
            builder.append(String.format("(%s, %s),", this.getKeyByIndex(i), this.getNameByIndex(i)));
        }
        builder.append("]\n");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.inspect();
    }

    @Override
    public ISegment<String, String> getAsAliasIndexPage() {
        return this;
    }

    private void compactKeys() {
        ByteBuffer tempBuffer = ByteBuffer.allocate(this.pageBuffer.capacity() - this.spareOffset);
        tempBuffer.position(tempBuffer.capacity());
        this.spareOffset = (short)this.pageBuffer.capacity();
        int accSiz = 0;
        for (int i = 0; i < this.memberNum; ++i) {
            String key = this.getKeyByIndex(i);
            String name = this.getNameByIndex(i);
            this.spareOffset = (short)(this.pageBuffer.capacity() - (accSiz += key.getBytes().length + name.getBytes().length + 8));
            this.pageBuffer.position(32 + 2 * i);
            ReadWriteIOUtils.write((short)this.spareOffset, (ByteBuffer)this.pageBuffer);
            tempBuffer.position(tempBuffer.capacity() - accSiz);
            ReadWriteIOUtils.write((String)key, (ByteBuffer)tempBuffer);
            ReadWriteIOUtils.write((String)name, (ByteBuffer)tempBuffer);
        }
        tempBuffer.position(tempBuffer.capacity() - accSiz);
        this.pageBuffer.position(this.spareOffset);
        this.pageBuffer.put(tempBuffer);
        this.spareSize = (short)(this.spareOffset - 32 - 2 * this.memberNum);
    }

    private int getIndexByKey(String key) {
        if (this.memberNum == 0 || key.compareTo(this.getKeyByIndex(0)) <= 0) {
            return 0;
        }
        if (key.compareTo(this.getKeyByIndex(this.memberNum - 1)) >= 0) {
            return this.memberNum;
        }
        int head = 0;
        int tail = this.memberNum - 1;
        int pivot = 0;
        while (head != tail) {
            pivot = (head + tail) / 2;
            String pk = this.getKeyByIndex(pivot);
            if (key.compareTo(pk) == 0) {
                return pivot;
            }
            if (key.compareTo(pk) > 0) {
                head = pivot;
            } else {
                tail = pivot;
            }
            if (head != tail - 1) continue;
            return key.compareTo(this.getKeyByIndex(head)) <= 0 ? head : tail;
        }
        return pivot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getOffsetByIndex(int index) {
        if (index < 0 || index >= this.memberNum) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            this.pageBuffer.limit(this.pageBuffer.capacity());
            this.pageBuffer.position(32 + index * 2);
            return ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeyByOffset(short offset) {
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            this.pageBuffer.limit(this.pageBuffer.capacity());
            this.pageBuffer.position(offset);
            return ReadWriteIOUtils.readString((ByteBuffer)this.pageBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameByOffset(short offset) {
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            this.pageBuffer.limit(this.pageBuffer.capacity());
            this.pageBuffer.position(offset);
            this.pageBuffer.position(offset + 4 + ReadWriteIOUtils.readInt((ByteBuffer)this.pageBuffer));
            return ReadWriteIOUtils.readString((ByteBuffer)this.pageBuffer);
        }
    }

    private String getKeyByIndex(int index) {
        if (index < 0 || index > this.memberNum) {
            throw new IndexOutOfBoundsException();
        }
        return this.getKeyByOffset(this.getOffsetByIndex(index));
    }

    private String getNameByIndex(int index) {
        if (index < 0 || index >= this.memberNum) {
            throw new IndexOutOfBoundsException();
        }
        return this.getNameByOffset(this.getOffsetByIndex(index));
    }
}

