/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GroupByVariationParameter
extends GroupByParameter {
    double delta;
    boolean ignoringNull;

    public GroupByVariationParameter(boolean ignoringNull, double delta) {
        super(WindowType.VARIATION_WINDOW);
        this.delta = delta;
        this.ignoringNull = ignoringNull;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((Boolean)this.ignoringNull, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((double)this.delta, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.ignoringNull, (OutputStream)stream);
        ReadWriteIOUtils.write((double)this.delta, (OutputStream)stream);
    }

    public double getDelta() {
        return this.delta;
    }

    public boolean isIgnoringNull() {
        return this.ignoringNull;
    }

    public static GroupByParameter deserialize(ByteBuffer buffer) {
        boolean ignoringNull = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        double delta = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
        return new GroupByVariationParameter(ignoringNull, delta);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.delta == ((GroupByVariationParameter)obj).getDelta() && this.ignoringNull == ((GroupByVariationParameter)obj).isIgnoringNull();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delta, this.ignoringNull);
    }
}

