/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.HorizontallyConcatNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GroupByTagNode
extends MultiChildProcessNode {
    private final List<String> tagKeys;
    private final Map<List<String>, List<CrossSeriesAggregationDescriptor>> tagValuesToAggregationDescriptors;
    private final List<String> outputColumnNames;
    @Nullable
    protected GroupByTimeParameter groupByTimeParameter;
    protected Ordering scanOrder;

    public GroupByTagNode(PlanNodeId id, List<PlanNode> children, @Nullable GroupByTimeParameter groupByTimeParameter, Ordering scanOrder, List<String> tagKeys, Map<List<String>, List<CrossSeriesAggregationDescriptor>> tagValuesToAggregationDescriptors, List<String> outputColumnNames) {
        super(id, children);
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = (Ordering)((Object)Validate.notNull((Object)((Object)scanOrder)));
        this.tagKeys = (List)Validate.notNull(tagKeys);
        this.tagValuesToAggregationDescriptors = (Map)Validate.notNull(tagValuesToAggregationDescriptors);
        this.outputColumnNames = (List)Validate.notNull(outputColumnNames);
    }

    public GroupByTagNode(PlanNodeId id, @Nullable GroupByTimeParameter groupByTimeParameter, Ordering scanOrder, List<String> tagKeys, Map<List<String>, List<CrossSeriesAggregationDescriptor>> tagValuesToAggregationDescriptors, List<String> outputColumnNames) {
        super(id);
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = (Ordering)((Object)Validate.notNull((Object)((Object)scanOrder)));
        this.tagKeys = (List)Validate.notNull(tagKeys);
        this.tagValuesToAggregationDescriptors = (Map)Validate.notNull(tagValuesToAggregationDescriptors);
        this.outputColumnNames = (List)Validate.notNull(outputColumnNames);
    }

    @Override
    public PlanNode clone() {
        return new GroupByTagNode(this.getPlanNodeId(), this.groupByTimeParameter, this.scanOrder, this.tagKeys, this.tagValuesToAggregationDescriptors, this.outputColumnNames);
    }

    @Override
    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        return new HorizontallyConcatNode(new PlanNodeId(String.format("%s-%s", this.getPlanNodeId(), subNodeId)), new ArrayList<PlanNode>(this.children.subList(startIndex, endIndex)));
    }

    @Override
    public List<String> getOutputColumnNames() {
        ArrayList<String> ret = new ArrayList<String>(this.tagKeys);
        ret.addAll(this.outputColumnNames);
        return ret;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitGroupByTag(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.GROUP_BY_TAG.serialize(byteBuffer);
        ReadWriteIOUtils.writeStringList(this.tagKeys, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.tagValuesToAggregationDescriptors.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<List<String>, List<CrossSeriesAggregationDescriptor>> entry : this.tagValuesToAggregationDescriptors.entrySet()) {
            ReadWriteIOUtils.writeStringList(entry.getKey(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (ByteBuffer)byteBuffer);
            for (CrossSeriesAggregationDescriptor aggregationDescriptor : entry.getValue()) {
                if (aggregationDescriptor == null) {
                    ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
                    continue;
                }
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
                aggregationDescriptor.serialize(byteBuffer);
            }
        }
        ReadWriteIOUtils.writeStringList(this.outputColumnNames, (ByteBuffer)byteBuffer);
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.GROUP_BY_TAG.serialize(stream);
        ReadWriteIOUtils.writeStringList(this.tagKeys, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.tagValuesToAggregationDescriptors.size(), (OutputStream)stream);
        for (Map.Entry<List<String>, List<CrossSeriesAggregationDescriptor>> entry : this.tagValuesToAggregationDescriptors.entrySet()) {
            ReadWriteIOUtils.writeStringList(entry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)stream);
            for (CrossSeriesAggregationDescriptor aggregationDescriptor : entry.getValue()) {
                if (aggregationDescriptor == null) {
                    ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
                    continue;
                }
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                aggregationDescriptor.serialize(stream);
            }
        }
        ReadWriteIOUtils.writeStringList(this.outputColumnNames, (OutputStream)stream);
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    @Nullable
    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    public Map<List<String>, List<CrossSeriesAggregationDescriptor>> getTagValuesToAggregationDescriptors() {
        return this.tagValuesToAggregationDescriptors;
    }

    public static GroupByTagNode deserialize(ByteBuffer byteBuffer) {
        List tagKeys = ReadWriteIOUtils.readStringList((ByteBuffer)byteBuffer);
        HashMap<List<String>, List<CrossSeriesAggregationDescriptor>> tagValuesToAggregationDescriptors = new HashMap<List<String>, List<CrossSeriesAggregationDescriptor>>();
        for (int numOfEntries = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); numOfEntries > 0; --numOfEntries) {
            List tagValues = ReadWriteIOUtils.readStringList((ByteBuffer)byteBuffer);
            ArrayList<CrossSeriesAggregationDescriptor> aggregationDescriptors = new ArrayList<CrossSeriesAggregationDescriptor>();
            for (int numOfAggregationDescriptors = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); numOfAggregationDescriptors > 0; --numOfAggregationDescriptors) {
                byte isNotNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
                if (isNotNull == 1) {
                    aggregationDescriptors.add(CrossSeriesAggregationDescriptor.deserialize(byteBuffer));
                    continue;
                }
                aggregationDescriptors.add(null);
            }
            tagValuesToAggregationDescriptors.put(tagValues, aggregationDescriptors);
        }
        List outputColumnNames = ReadWriteIOUtils.readStringList((ByteBuffer)byteBuffer);
        byte hasGroupByTimeParameter = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (hasGroupByTimeParameter == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new GroupByTagNode(planNodeId, groupByTimeParameter, scanOrder, tagKeys, tagValuesToAggregationDescriptors, outputColumnNames);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByTagNode that = (GroupByTagNode)o;
        return Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter) && this.scanOrder == that.scanOrder && Objects.equals(this.tagKeys, that.tagKeys) && Objects.equals(this.tagValuesToAggregationDescriptors, that.tagValuesToAggregationDescriptors) && Objects.equals(this.outputColumnNames, that.outputColumnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.groupByTimeParameter, this.scanOrder, this.tagKeys, this.tagValuesToAggregationDescriptors, this.outputColumnNames});
    }

    public String toString() {
        return String.format("GroupByTagNode-%s: Output: %s, Input: %s", this.getPlanNodeId(), this.getOutputColumnNames(), this.tagValuesToAggregationDescriptors.values().stream().flatMap(list -> list.stream().map(AggregationDescriptor::getInputExpressions)).collect(Collectors.toList()));
    }
}

