/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.apache.iotdb.db.queryengine.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class ExchangeOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final ISourceHandle sourceHandle;
    private final PlanNodeId sourceId;
    private ListenableFuture<?> isBlocked = NOT_BLOCKED;
    private long maxReturnSize = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private SettableFuture<Void> blockedDependencyDriver = null;

    public ExchangeOperator(OperatorContext operatorContext, ISourceHandle sourceHandle, PlanNodeId sourceId) {
        this.operatorContext = operatorContext;
        this.sourceHandle = sourceHandle;
        this.sourceId = sourceId;
    }

    public ExchangeOperator(OperatorContext operatorContext, ISourceHandle sourceHandle, PlanNodeId sourceId, long maxReturnSize) {
        this.operatorContext = operatorContext;
        this.sourceHandle = sourceHandle;
        this.sourceId = sourceId;
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        return this.sourceHandle.receive();
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.sourceHandle.isFinished();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.sourceHandle.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public ISourceHandle getSourceHandle() {
        return this.sourceHandle;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.sourceHandle.isBlocked();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public void close() throws Exception {
        this.sourceHandle.close();
        if (this.blockedDependencyDriver != null) {
            this.blockedDependencyDriver.set(null);
        }
    }

    public SettableFuture<Void> getBlockedDependencyDriver() {
        if (this.blockedDependencyDriver == null) {
            this.blockedDependencyDriver = SettableFuture.create();
        }
        return this.blockedDependencyDriver;
    }
}

