/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.task.connection.EnrichedDeque;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;

public class PipeEventCollector
implements EventCollector,
AutoCloseable {
    private final BoundedBlockingPendingQueue<Event> pendingQueue;
    private final EnrichedDeque<Event> bufferQueue;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public PipeEventCollector(BoundedBlockingPendingQueue<Event> pendingQueue) {
        this.pendingQueue = pendingQueue;
        this.bufferQueue = new EnrichedDeque(new LinkedList());
    }

    public synchronized void collect(Event event) {
        if (event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName());
        }
        if (event instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event).recordBufferQueueSize(this.bufferQueue);
            ((PipeHeartbeatEvent)event).recordConnectorQueueSize(this.pendingQueue);
        }
        while (!this.isClosed.get() && !this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.waitedOffer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            if (event instanceof PipeHeartbeatEvent && this.bufferQueue.peekLast() instanceof PipeHeartbeatEvent) {
                ((EnrichedEvent)event).decreaseReferenceCount(PipeEventCollector.class.getName(), false);
            } else {
                this.bufferQueue.offer(event);
            }
            return;
        }
        if (!this.pendingQueue.waitedOffer(event)) {
            this.bufferQueue.offer(event);
        }
    }

    public boolean isBufferQueueEmpty() {
        return this.bufferQueue.isEmpty();
    }

    public synchronized boolean tryCollectBufferedEvents() {
        while (!this.isClosed.get() && !this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.waitedOffer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.doClose();
    }

    private synchronized void doClose() {
        this.bufferQueue.forEach(event -> {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeEventCollector.class.getName());
            }
        });
        this.bufferQueue.clear();
    }

    public int getTabletInsertionEventCount() {
        return this.bufferQueue.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.bufferQueue.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.bufferQueue.getPipeHeartbeatEventCount();
    }
}

