/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.rpc.thrift.TCQConfig;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.confignode.rpc.thrift.TRatisConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.service.metrics.IoTDBInternalLocalReporter;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerSeqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerUnseqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.CrossCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.InnerSequenceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.constant.InnerUnsequenceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.datastructure.TVListSortAlgorithm;
import org.apache.iotdb.external.api.IPropertiesLoader;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalMemoryReporter;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalReporter;
import org.apache.iotdb.metrics.utils.InternalReporterType;
import org.apache.iotdb.metrics.utils.NodeType;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private final CommonDescriptor commonDescriptor = CommonDescriptor.getInstance();
    private final IoTDBConfig conf = new IoTDBConfig();

    protected IoTDBDescriptor() {
        this.loadProps();
        ServiceLoader<IPropertiesLoader> propertiesLoaderServiceLoader = ServiceLoader.load(IPropertiesLoader.class);
        for (IPropertiesLoader loader : propertiesLoaderServiceLoader) {
            logger.info("Will reload properties from {} ", (Object)loader.getClass().getName());
            Properties properties = loader.loadProperties();
            try {
                this.loadProperties(properties);
            }
            catch (Exception e) {
                logger.error("Failed to reload properties from {}, reject DataNode startup.", (Object)loader.getClass().getName(), (Object)e);
                System.exit(-1);
            }
            this.conf.setCustomizedProperties(loader.getCustomizedProperties());
            TSFileDescriptor.getInstance().overwriteConfigByCustomSettings(properties);
            TSFileDescriptor.getInstance().getConfig().setCustomizedProperties(loader.getCustomizedProperties());
        }
    }

    public static IoTDBDescriptor getInstance() {
        return IoTDBDescriptorHolder.INSTANCE;
    }

    public IoTDBConfig getConfig() {
        return this.conf;
    }

    public String getConfDir() {
        String confString = System.getProperty("IOTDB_CONF", null);
        if (confString == null && (confString = System.getProperty("IOTDB_HOME", null)) != null) {
            confString = confString + File.separatorChar + "conf";
        }
        return confString;
    }

    public URL getPropsUrl(String configFileName) {
        String urlString = this.getConfDir();
        if (urlString == null) {
            URL uri = IoTDBConfig.class.getResource("/" + configFileName);
            if (uri != null) {
                return uri;
            }
            logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)configFileName);
            this.conf.updatePath();
            return null;
        }
        if (!urlString.endsWith(".properties")) {
            urlString = urlString + File.separatorChar + configFileName;
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        InputStream inputStream;
        URL url = this.getPropsUrl("iotdb-common.properties");
        Properties commonProperties = new Properties();
        if (url != null) {
            try {
                inputStream = url.openStream();
                try {
                    logger.info("Start to read config file {}", (Object)url);
                    commonProperties.load(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Fail to find config file {}, reject DataNode startup.", (Object)url, (Object)e);
                System.exit(-1);
            }
            catch (IOException e) {
                logger.error("Cannot load config file, reject DataNode startup.", (Throwable)e);
                System.exit(-1);
            }
            catch (Exception e) {
                logger.error("Incorrect format in config file, reject DataNode startup.", (Throwable)e);
                System.exit(-1);
            }
        } else {
            logger.warn("Couldn't load the configuration {} from any of the known sources.", (Object)"iotdb-common.properties");
        }
        url = this.getPropsUrl("iotdb-datanode.properties");
        if (url != null) {
            try {
                inputStream = url.openStream();
                try {
                    logger.info("Start to read config file {}", (Object)url);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    commonProperties.putAll((Map<?, ?>)properties);
                    this.loadProperties(commonProperties);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Fail to find config file {}, reject DataNode startup.", (Object)url, (Object)e);
                System.exit(-1);
            }
            catch (IOException e) {
                logger.error("Cannot load config file, reject DataNode startup.", (Throwable)e);
                System.exit(-1);
            }
            catch (Exception e) {
                logger.error("Incorrect format in config file, reject DataNode startup.", (Throwable)e);
                System.exit(-1);
            }
            finally {
                this.conf.updatePath();
                this.commonDescriptor.getConfig().updatePath(System.getProperty("IOTDB_HOME", null));
                MetricConfigDescriptor.getInstance().loadProps(commonProperties);
                MetricConfigDescriptor.getInstance().getMetricConfig().updateRpcInstance(this.conf.getClusterName(), NodeType.DATANODE, "root.__system");
            }
        } else {
            logger.warn("Couldn't load the configuration {} from any of the known sources.", (Object)"iotdb-datanode.properties");
        }
    }

    public void loadProperties(Properties properties) throws BadNodeUrlException, IOException {
        long forceMlogPeriodInMs;
        this.conf.setClusterName(properties.getProperty("cluster_name", this.conf.getClusterName()).trim());
        this.conf.setRpcAddress(properties.getProperty("dn_rpc_address", this.conf.getRpcAddress()).trim());
        this.conf.setRpcThriftCompressionEnable(Boolean.parseBoolean(properties.getProperty("dn_rpc_thrift_compression_enable", Boolean.toString(this.conf.isRpcThriftCompressionEnable())).trim()));
        this.conf.setRpcAdvancedCompressionEnable(Boolean.parseBoolean(properties.getProperty("dn_rpc_advanced_compression_enable", Boolean.toString(this.conf.isRpcAdvancedCompressionEnable())).trim()));
        this.conf.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("dn_connection_timeout_ms", String.valueOf(this.conf.getConnectionTimeoutInMS())).trim()));
        if (properties.getProperty("dn_core_connection_for_internal_service", null) != null) {
            this.conf.setCoreClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_core_connection_for_internal_service").trim()));
            logger.warn("The parameter dn_core_connection_for_internal_service is out of date. Please rename it to dn_core_client_count_for_each_node_in_client_manager.");
        }
        this.conf.setCoreClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_core_client_count_for_each_node_in_client_manager", String.valueOf(this.conf.getCoreClientNumForEachNode())).trim()));
        if (properties.getProperty("dn_max_connection_for_internal_service", null) != null) {
            this.conf.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_max_connection_for_internal_service").trim()));
            logger.warn("The parameter dn_max_connection_for_internal_service is out of date. Please rename it to dn_max_client_count_for_each_node_in_client_manager.");
        }
        this.conf.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.conf.getMaxClientNumForEachNode())).trim()));
        this.conf.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("dn_selector_thread_count_of_client_manager", String.valueOf(this.conf.getSelectorNumOfClientManager())).trim()));
        this.conf.setRpcPort(Integer.parseInt(properties.getProperty("dn_rpc_port", Integer.toString(this.conf.getRpcPort())).trim()));
        this.conf.setBufferedArraysMemoryProportion(Double.parseDouble(properties.getProperty("buffered_arrays_memory_proportion", Double.toString(this.conf.getBufferedArraysMemoryProportion())).trim()));
        this.conf.setFlushProportion(Double.parseDouble(properties.getProperty("flush_proportion", Double.toString(this.conf.getFlushProportion())).trim()));
        this.conf.setRejectProportion(Double.parseDouble(properties.getProperty("reject_proportion", Double.toString(this.conf.getRejectProportion())).trim()));
        this.conf.setWriteMemoryVariationReportProportion(Double.parseDouble(properties.getProperty("write_memory_variation_report_proportion", Double.toString(this.conf.getWriteMemoryVariationReportProportion())).trim()));
        this.conf.setMetaDataCacheEnable(Boolean.parseBoolean(properties.getProperty("meta_data_cache_enable", Boolean.toString(this.conf.isMetaDataCacheEnable())).trim()));
        this.initMemoryAllocate(properties);
        this.loadWALProps(properties);
        String systemDir = properties.getProperty("dn_system_dir");
        if (systemDir == null) {
            systemDir = properties.getProperty("base_dir");
            systemDir = systemDir != null ? FilePathUtils.regularizePath((String)systemDir) + "system" : this.conf.getSystemDir();
        }
        this.conf.setSystemDir(systemDir);
        this.conf.setSchemaDir(FilePathUtils.regularizePath((String)this.conf.getSystemDir()) + "schema");
        this.conf.setQueryDir(FilePathUtils.regularizePath((String)(this.conf.getSystemDir() + "query")));
        CharSequence[] defaultTierDirs = new String[this.conf.getTierDataDirs().length];
        for (int i = 0; i < defaultTierDirs.length; ++i) {
            defaultTierDirs[i] = String.join((CharSequence)",", this.conf.getTierDataDirs()[i]);
        }
        this.conf.setTierDataDirs(this.parseDataDirs(properties.getProperty("dn_data_dirs", String.join((CharSequence)";", defaultTierDirs))));
        this.conf.setConsensusDir(properties.getProperty("dn_consensus_dir", this.conf.getConsensusDir()));
        int mlogBufferSize = Integer.parseInt(properties.getProperty("mlog_buffer_size", Integer.toString(this.conf.getMlogBufferSize())));
        if (mlogBufferSize > 0) {
            this.conf.setMlogBufferSize(mlogBufferSize);
        }
        if ((forceMlogPeriodInMs = Long.parseLong(properties.getProperty("sync_mlog_period_in_ms", Long.toString(this.conf.getSyncMlogPeriodInMs())))) > 0L) {
            this.conf.setSyncMlogPeriodInMs(forceMlogPeriodInMs);
        }
        String oldMultiDirStrategyClassName = this.conf.getMultiDirStrategyClassName();
        this.conf.setMultiDirStrategyClassName(properties.getProperty("dn_multi_dir_strategy", this.conf.getMultiDirStrategyClassName()));
        try {
            this.conf.checkMultiDirStrategyClassName();
        }
        catch (Exception e) {
            this.conf.setMultiDirStrategyClassName(oldMultiDirStrategyClassName);
            throw e;
        }
        this.conf.setBatchSize(Integer.parseInt(properties.getProperty("batch_size", Integer.toString(this.conf.getBatchSize()))));
        this.conf.setEnableMemControl(Boolean.parseBoolean(properties.getProperty("enable_mem_control", Boolean.toString(this.conf.isEnableMemControl()))));
        logger.info("IoTDB enable memory control: {}", (Object)this.conf.isEnableMemControl());
        long memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim());
        if (memTableSizeThreshold > 0L) {
            this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
        }
        this.conf.setTvListSortAlgorithm(TVListSortAlgorithm.valueOf(properties.getProperty("tvlist_sort_algorithm", this.conf.getTvListSortAlgorithm().toString())));
        this.conf.setAvgSeriesPointNumberThreshold(Integer.parseInt(properties.getProperty("avg_series_point_number_threshold", Integer.toString(this.conf.getAvgSeriesPointNumberThreshold()))));
        this.conf.setCheckPeriodWhenInsertBlocked(Integer.parseInt(properties.getProperty("check_period_when_insert_blocked", Integer.toString(this.conf.getCheckPeriodWhenInsertBlocked()))));
        this.conf.setMaxWaitingTimeWhenInsertBlocked(Integer.parseInt(properties.getProperty("max_waiting_time_when_insert_blocked", Integer.toString(this.conf.getMaxWaitingTimeWhenInsertBlocked()))));
        this.conf.setIoTaskQueueSizeForFlushing(Integer.parseInt(properties.getProperty("io_task_queue_size_for_flushing", Integer.toString(this.conf.getIoTaskQueueSizeForFlushing()))));
        this.conf.setCompactionScheduleIntervalInMs(Long.parseLong(properties.getProperty("compaction_schedule_interval_in_ms", Long.toString(this.conf.getCompactionScheduleIntervalInMs()))));
        this.conf.setCompactionSubmissionIntervalInMs(Long.parseLong(properties.getProperty("compaction_submission_interval_in_ms", Long.toString(this.conf.getCompactionSubmissionIntervalInMs()))));
        this.conf.setEnableInsertionCrossSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_insertion_cross_space_compaction", Boolean.toString(this.conf.isEnableInsertionCrossSpaceCompaction()))));
        this.conf.setEnableCrossSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_cross_space_compaction", Boolean.toString(this.conf.isEnableCrossSpaceCompaction()))));
        this.conf.setEnableSeqSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_seq_space_compaction", Boolean.toString(this.conf.isEnableSeqSpaceCompaction()))));
        this.conf.setEnableUnseqSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_unseq_space_compaction", Boolean.toString(this.conf.isEnableUnseqSpaceCompaction()))));
        this.conf.setCrossCompactionSelector(CrossCompactionSelector.getCrossCompactionSelector(properties.getProperty("cross_selector", this.conf.getCrossCompactionSelector().toString())));
        this.conf.setInnerSequenceCompactionSelector(InnerSequenceCompactionSelector.getInnerSequenceCompactionSelector(properties.getProperty("inner_seq_selector", this.conf.getInnerSequenceCompactionSelector().toString())));
        this.conf.setInnerUnsequenceCompactionSelector(InnerUnsequenceCompactionSelector.getInnerUnsequenceCompactionSelector(properties.getProperty("inner_unseq_selector", this.conf.getInnerUnsequenceCompactionSelector().toString())));
        this.conf.setInnerSeqCompactionPerformer(InnerSeqCompactionPerformer.getInnerSeqCompactionPerformer(properties.getProperty("inner_seq_performer", this.conf.getInnerSeqCompactionPerformer().toString())));
        this.conf.setInnerUnseqCompactionPerformer(InnerUnseqCompactionPerformer.getInnerUnseqCompactionPerformer(properties.getProperty("inner_unseq_performer", this.conf.getInnerUnseqCompactionPerformer().toString())));
        this.conf.setCrossCompactionPerformer(CrossCompactionPerformer.getCrossCompactionPerformer(properties.getProperty("cross_performer", this.conf.getCrossCompactionPerformer().toString())));
        this.conf.setCompactionPriority(CompactionPriority.valueOf(properties.getProperty("compaction_priority", this.conf.getCompactionPriority().toString())));
        this.conf.setEnableCompactionMemControl(Boolean.parseBoolean(properties.getProperty("enable_compaction_mem_control", Boolean.toString(this.conf.isEnableCompactionMemControl()))));
        int subtaskNum = Integer.parseInt(properties.getProperty("sub_compaction_thread_count", Integer.toString(this.conf.getSubCompactionTaskNum())));
        subtaskNum = subtaskNum <= 0 ? 1 : subtaskNum;
        this.conf.setSubCompactionTaskNum(subtaskNum);
        this.conf.setQueryTimeoutThreshold(Long.parseLong(properties.getProperty("query_timeout_threshold", Long.toString(this.conf.getQueryTimeoutThreshold()))));
        this.conf.setSessionTimeoutThreshold(Integer.parseInt(properties.getProperty("dn_session_timeout_threshold", Integer.toString(this.conf.getSessionTimeoutThreshold()))));
        this.conf.setFlushThreadCount(Integer.parseInt(properties.getProperty("flush_thread_count", Integer.toString(this.conf.getFlushThreadCount()))));
        if (this.conf.getFlushThreadCount() <= 0) {
            this.conf.setFlushThreadCount(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setIndexRootFolder(properties.getProperty("index_root_dir", this.conf.getIndexRootFolder()));
        this.conf.setEnableIndex(Boolean.parseBoolean(properties.getProperty("enable_index", Boolean.toString(this.conf.isEnableIndex()))));
        this.conf.setConcurrentIndexBuildThread(Integer.parseInt(properties.getProperty("concurrent_index_build_thread", Integer.toString(this.conf.getConcurrentIndexBuildThread()))));
        if (this.conf.getConcurrentIndexBuildThread() <= 0) {
            this.conf.setConcurrentIndexBuildThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setDefaultIndexWindowRange(Integer.parseInt(properties.getProperty("default_index_window_range", Integer.toString(this.conf.getDefaultIndexWindowRange()))));
        this.conf.setQueryThreadCount(Integer.parseInt(properties.getProperty("query_thread_count", Integer.toString(this.conf.getQueryThreadCount()))));
        if (this.conf.getQueryThreadCount() <= 0) {
            this.conf.setQueryThreadCount(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setDegreeOfParallelism(Integer.parseInt(properties.getProperty("degree_of_query_parallelism", Integer.toString(this.conf.getDegreeOfParallelism()))));
        if (this.conf.getDegreeOfParallelism() <= 0) {
            this.conf.setDegreeOfParallelism(Runtime.getRuntime().availableProcessors() / 2);
        }
        this.conf.setModeMapSizeThreshold(Integer.parseInt(properties.getProperty("mode_map_size_threshold", Integer.toString(this.conf.getModeMapSizeThreshold()))));
        if (this.conf.getModeMapSizeThreshold() <= 0) {
            this.conf.setModeMapSizeThreshold(10000);
        }
        this.conf.setMaxAllowedConcurrentQueries(Integer.parseInt(properties.getProperty("max_allowed_concurrent_queries", Integer.toString(this.conf.getMaxAllowedConcurrentQueries()))));
        if (this.conf.getMaxAllowedConcurrentQueries() <= 0) {
            this.conf.setMaxAllowedConcurrentQueries(1000);
        }
        this.conf.setmRemoteSchemaCacheSize(Integer.parseInt(properties.getProperty("remote_schema_cache_size", Integer.toString(this.conf.getmRemoteSchemaCacheSize())).trim()));
        this.conf.setLanguageVersion(properties.getProperty("language_version", this.conf.getLanguageVersion()).trim());
        if (properties.containsKey("chunk_buffer_pool_enable")) {
            this.conf.setChunkBufferPoolEnable(Boolean.parseBoolean(properties.getProperty("chunk_buffer_pool_enable")));
        }
        this.conf.setCrossCompactionFileSelectionTimeBudget(Long.parseLong(properties.getProperty("cross_compaction_file_selection_time_budget", Long.toString(this.conf.getCrossCompactionFileSelectionTimeBudget()))));
        this.conf.setMergeIntervalSec(Long.parseLong(properties.getProperty("merge_interval_sec", Long.toString(this.conf.getMergeIntervalSec()))));
        this.conf.setCompactionThreadCount(Integer.parseInt(properties.getProperty("compaction_thread_count", Integer.toString(this.conf.getCompactionThreadCount()))));
        this.conf.setChunkMetadataSizeProportion(Double.parseDouble(properties.getProperty("chunk_metadata_size_proportion", Double.toString(this.conf.getChunkMetadataSizeProportion()))));
        this.conf.setTargetCompactionFileSize(Long.parseLong(properties.getProperty("target_compaction_file_size", Long.toString(this.conf.getTargetCompactionFileSize()))));
        this.conf.setTargetChunkSize(Long.parseLong(properties.getProperty("target_chunk_size", Long.toString(this.conf.getTargetChunkSize()))));
        this.conf.setTargetChunkPointNum(Long.parseLong(properties.getProperty("target_chunk_point_num", Long.toString(this.conf.getTargetChunkPointNum()))));
        this.conf.setChunkPointNumLowerBoundInCompaction(Long.parseLong(properties.getProperty("chunk_point_num_lower_bound_in_compaction", Long.toString(this.conf.getChunkPointNumLowerBoundInCompaction()))));
        this.conf.setChunkSizeLowerBoundInCompaction(Long.parseLong(properties.getProperty("chunk_size_lower_bound_in_compaction", Long.toString(this.conf.getChunkSizeLowerBoundInCompaction()))));
        this.conf.setFileLimitPerInnerTask(Integer.parseInt(properties.getProperty("max_inner_compaction_candidate_file_num", Integer.toString(this.conf.getFileLimitPerInnerTask()))));
        this.conf.setFileLimitPerCrossTask(Integer.parseInt(properties.getProperty("max_cross_compaction_candidate_file_num", Integer.toString(this.conf.getFileLimitPerCrossTask()))));
        this.conf.setMaxCrossCompactionCandidateFileSize(Long.parseLong(properties.getProperty("max_cross_compaction_candidate_file_size", Long.toString(this.conf.getMaxCrossCompactionCandidateFileSize()))));
        this.conf.setMinCrossCompactionUnseqFileLevel(Integer.parseInt(properties.getProperty("min_cross_compaction_unseq_file_level", Integer.toString(this.conf.getMinCrossCompactionUnseqFileLevel()))));
        this.conf.setCompactionWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("compaction_write_throughput_mb_per_sec", Integer.toString(this.conf.getCompactionWriteThroughputMbPerSec()))));
        this.conf.setEnableTsFileValidation(Boolean.parseBoolean(properties.getProperty("enable_tsfile_validation", String.valueOf(this.conf.isEnableTsFileValidation()))));
        this.conf.setCandidateCompactionTaskQueueSize(Integer.parseInt(properties.getProperty("candidate_compaction_task_queue_size", Integer.toString(this.conf.getCandidateCompactionTaskQueueSize()))));
        this.conf.setEnablePartialInsert(Boolean.parseBoolean(properties.getProperty("enable_partial_insert", String.valueOf(this.conf.isEnablePartialInsert()))));
        this.conf.setEnable13DataInsertAdapt(Boolean.parseBoolean(properties.getProperty("0.13_data_insert_adapt", String.valueOf(this.conf.isEnable13DataInsertAdapt()))));
        int rpcSelectorThreadNum = Integer.parseInt(properties.getProperty("dn_rpc_selector_thread_count", Integer.toString(this.conf.getRpcSelectorThreadCount()).trim()));
        if (rpcSelectorThreadNum <= 0) {
            rpcSelectorThreadNum = 1;
        }
        this.conf.setRpcSelectorThreadCount(rpcSelectorThreadNum);
        int minConcurrentClientNum = Integer.parseInt(properties.getProperty("dn_rpc_min_concurrent_client_num", Integer.toString(this.conf.getRpcMinConcurrentClientNum()).trim()));
        if (minConcurrentClientNum <= 0) {
            minConcurrentClientNum = Runtime.getRuntime().availableProcessors();
        }
        this.conf.setRpcMinConcurrentClientNum(minConcurrentClientNum);
        int maxConcurrentClientNum = Integer.parseInt(properties.getProperty("dn_rpc_max_concurrent_client_num", Integer.toString(this.conf.getRpcMaxConcurrentClientNum()).trim()));
        if (maxConcurrentClientNum <= 0) {
            maxConcurrentClientNum = 65535;
        }
        this.conf.setRpcMaxConcurrentClientNum(maxConcurrentClientNum);
        this.loadAutoCreateSchemaProps(properties);
        this.conf.setTsFileStorageFs(properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().toString()));
        this.conf.setEnableHDFS(Boolean.parseBoolean(properties.getProperty("enable_hdfs", String.valueOf(this.conf.isEnableHDFS()))));
        this.conf.setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
        this.conf.setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
        this.conf.setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
        this.conf.setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
        this.conf.setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
        this.conf.setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
        this.conf.setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
        this.conf.setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
        this.conf.setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
        this.conf.setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
        this.conf.setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
        this.conf.setDevicePathCacheSize(Integer.parseInt(properties.getProperty("device_path_cache_size", String.valueOf(this.conf.getDevicePathCacheSize()))));
        this.conf.setConcurrentWritingTimePartition(Integer.parseInt(properties.getProperty("concurrent_writing_time_partition", String.valueOf(this.conf.getConcurrentWritingTimePartition()))));
        this.conf.setDefaultFillInterval(Integer.parseInt(properties.getProperty("default_fill_interval", String.valueOf(this.conf.getDefaultFillInterval()))));
        this.conf.setTagAttributeFlushInterval(Integer.parseInt(properties.getProperty("tag_attribute_flush_interval", String.valueOf(this.conf.getTagAttributeFlushInterval()))));
        this.conf.setPrimitiveArraySize(Integer.parseInt(properties.getProperty("primitive_array_size", String.valueOf(this.conf.getPrimitiveArraySize()))));
        this.conf.setThriftMaxFrameSize(Integer.parseInt(properties.getProperty("dn_thrift_max_frame_size", String.valueOf(this.conf.getThriftMaxFrameSize()))));
        if (this.conf.getThriftMaxFrameSize() < 0x800000) {
            this.conf.setThriftMaxFrameSize(0x800000);
        }
        this.conf.setThriftDefaultBufferSize(Integer.parseInt(properties.getProperty("dn_thrift_init_buffer_size", String.valueOf(this.conf.getThriftDefaultBufferSize()))));
        this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold", String.valueOf(this.conf.getSlowQueryThreshold()))));
        this.conf.setDataRegionNum(Integer.parseInt(properties.getProperty("data_region_num", String.valueOf(this.conf.getDataRegionNum()))));
        this.conf.setRecoveryLogIntervalInMs(Long.parseLong(properties.getProperty("recovery_log_interval_in_ms", String.valueOf(this.conf.getRecoveryLogIntervalInMs()))));
        this.conf.setEnableSeparateData(Boolean.parseBoolean(properties.getProperty("enable_separate_data", Boolean.toString(this.conf.isEnableSeparateData()))));
        this.conf.setWindowEvaluationThreadCount(Integer.parseInt(properties.getProperty("window_evaluation_thread_count", Integer.toString(this.conf.getWindowEvaluationThreadCount()))));
        if (this.conf.getWindowEvaluationThreadCount() <= 0) {
            this.conf.setWindowEvaluationThreadCount(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setMaxPendingWindowEvaluationTasks(Integer.parseInt(properties.getProperty("max_pending_window_evaluation_tasks", Integer.toString(this.conf.getMaxPendingWindowEvaluationTasks()))));
        if (this.conf.getMaxPendingWindowEvaluationTasks() <= 0) {
            this.conf.setMaxPendingWindowEvaluationTasks(64);
        }
        this.conf.setCachedMNodeSizeInPBTreeMode(Integer.parseInt(properties.getProperty("cached_mnode_size_in_pbtree_mode", String.valueOf(this.conf.getCachedMNodeSizeInPBTreeMode()))));
        this.conf.setMinimumSegmentInPBTree(Short.parseShort(properties.getProperty("minimum_pbtree_segment_in_bytes", String.valueOf(this.conf.getMinimumSegmentInPBTree()))));
        this.conf.setPageCacheSizeInPBTree(Integer.parseInt(properties.getProperty("page_cache_in_pbtree", String.valueOf(this.conf.getPageCacheSizeInPBTree()))));
        this.conf.setPBTreeLogSize(Integer.parseInt(properties.getProperty("pbtree_log_size", String.valueOf(this.conf.getPBTreeLogSize()))));
        this.conf.setMaxMeasurementNumOfInternalRequest(Integer.parseInt(properties.getProperty("max_measurement_num_of_internal_request", String.valueOf(this.conf.getMaxMeasurementNumOfInternalRequest()))));
        this.loadMqttProps(properties);
        this.conf.setIntoOperationBufferSizeInByte(Long.parseLong(properties.getProperty("into_operation_buffer_size_in_byte", String.valueOf(this.conf.getIntoOperationBufferSizeInByte()))));
        this.conf.setSelectIntoInsertTabletPlanRowLimit(Integer.parseInt(properties.getProperty("select_into_insert_tablet_plan_row_limit", String.valueOf(this.conf.getSelectIntoInsertTabletPlanRowLimit()))));
        this.conf.setIntoOperationExecutionThreadCount(Integer.parseInt(properties.getProperty("into_operation_execution_thread_count", String.valueOf(this.conf.getIntoOperationExecutionThreadCount()))));
        if (this.conf.getIntoOperationExecutionThreadCount() <= 0) {
            this.conf.setIntoOperationExecutionThreadCount(2);
        }
        this.conf.setMaxLoadingTimeseriesNumber(Integer.parseInt(properties.getProperty("max_loading_timeseries_number", String.valueOf(this.conf.getMaxLoadingTimeseriesNumber()))));
        this.conf.setExtPipeDir(properties.getProperty("ext_pipe_dir", this.conf.getExtPipeDir()).trim());
        ArrayList<FSType> fsTypes = new ArrayList<FSType>();
        fsTypes.add(FSType.LOCAL);
        if (Boolean.parseBoolean(properties.getProperty("enable_hdfs", String.valueOf(this.conf.isEnableHDFS())))) {
            fsTypes.add(FSType.HDFS);
        }
        TSFileDescriptor.getInstance().getConfig().setTSFileStorageFs(fsTypes.toArray(new FSType[0]));
        TSFileDescriptor.getInstance().getConfig().setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
        TSFileDescriptor.getInstance().getConfig().setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
        TSFileDescriptor.getInstance().getConfig().setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
        TSFileDescriptor.getInstance().getConfig().setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
        TSFileDescriptor.getInstance().getConfig().setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
        TSFileDescriptor.getInstance().getConfig().setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
        TSFileDescriptor.getInstance().getConfig().setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
        TSFileDescriptor.getInstance().getConfig().setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
        TSFileDescriptor.getInstance().getConfig().setPatternMatchingThreshold(Integer.parseInt(properties.getProperty("pattern_matching_threshold", String.valueOf(this.conf.getPatternMatchingThreshold()))));
        TSFileDescriptor.getInstance().getConfig().setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
        TSFileDescriptor.getInstance().getConfig().setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
        TSFileDescriptor.getInstance().getConfig().setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
        TSFileDescriptor.getInstance().getConfig().setBatchSize(this.conf.getBatchSize());
        this.conf.setCoordinatorReadExecutorSize(Integer.parseInt(properties.getProperty("coordinator_read_executor_size", Integer.toString(this.conf.getCoordinatorReadExecutorSize()))));
        this.conf.setCoordinatorWriteExecutorSize(Integer.parseInt(properties.getProperty("coordinator_write_executor_size", Integer.toString(this.conf.getCoordinatorWriteExecutorSize()))));
        this.commonDescriptor.loadCommonProps(properties);
        this.commonDescriptor.initCommonConfigDir(this.conf.getSystemDir());
        this.loadTimedService(properties);
        this.loadTsFileProps(properties);
        RpcTransportFactory.reInit();
        this.loadUDFProps(properties);
        this.initThriftSSL(properties);
        this.loadTriggerProps(properties);
        this.loadCQProps(properties);
        this.loadPipeProps(properties);
        this.loadClusterProps(properties);
        this.loadShuffleProps(properties);
        this.loadAuthorCache(properties);
        this.conf.setQuotaEnable(Boolean.parseBoolean(properties.getProperty("quota_enable", String.valueOf(this.conf.isQuotaEnable()))));
        this.conf.setSortBufferSize(Long.parseLong(properties.getProperty("sort_buffer_size_in_bytes", Long.toString(this.conf.getSortBufferSize())).trim()));
        this.conf.setSortTmpDir(properties.getProperty("sort_tmp_dir", this.conf.getSortTmpDir()));
        this.conf.setRateLimiterType(properties.getProperty("rate_limiter_type", this.conf.getRateLimiterType()));
        this.conf.setDataNodeSchemaCacheEvictionPolicy(properties.getProperty("datanode_schema_cache_eviction_policy", this.conf.getDataNodeSchemaCacheEvictionPolicy()));
        this.loadIoTConsensusProps(properties);
    }

    private void loadIoTConsensusProps(Properties properties) {
        this.conf.setMaxLogEntriesNumPerBatch(Integer.parseInt(properties.getProperty("data_region_iot_max_log_entries_num_per_batch", String.valueOf(this.conf.getMaxLogEntriesNumPerBatch())).trim()));
        this.conf.setMaxSizePerBatch(Integer.parseInt(properties.getProperty("data_region_iot_max_size_per_batch", String.valueOf(this.conf.getMaxSizePerBatch())).trim()));
        this.conf.setMaxPendingBatchesNum(Integer.parseInt(properties.getProperty("data_region_iot_max_pending_batches_num", String.valueOf(this.conf.getMaxPendingBatchesNum())).trim()));
        this.conf.setMaxMemoryRatioForQueue(Double.parseDouble(properties.getProperty("data_region_iot_max_memory_ratio_for_queue", String.valueOf(this.conf.getMaxMemoryRatioForQueue())).trim()));
    }

    private void loadAuthorCache(Properties properties) {
        this.conf.setAuthorCacheSize(Integer.parseInt(properties.getProperty("author_cache_size", String.valueOf(this.conf.getAuthorCacheSize()))));
        this.conf.setAuthorCacheExpireTime(Integer.parseInt(properties.getProperty("author_cache_expire_time", String.valueOf(this.conf.getAuthorCacheExpireTime()))));
    }

    private void loadWALProps(Properties properties) {
        int walBufferQueueCapacity;
        int walBufferSize;
        this.conf.setWalMode(WALMode.valueOf(properties.getProperty("wal_mode", this.conf.getWalMode().toString())));
        int maxWalNodesNum = Integer.parseInt(properties.getProperty("max_wal_nodes_num", Integer.toString(this.conf.getMaxWalNodesNum())));
        if (maxWalNodesNum > 0) {
            this.conf.setMaxWalNodesNum(maxWalNodesNum);
        }
        if ((walBufferSize = Integer.parseInt(properties.getProperty("wal_buffer_size_in_byte", Integer.toString(this.conf.getWalBufferSize())))) > 0) {
            this.conf.setWalBufferSize(walBufferSize);
        }
        if ((walBufferQueueCapacity = Integer.parseInt(properties.getProperty("wal_buffer_queue_capacity", Integer.toString(this.conf.getWalBufferQueueCapacity())))) > 0) {
            this.conf.setWalBufferQueueCapacity(walBufferQueueCapacity);
        }
        this.loadWALHotModifiedProps(properties);
    }

    private void loadCompactionHotModifiedProps(Properties properties) throws InterruptedException {
        this.loadCompactionIsEnabledHotModifiedProps(properties);
        boolean restartCompactionTaskManager = this.loadCompactionThreadCountHotModifiedProps(properties);
        if (restartCompactionTaskManager |= this.loadCompactionSubTaskCountHotModifiedProps(properties)) {
            CompactionTaskManager.getInstance().restart();
        }
    }

    private boolean loadCompactionThreadCountHotModifiedProps(Properties properties) {
        int newConfigCompactionThreadCount = Integer.parseInt(properties.getProperty("compaction_thread_count", Integer.toString(this.conf.getCompactionThreadCount())));
        if (newConfigCompactionThreadCount <= 0) {
            logger.error("compaction_thread_count must greater than 0");
            return false;
        }
        if (newConfigCompactionThreadCount == this.conf.getCompactionThreadCount()) {
            return false;
        }
        this.conf.setCompactionThreadCount(Integer.parseInt(properties.getProperty("compaction_thread_count", Integer.toString(this.conf.getCompactionThreadCount()))));
        return true;
    }

    private boolean loadCompactionSubTaskCountHotModifiedProps(Properties properties) {
        int newConfigSubtaskNum = Integer.parseInt(properties.getProperty("sub_compaction_thread_count", Integer.toString(this.conf.getSubCompactionTaskNum())));
        if (newConfigSubtaskNum <= 0) {
            logger.error("sub_compaction_thread_count must greater than 0");
            return false;
        }
        if (newConfigSubtaskNum == this.conf.getSubCompactionTaskNum()) {
            return false;
        }
        this.conf.setSubCompactionTaskNum(newConfigSubtaskNum);
        return true;
    }

    private void loadCompactionIsEnabledHotModifiedProps(Properties properties) {
        boolean compactionEnabledInNewConfig;
        boolean isCompactionEnabled = this.conf.isEnableSeqSpaceCompaction() || this.conf.isEnableUnseqSpaceCompaction() || this.conf.isEnableCrossSpaceCompaction() || this.conf.isEnableInsertionCrossSpaceCompaction();
        boolean newConfigEnableInsertionCrossSpaceCompaction = Boolean.parseBoolean(properties.getProperty("enable_insertion_cross_space_compaction", Boolean.toString(this.conf.isEnableInsertionCrossSpaceCompaction())));
        boolean newConfigEnableCrossSpaceCompaction = Boolean.parseBoolean(properties.getProperty("enable_cross_space_compaction", Boolean.toString(this.conf.isEnableCrossSpaceCompaction())));
        boolean newConfigEnableSeqSpaceCompaction = Boolean.parseBoolean(properties.getProperty("enable_seq_space_compaction", Boolean.toString(this.conf.isEnableSeqSpaceCompaction())));
        boolean newConfigEnableUnseqSpaceCompaction = Boolean.parseBoolean(properties.getProperty("enable_unseq_space_compaction", Boolean.toString(this.conf.isEnableUnseqSpaceCompaction())));
        boolean bl = compactionEnabledInNewConfig = newConfigEnableCrossSpaceCompaction || newConfigEnableInsertionCrossSpaceCompaction || newConfigEnableSeqSpaceCompaction || newConfigEnableUnseqSpaceCompaction;
        if (!isCompactionEnabled && compactionEnabledInNewConfig) {
            logger.error("Compaction cannot start in current status.");
            return;
        }
        this.conf.setEnableInsertionCrossSpaceCompaction(newConfigEnableInsertionCrossSpaceCompaction);
        this.conf.setEnableCrossSpaceCompaction(newConfigEnableCrossSpaceCompaction);
        this.conf.setEnableSeqSpaceCompaction(newConfigEnableSeqSpaceCompaction);
        this.conf.setEnableUnseqSpaceCompaction(newConfigEnableUnseqSpaceCompaction);
    }

    private void loadWALHotModifiedProps(Properties properties) {
        long cacheWindowInMs;
        long throttleDownThresholdInByte;
        long deleteWalFilesPeriod;
        int maxWalMemTableSnapshotNum;
        long walMemTableSnapshotThreshold;
        double walMinEffectiveInfoRatio;
        long walFileSizeThreshold;
        long walSyncModeFsyncDelayInMs;
        long walAsyncModeFsyncDelayInMs = Long.parseLong(properties.getProperty("wal_async_mode_fsync_delay_in_ms", Long.toString(this.conf.getWalAsyncModeFsyncDelayInMs())));
        if (walAsyncModeFsyncDelayInMs > 0L) {
            this.conf.setWalAsyncModeFsyncDelayInMs(walAsyncModeFsyncDelayInMs);
        }
        if ((walSyncModeFsyncDelayInMs = Long.parseLong(properties.getProperty("wal_sync_mode_fsync_delay_in_ms", Long.toString(this.conf.getWalSyncModeFsyncDelayInMs())))) > 0L) {
            this.conf.setWalSyncModeFsyncDelayInMs(walSyncModeFsyncDelayInMs);
        }
        if ((walFileSizeThreshold = Long.parseLong(properties.getProperty("wal_file_size_threshold_in_byte", Long.toString(this.conf.getWalFileSizeThresholdInByte())))) > 0L) {
            this.conf.setWalFileSizeThresholdInByte(walFileSizeThreshold);
        }
        if ((walMinEffectiveInfoRatio = Double.parseDouble(properties.getProperty("wal_min_effective_info_ratio", Double.toString(this.conf.getWalMinEffectiveInfoRatio())))) > 0.0) {
            this.conf.setWalMinEffectiveInfoRatio(walMinEffectiveInfoRatio);
        }
        if ((walMemTableSnapshotThreshold = Long.parseLong(properties.getProperty("wal_memtable_snapshot_threshold_in_byte", Long.toString(this.conf.getWalMemTableSnapshotThreshold())))) > 0L) {
            this.conf.setWalMemTableSnapshotThreshold(walMemTableSnapshotThreshold);
        }
        if ((maxWalMemTableSnapshotNum = Integer.parseInt(properties.getProperty("max_wal_memtable_snapshot_num", Integer.toString(this.conf.getMaxWalMemTableSnapshotNum())))) > 0) {
            this.conf.setMaxWalMemTableSnapshotNum(maxWalMemTableSnapshotNum);
        }
        if ((deleteWalFilesPeriod = Long.parseLong(properties.getProperty("delete_wal_files_period_in_ms", Long.toString(this.conf.getDeleteWalFilesPeriodInMs())))) > 0L) {
            this.conf.setDeleteWalFilesPeriodInMs(deleteWalFilesPeriod);
        }
        if ((throttleDownThresholdInByte = Long.parseLong(properties.getProperty("iot_consensus_throttle_threshold_in_byte", Long.toString(this.conf.getThrottleThreshold())))) > 0L) {
            this.conf.setThrottleThreshold(throttleDownThresholdInByte);
        }
        if ((cacheWindowInMs = Long.parseLong(properties.getProperty("iot_consensus_cache_window_time_in_ms", Long.toString(this.conf.getCacheWindowTimeInMs())))) > 0L) {
            this.conf.setCacheWindowTimeInMs(cacheWindowInMs);
        }
    }

    private void loadAutoCreateSchemaProps(Properties properties) {
        this.conf.setAutoCreateSchemaEnabled(Boolean.parseBoolean(properties.getProperty("enable_auto_create_schema", Boolean.toString(this.conf.isAutoCreateSchemaEnabled()).trim())));
        this.conf.setBooleanStringInferType(TSDataType.valueOf((String)properties.getProperty("boolean_string_infer_type", this.conf.getBooleanStringInferType().toString())));
        this.conf.setIntegerStringInferType(TSDataType.valueOf((String)properties.getProperty("integer_string_infer_type", this.conf.getIntegerStringInferType().toString())));
        this.conf.setLongStringInferType(TSDataType.valueOf((String)properties.getProperty("long_string_infer_type", this.conf.getLongStringInferType().toString())));
        this.conf.setFloatingStringInferType(TSDataType.valueOf((String)properties.getProperty("floating_string_infer_type", this.conf.getFloatingStringInferType().toString())));
        this.conf.setNanStringInferType(TSDataType.valueOf((String)properties.getProperty("nan_string_infer_type", this.conf.getNanStringInferType().toString())));
        this.conf.setDefaultStorageGroupLevel(Integer.parseInt(properties.getProperty("default_storage_group_level", Integer.toString(this.conf.getDefaultStorageGroupLevel()))));
        this.conf.setDefaultBooleanEncoding(properties.getProperty("default_boolean_encoding", this.conf.getDefaultBooleanEncoding().toString()));
        this.conf.setDefaultInt32Encoding(properties.getProperty("default_int32_encoding", this.conf.getDefaultInt32Encoding().toString()));
        this.conf.setDefaultInt64Encoding(properties.getProperty("default_int64_encoding", this.conf.getDefaultInt64Encoding().toString()));
        this.conf.setDefaultFloatEncoding(properties.getProperty("default_float_encoding", this.conf.getDefaultFloatEncoding().toString()));
        this.conf.setDefaultDoubleEncoding(properties.getProperty("default_double_encoding", this.conf.getDefaultDoubleEncoding().toString()));
        this.conf.setDefaultTextEncoding(properties.getProperty("default_text_encoding", this.conf.getDefaultTextEncoding().toString()));
    }

    private void loadTsFileProps(Properties properties) {
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(Integer.parseInt(properties.getProperty("group_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()))));
        TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(Integer.parseInt(properties.getProperty("page_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()))));
        if (TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() > TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()) {
            logger.warn("page_size is greater than group size, will set it as the same with group size");
            TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte());
        }
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.parseInt(properties.getProperty("max_number_of_points_in_page", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage()))));
        TSFileDescriptor.getInstance().getConfig().setMaxStringLength(Integer.parseInt(properties.getProperty("max_string_length", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxStringLength()))));
        TSFileDescriptor.getInstance().getConfig().setBloomFilterErrorRate(Double.parseDouble(properties.getProperty("bloom_filter_error_rate", Double.toString(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate()))));
        TSFileDescriptor.getInstance().getConfig().setFloatPrecision(Integer.parseInt(properties.getProperty("float_precision", Integer.toString(TSFileDescriptor.getInstance().getConfig().getFloatPrecision()))));
        TSFileDescriptor.getInstance().getConfig().setValueEncoder(properties.getProperty("value_encoder", TSFileDescriptor.getInstance().getConfig().getValueEncoder()));
        TSFileDescriptor.getInstance().getConfig().setCompressor(properties.getProperty("compressor", TSFileDescriptor.getInstance().getConfig().getCompressor().toString()));
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(Integer.parseInt(properties.getProperty("max_degree_of_index_node", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode()))));
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes(Integer.parseInt(properties.getProperty("max_tsblock_size_in_bytes", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes()))));
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes((int)Math.min((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), this.conf.getMaxBytesPerFragmentInstance()));
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockLineNumber(Integer.parseInt(properties.getProperty("max_tsblock_line_number", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber()))));
    }

    private void loadMqttProps(Properties properties) {
        this.conf.setMqttDir(properties.getProperty("mqtt_root_dir", this.conf.getMqttDir()));
        if (properties.getProperty("mqtt_host") != null) {
            this.conf.setMqttHost(properties.getProperty("mqtt_host"));
        } else {
            logger.info("MQTT host is not configured, will use dn_rpc_address.");
            this.conf.setMqttHost(properties.getProperty("dn_rpc_address", this.conf.getRpcAddress().trim()));
        }
        if (properties.getProperty("mqtt_port") != null) {
            this.conf.setMqttPort(Integer.parseInt(properties.getProperty("mqtt_port")));
        }
        if (properties.getProperty("mqtt_handler_pool_size") != null) {
            this.conf.setMqttHandlerPoolSize(Integer.parseInt(properties.getProperty("mqtt_handler_pool_size")));
        }
        if (properties.getProperty("mqtt_payload_formatter") != null) {
            this.conf.setMqttPayloadFormatter(properties.getProperty("mqtt_payload_formatter"));
        }
        if (properties.getProperty("enable_mqtt_service") != null) {
            this.conf.setEnableMQTTService(Boolean.parseBoolean(properties.getProperty("enable_mqtt_service")));
        }
        if (properties.getProperty("mqtt_max_message_size") != null) {
            this.conf.setMqttMaxMessageSize(Integer.parseInt(properties.getProperty("mqtt_max_message_size")));
        }
    }

    private void loadTimedService(Properties properties) {
        long unseqMemTableFlushCheckInterval;
        long seqMemTableFlushCheckInterval;
        this.conf.setEnableTimedFlushSeqMemtable(Boolean.parseBoolean(properties.getProperty("enable_timed_flush_seq_memtable", Boolean.toString(this.conf.isEnableTimedFlushSeqMemtable()))));
        long seqMemTableFlushInterval = Long.parseLong(properties.getProperty("seq_memtable_flush_interval_in_ms", Long.toString(this.conf.getSeqMemtableFlushInterval())).trim());
        if (seqMemTableFlushInterval > 0L) {
            this.conf.setSeqMemtableFlushInterval(seqMemTableFlushInterval);
        }
        if ((seqMemTableFlushCheckInterval = Long.parseLong(properties.getProperty("seq_memtable_flush_check_interval_in_ms", Long.toString(this.conf.getSeqMemtableFlushCheckInterval())).trim())) > 0L) {
            this.conf.setSeqMemtableFlushCheckInterval(seqMemTableFlushCheckInterval);
        }
        this.conf.setEnableTimedFlushUnseqMemtable(Boolean.parseBoolean(properties.getProperty("enable_timed_flush_unseq_memtable", Boolean.toString(this.conf.isEnableTimedFlushUnseqMemtable()))));
        long unseqMemTableFlushInterval = Long.parseLong(properties.getProperty("unseq_memtable_flush_interval_in_ms", Long.toString(this.conf.getUnseqMemtableFlushInterval())).trim());
        if (unseqMemTableFlushInterval > 0L) {
            this.conf.setUnseqMemtableFlushInterval(unseqMemTableFlushInterval);
        }
        if ((unseqMemTableFlushCheckInterval = Long.parseLong(properties.getProperty("unseq_memtable_flush_check_interval_in_ms", Long.toString(this.conf.getUnseqMemtableFlushCheckInterval())).trim())) > 0L) {
            this.conf.setUnseqMemtableFlushCheckInterval(unseqMemTableFlushCheckInterval);
        }
    }

    private String[][] parseDataDirs(String dataDirs) {
        String[] tiers = dataDirs.split(";");
        String[][] tierDataDirs = new String[tiers.length][];
        for (int i = 0; i < tiers.length; ++i) {
            tierDataDirs[i] = tiers[i].split(",");
        }
        return tierDataDirs;
    }

    public void loadHotModifiedProps(Properties properties) throws QueryProcessException {
        try {
            String multiDirStrategyClassName;
            String dataDirs = properties.getProperty("dn_data_dirs", null);
            if (dataDirs != null) {
                this.conf.reloadDataDirs(this.parseDataDirs(dataDirs));
            }
            if ((multiDirStrategyClassName = properties.getProperty("dn_multi_dir_strategy", null)) != null && !multiDirStrategyClassName.equals(this.conf.getMultiDirStrategyClassName())) {
                this.conf.setMultiDirStrategyClassName(multiDirStrategyClassName);
                this.conf.confirmMultiDirStrategy();
            }
            TierManager.getInstance().resetFolders();
            this.loadTimedService(properties);
            StorageEngine.getInstance().rebootTimedService();
            long memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim());
            if (memTableSizeThreshold > 0L) {
                this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
            }
            this.loadAutoCreateSchemaProps(properties);
            this.loadTsFileProps(properties);
            this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold", Long.toString(this.conf.getSlowQueryThreshold()))));
            this.conf.setCompactionWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("merge_write_throughput_mb_per_sec", Integer.toString(this.conf.getCompactionWriteThroughputMbPerSec()))));
            this.conf.setIntoOperationBufferSizeInByte(Long.parseLong(properties.getProperty("into_operation_buffer_size_in_byte", String.valueOf(this.conf.getIntoOperationBufferSizeInByte()))));
            this.conf.setSelectIntoInsertTabletPlanRowLimit(Integer.parseInt(properties.getProperty("select_into_insert_tablet_plan_row_limit", String.valueOf(this.conf.getSelectIntoInsertTabletPlanRowLimit()))));
            this.conf.setEnableQueryMemoryEstimation(Boolean.parseBoolean(properties.getProperty("enable_query_memory_estimation", Boolean.toString(this.conf.isEnableQueryMemoryEstimation()))));
            this.conf.setEnableTsFileValidation(Boolean.parseBoolean(properties.getProperty("enable_tsfile_validation", String.valueOf(this.conf.isEnableTsFileValidation()))));
            long prevDeleteWalFilesPeriodInMs = this.conf.getDeleteWalFilesPeriodInMs();
            this.loadWALHotModifiedProps(properties);
            if (prevDeleteWalFilesPeriodInMs != this.conf.getDeleteWalFilesPeriodInMs()) {
                WALManager.getInstance().rebootWALDeleteThread();
            }
            this.loadCompactionHotModifiedProps(properties);
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Fail to reload configuration because %s", e));
        }
    }

    public void loadHotModifiedProps() throws QueryProcessException {
        InputStream inputStream;
        URL url = this.getPropsUrl("iotdb-common.properties");
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        Properties commonProperties = new Properties();
        try {
            inputStream = url.openStream();
            try {
                logger.info("Start to reload config file {}", (Object)url);
                commonProperties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Fail to reload config file {}", (Object)url, (Object)e);
            throw new QueryProcessException(String.format("Fail to reload config file %s because %s", url, e.getMessage()));
        }
        url = this.getPropsUrl("iotdb-datanode.properties");
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        try {
            inputStream = url.openStream();
            try {
                logger.info("Start to reload config file {}", (Object)url);
                Properties properties = new Properties();
                properties.load(inputStream);
                commonProperties.putAll((Map<?, ?>)properties);
                this.loadHotModifiedProps(commonProperties);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Fail to reload config file {}", (Object)url, (Object)e);
            throw new QueryProcessException(String.format("Fail to reload config file %s because %s", url, e.getMessage()));
        }
        ReloadLevel reloadLevel = MetricConfigDescriptor.getInstance().loadHotProps(commonProperties);
        logger.info("Reload metric service in level {}", (Object)reloadLevel);
        if (reloadLevel == ReloadLevel.RESTART_INTERNAL_REPORTER) {
            IoTDBInternalLocalReporter internalReporter = MetricConfigDescriptor.getInstance().getMetricConfig().getInternalReportType() == InternalReporterType.IOTDB ? new IoTDBInternalLocalReporter() : new IoTDBInternalMemoryReporter();
            MetricService.getInstance().reloadInternalReporter((IoTDBInternalReporter)internalReporter);
        } else {
            MetricService.getInstance().reloadService(reloadLevel);
        }
    }

    private void initMemoryAllocate(Properties properties) {
        String memoryAllocateProportion = properties.getProperty("datanode_memory_proportion", null);
        if (memoryAllocateProportion == null && (memoryAllocateProportion = properties.getProperty("storage_query_schema_consensus_free_memory_proportion")) != null) {
            logger.warn("The parameter storage_query_schema_consensus_free_memory_proportion is deprecated since v1.2.3, please use datanode_memory_proportion instead.");
        }
        if (memoryAllocateProportion != null) {
            String[] proportions = memoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = Runtime.getRuntime().maxMemory();
            if (proportionSum != 0) {
                this.conf.setAllocateMemoryForStorageEngine(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForRead(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForSchema(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForConsensus(maxMemoryAvailable * (long)Integer.parseInt(proportions[3].trim()) / (long)proportionSum);
                if (proportions.length >= 6) {
                    this.conf.setAllocateMemoryForPipe(maxMemoryAvailable * (long)Integer.parseInt(proportions[4].trim()) / (long)proportionSum);
                } else {
                    this.conf.setAllocateMemoryForPipe((maxMemoryAvailable - (this.conf.getAllocateMemoryForStorageEngine() + this.conf.getAllocateMemoryForRead() + this.conf.getAllocateMemoryForSchema() + this.conf.getAllocateMemoryForConsensus())) / 2L);
                }
            }
        }
        logger.info("initial allocateMemoryForRead = {}", (Object)this.conf.getAllocateMemoryForRead());
        logger.info("initial allocateMemoryForWrite = {}", (Object)this.conf.getAllocateMemoryForStorageEngine());
        logger.info("initial allocateMemoryForSchema = {}", (Object)this.conf.getAllocateMemoryForSchema());
        logger.info("initial allocateMemoryForConsensus = {}", (Object)this.conf.getAllocateMemoryForConsensus());
        logger.info("initial allocateMemoryForPipe = {}", (Object)this.conf.getAllocateMemoryForPipe());
        this.initSchemaMemoryAllocate(properties);
        this.initStorageEngineAllocate(properties);
        this.conf.setEnableQueryMemoryEstimation(Boolean.parseBoolean(properties.getProperty("enable_query_memory_estimation", Boolean.toString(this.conf.isEnableQueryMemoryEstimation()))));
        String queryMemoryAllocateProportion = properties.getProperty("chunk_timeseriesmeta_free_memory_proportion");
        if (queryMemoryAllocateProportion != null) {
            String[] proportions = queryMemoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = this.conf.getAllocateMemoryForRead();
            if (proportionSum != 0) {
                try {
                    this.conf.setAllocateMemoryForBloomFilterCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForChunkCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForTimeSeriesMetaDataCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForCoordinator(maxMemoryAvailable * (long)Integer.parseInt(proportions[3].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForOperators(maxMemoryAvailable * (long)Integer.parseInt(proportions[4].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForDataExchange(maxMemoryAvailable * (long)Integer.parseInt(proportions[5].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForTimeIndex(maxMemoryAvailable * (long)Integer.parseInt(proportions[6].trim()) / (long)proportionSum);
                }
                catch (Exception e) {
                    throw new RuntimeException("Each subsection of configuration item chunkmeta_chunk_timeseriesmeta_free_memory_proportion should be an integer, which is " + queryMemoryAllocateProportion);
                }
            }
        }
        if (!this.conf.isMetaDataCacheEnable()) {
            long sum = this.conf.getAllocateMemoryForBloomFilterCache() + this.conf.getAllocateMemoryForChunkCache() + this.conf.getAllocateMemoryForTimeSeriesMetaDataCache();
            this.conf.setAllocateMemoryForBloomFilterCache(0L);
            this.conf.setAllocateMemoryForChunkCache(0L);
            this.conf.setAllocateMemoryForTimeSeriesMetaDataCache(0L);
            long partForDataExchange = sum / 2L;
            long partForOperators = sum - partForDataExchange;
            this.conf.setAllocateMemoryForDataExchange(this.conf.getAllocateMemoryForDataExchange() + partForDataExchange);
            this.conf.setAllocateMemoryForOperators(this.conf.getAllocateMemoryForOperators() + partForOperators);
        }
    }

    private void initStorageEngineAllocate(Properties properties) {
        String allocationRatioForWrite;
        long storageMemoryTotal = this.conf.getAllocateMemoryForStorageEngine();
        int proportionSum = 10;
        int writeProportion = 8;
        int compactionProportion = 2;
        int writeProportionSum = 20;
        int memTableProportion = 19;
        int timePartitionInfo = 1;
        String storageMemoryAllocatePortion = properties.getProperty("storage_engine_memory_proportion");
        if (storageMemoryAllocatePortion != null) {
            String[] proportions = storageMemoryAllocatePortion.split(":");
            int loadedProportionSum = 0;
            for (String proportion : proportions) {
                loadedProportionSum += Integer.parseInt(proportion.trim());
            }
            if (loadedProportionSum != 0) {
                proportionSum = loadedProportionSum;
                writeProportion = Integer.parseInt(proportions[0].trim());
                compactionProportion = Integer.parseInt(proportions[1].trim());
            }
            this.conf.setCompactionProportion((double)compactionProportion / (double)proportionSum);
        }
        if ((allocationRatioForWrite = properties.getProperty("write_memory_proportion")) != null) {
            String[] proportions = allocationRatioForWrite.split(":");
            int loadedProportionSum = 0;
            for (String proportion : proportions) {
                loadedProportionSum += Integer.parseInt(proportion.trim());
            }
            if (loadedProportionSum != 0) {
                writeProportionSum = loadedProportionSum;
                memTableProportion = Integer.parseInt(proportions[0].trim());
                timePartitionInfo = Integer.parseInt(proportions[1].trim());
            }
            double memtableProportionForWrite = (double)memTableProportion / (double)writeProportionSum;
            double timePartitionInfoForWrite = (double)timePartitionInfo / (double)writeProportionSum;
            double proportionForWrite = (double)writeProportion / (double)proportionSum;
            this.conf.setWriteProportionForMemtable(proportionForWrite * memtableProportionForWrite);
            this.conf.setAllocateMemoryForTimePartitionInfo((long)(proportionForWrite * timePartitionInfoForWrite * (double)storageMemoryTotal));
        }
    }

    private void initSchemaMemoryAllocate(Properties properties) {
        String proportion;
        int n;
        int n2;
        String[] stringArray;
        int loadedProportionSum;
        String[] proportions;
        long schemaMemoryTotal = this.conf.getAllocateMemoryForSchema();
        String schemaMemoryPortionInput = properties.getProperty("schema_memory_proportion");
        if (schemaMemoryPortionInput != null) {
            proportions = schemaMemoryPortionInput.split(":");
            loadedProportionSum = 0;
            stringArray = proportions;
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                proportion = stringArray[n];
                loadedProportionSum += Integer.parseInt(proportion.trim());
            }
            if (loadedProportionSum != 0) {
                this.conf.setSchemaMemoryProportion(new int[]{Integer.parseInt(proportions[0].trim()), Integer.parseInt(proportions[1].trim()), Integer.parseInt(proportions[2].trim())});
            }
        } else {
            schemaMemoryPortionInput = properties.getProperty("schema_memory_allocate_proportion");
            if (schemaMemoryPortionInput != null) {
                proportions = schemaMemoryPortionInput.split(":");
                loadedProportionSum = 0;
                stringArray = proportions;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    proportion = stringArray[n];
                    loadedProportionSum += Integer.parseInt(proportion.trim());
                }
                if (loadedProportionSum != 0) {
                    this.conf.setSchemaMemoryProportion(new int[]{Integer.parseInt(proportions[0].trim()), Integer.parseInt(proportions[1].trim()) + Integer.parseInt(proportions[3].trim()), Integer.parseInt(proportions[2].trim())});
                }
            }
        }
        int proportionSum = 0;
        for (int proportion2 : this.conf.getSchemaMemoryProportion()) {
            proportionSum += proportion2;
        }
        this.conf.setAllocateMemoryForSchemaRegion(schemaMemoryTotal * (long)this.conf.getSchemaMemoryProportion()[0] / (long)proportionSum);
        logger.info("allocateMemoryForSchemaRegion = {}", (Object)this.conf.getAllocateMemoryForSchemaRegion());
        this.conf.setAllocateMemoryForSchemaCache(schemaMemoryTotal * (long)this.conf.getSchemaMemoryProportion()[1] / (long)proportionSum);
        logger.info("allocateMemoryForSchemaCache = {}", (Object)this.conf.getAllocateMemoryForSchemaCache());
        this.conf.setAllocateMemoryForPartitionCache(schemaMemoryTotal * (long)this.conf.getSchemaMemoryProportion()[2] / (long)proportionSum);
        logger.info("allocateMemoryForPartitionCache = {}", (Object)this.conf.getAllocateMemoryForPartitionCache());
    }

    private void loadUDFProps(Properties properties) {
        String readerTransformerCollectorMemoryProportion;
        String initialByteArrayLengthForMemoryControl = properties.getProperty("udf_initial_byte_array_length_for_memory_control");
        if (initialByteArrayLengthForMemoryControl != null) {
            this.conf.setUdfInitialByteArrayLengthForMemoryControl(Integer.parseInt(initialByteArrayLengthForMemoryControl));
        }
        this.conf.setUdfDir(properties.getProperty("udf_lib_dir", this.conf.getUdfDir()));
        String memoryBudgetInMb = properties.getProperty("udf_memory_budget_in_mb");
        if (memoryBudgetInMb != null) {
            this.conf.setUdfMemoryBudgetInMB((float)Math.min((double)Float.parseFloat(memoryBudgetInMb), 0.2 * (double)this.conf.getAllocateMemoryForRead()));
        }
        if ((readerTransformerCollectorMemoryProportion = properties.getProperty("udf_reader_transformer_collector_memory_proportion")) != null) {
            String[] proportions = readerTransformerCollectorMemoryProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            float maxMemoryAvailable = this.conf.getUdfMemoryBudgetInMB();
            try {
                this.conf.setUdfReaderMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[0].trim()) / (float)proportionSum);
                this.conf.setUdfTransformerMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[1].trim()) / (float)proportionSum);
                this.conf.setUdfCollectorMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[2].trim()) / (float)proportionSum);
            }
            catch (Exception e) {
                throw new RuntimeException("Each subsection of configuration item udf_reader_transformer_collector_memory_proportion should be an integer, which is " + readerTransformerCollectorMemoryProportion);
            }
        }
    }

    private void initThriftSSL(Properties properties) {
        this.conf.setEnableSSL(Boolean.parseBoolean(properties.getProperty("enable_thrift_ssl", Boolean.toString(this.conf.isEnableSSL()))));
        this.conf.setKeyStorePath(properties.getProperty("key_store_path", this.conf.getKeyStorePath()).trim());
        this.conf.setKeyStorePwd(properties.getProperty("key_store_pwd", this.conf.getKeyStorePath()).trim());
    }

    private void loadTriggerProps(Properties properties) {
        this.conf.setTriggerDir(properties.getProperty("trigger_lib_dir", this.conf.getTriggerDir()));
        this.conf.setRetryNumToFindStatefulTrigger(Integer.parseInt(properties.getProperty("stateful_trigger_retry_num_when_not_found", Integer.toString(this.conf.getRetryNumToFindStatefulTrigger()))));
        int tlogBufferSize = Integer.parseInt(properties.getProperty("tlog_buffer_size", Integer.toString(this.conf.getTlogBufferSize())));
        if (tlogBufferSize > 0) {
            this.conf.setTlogBufferSize(tlogBufferSize);
        }
        this.conf.setTriggerForwardMaxQueueNumber(Integer.parseInt(properties.getProperty("trigger_forward_max_queue_number", Integer.toString(this.conf.getTriggerForwardMaxQueueNumber()))));
        this.conf.setTriggerForwardMaxSizePerQueue(Integer.parseInt(properties.getProperty("trigger_forward_max_size_per_queue", Integer.toString(this.conf.getTriggerForwardMaxSizePerQueue()))));
        this.conf.setTriggerForwardBatchSize(Integer.parseInt(properties.getProperty("trigger_forward_batch_size", Integer.toString(this.conf.getTriggerForwardBatchSize()))));
        this.conf.setTriggerForwardHTTPPoolSize(Integer.parseInt(properties.getProperty("trigger_forward_http_pool_size", Integer.toString(this.conf.getTriggerForwardHTTPPoolSize()))));
        this.conf.setTriggerForwardHTTPPOOLMaxPerRoute(Integer.parseInt(properties.getProperty("trigger_forward_http_pool_max_per_route", Integer.toString(this.conf.getTriggerForwardHTTPPOOLMaxPerRoute()))));
        this.conf.setTriggerForwardMQTTPoolSize(Integer.parseInt(properties.getProperty("trigger_forward_mqtt_pool_size", Integer.toString(this.conf.getTriggerForwardMQTTPoolSize()))));
    }

    private void loadPipeProps(Properties properties) {
        this.conf.setPipeLibDir(properties.getProperty("pipe_lib_dir", this.conf.getPipeLibDir()));
        this.conf.setPipeReceiverFileDirs((String[])Arrays.stream(properties.getProperty("pipe_receiver_file_dirs", String.join((CharSequence)",", this.conf.getPipeReceiverFileDirs())).trim().split(",")).filter(dir -> !dir.isEmpty()).toArray(String[]::new));
    }

    private void loadCQProps(Properties properties) {
        this.conf.setContinuousQueryThreadNum(Integer.parseInt(properties.getProperty("continuous_query_thread_num", Integer.toString(this.conf.getContinuousQueryThreadNum()))));
        if (this.conf.getContinuousQueryThreadNum() <= 0) {
            this.conf.setContinuousQueryThreadNum(Runtime.getRuntime().availableProcessors() / 2);
        }
        this.conf.setContinuousQueryMinimumEveryInterval(DateTimeUtils.convertDurationStrToLong(properties.getProperty("continuous_query_minimum_every_interval", "1s"), CommonDescriptor.getInstance().getConfig().getTimestampPrecision(), false));
    }

    public void loadClusterProps(Properties properties) throws IOException {
        String configNodeUrls = properties.getProperty("dn_seed_config_node");
        if (configNodeUrls == null) {
            configNodeUrls = properties.getProperty("dn_target_config_node_list");
            logger.warn("The parameter dn_target_config_node_list has been abandoned, only the first ConfigNode address will be used to join in the cluster. Please use dn_seed_config_node instead.");
        }
        if (configNodeUrls != null) {
            try {
                configNodeUrls = configNodeUrls.trim();
                this.conf.setSeedConfigNode((TEndPoint)NodeUrlUtils.parseTEndPointUrls((String)configNodeUrls).get(0));
            }
            catch (BadNodeUrlException e) {
                logger.error("ConfigNodes are set in wrong format, please set them like 127.0.0.1:10710");
            }
        } else {
            throw new IOException("The parameter dn_seed_config_node is not set, this DataNode will not join in any cluster.");
        }
        this.conf.setInternalAddress(properties.getProperty("dn_internal_address", this.conf.getInternalAddress()).trim());
        this.conf.setInternalPort(Integer.parseInt(properties.getProperty("dn_internal_port", Integer.toString(this.conf.getInternalPort())).trim()));
        this.conf.setDataRegionConsensusPort(Integer.parseInt(properties.getProperty("dn_data_region_consensus_port", Integer.toString(this.conf.getDataRegionConsensusPort())).trim()));
        this.conf.setSchemaRegionConsensusPort(Integer.parseInt(properties.getProperty("dn_schema_region_consensus_port", Integer.toString(this.conf.getSchemaRegionConsensusPort())).trim()));
        this.conf.setJoinClusterRetryIntervalMs(Long.parseLong(properties.getProperty("dn_join_cluster_retry_interval_ms", Long.toString(this.conf.getJoinClusterRetryIntervalMs())).trim()));
    }

    public void loadShuffleProps(Properties properties) {
        this.conf.setMppDataExchangePort(Integer.parseInt(properties.getProperty("dn_mpp_data_exchange_port", Integer.toString(this.conf.getMppDataExchangePort()))));
        this.conf.setMppDataExchangeCorePoolSize(Integer.parseInt(properties.getProperty("mpp_data_exchange_core_pool_size", Integer.toString(this.conf.getMppDataExchangeCorePoolSize()))));
        this.conf.setMppDataExchangeMaxPoolSize(Integer.parseInt(properties.getProperty("mpp_data_exchange_max_pool_size", Integer.toString(this.conf.getMppDataExchangeMaxPoolSize()))));
        this.conf.setMppDataExchangeKeepAliveTimeInMs(Integer.parseInt(properties.getProperty("mpp_data_exchange_keep_alive_time_in_ms", Integer.toString(this.conf.getMppDataExchangeKeepAliveTimeInMs()))));
        this.conf.setPartitionCacheSize(Integer.parseInt(properties.getProperty("partition_cache_size", Integer.toString(this.conf.getPartitionCacheSize()))));
        this.conf.setDriverTaskExecutionTimeSliceInMs(Integer.parseInt(properties.getProperty("driver_task_execution_time_slice_in_ms", Integer.toString(this.conf.getDriverTaskExecutionTimeSliceInMs()))));
    }

    public TSEncoding getDefaultEncodingByType(TSDataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return this.conf.getDefaultBooleanEncoding();
            }
            case INT32: {
                return this.conf.getDefaultInt32Encoding();
            }
            case INT64: {
                return this.conf.getDefaultInt64Encoding();
            }
            case FLOAT: {
                return this.conf.getDefaultFloatEncoding();
            }
            case DOUBLE: {
                return this.conf.getDefaultDoubleEncoding();
            }
        }
        return this.conf.getDefaultTextEncoding();
    }

    public void loadGlobalConfig(TGlobalConfig globalConfig) {
        this.conf.setSeriesPartitionExecutorClass(globalConfig.getSeriesPartitionExecutorClass());
        this.conf.setSeriesPartitionSlotNum(globalConfig.getSeriesPartitionSlotNum());
        this.conf.setReadConsistencyLevel(globalConfig.getReadConsistencyLevel());
    }

    public void loadRatisConfig(TRatisConfig ratisConfig) {
        this.conf.setDataRatisConsensusLogAppenderBufferSizeMax(ratisConfig.getDataAppenderBufferSize());
        this.conf.setSchemaRatisConsensusLogAppenderBufferSizeMax(ratisConfig.getSchemaAppenderBufferSize());
        this.conf.setDataRatisConsensusSnapshotTriggerThreshold(ratisConfig.getDataSnapshotTriggerThreshold());
        this.conf.setSchemaRatisConsensusSnapshotTriggerThreshold(ratisConfig.getSchemaSnapshotTriggerThreshold());
        this.conf.setDataRatisConsensusLogUnsafeFlushEnable(ratisConfig.isDataLogUnsafeFlushEnable());
        this.conf.setSchemaRatisConsensusLogUnsafeFlushEnable(ratisConfig.isSchemaLogUnsafeFlushEnable());
        this.conf.setDataRatisConsensusLogForceSyncNum(ratisConfig.getDataRegionLogForceSyncNum());
        this.conf.setSchemaRatisConsensusLogForceSyncNum(ratisConfig.getSchemaRegionLogForceSyncNum());
        this.conf.setDataRatisConsensusLogSegmentSizeMax(ratisConfig.getDataLogSegmentSizeMax());
        this.conf.setSchemaRatisConsensusLogSegmentSizeMax(ratisConfig.getSchemaLogSegmentSizeMax());
        this.conf.setDataRatisConsensusGrpcFlowControlWindow(ratisConfig.getDataGrpcFlowControlWindow());
        this.conf.setSchemaRatisConsensusGrpcFlowControlWindow(ratisConfig.getSchemaGrpcFlowControlWindow());
        this.conf.setDataRatisConsensusGrpcLeaderOutstandingAppendsMax(ratisConfig.getDataRegionGrpcLeaderOutstandingAppendsMax());
        this.conf.setSchemaRatisConsensusGrpcLeaderOutstandingAppendsMax(ratisConfig.getSchemaRegionGrpcLeaderOutstandingAppendsMax());
        this.conf.setDataRatisConsensusLeaderElectionTimeoutMinMs(ratisConfig.getDataLeaderElectionTimeoutMin());
        this.conf.setSchemaRatisConsensusLeaderElectionTimeoutMinMs(ratisConfig.getSchemaLeaderElectionTimeoutMin());
        this.conf.setDataRatisConsensusLeaderElectionTimeoutMaxMs(ratisConfig.getDataLeaderElectionTimeoutMax());
        this.conf.setSchemaRatisConsensusLeaderElectionTimeoutMaxMs(ratisConfig.getSchemaLeaderElectionTimeoutMax());
        this.conf.setDataRatisConsensusRequestTimeoutMs(ratisConfig.getDataRequestTimeout());
        this.conf.setSchemaRatisConsensusRequestTimeoutMs(ratisConfig.getSchemaRequestTimeout());
        this.conf.setDataRatisConsensusMaxRetryAttempts(ratisConfig.getDataMaxRetryAttempts());
        this.conf.setDataRatisConsensusInitialSleepTimeMs(ratisConfig.getDataInitialSleepTime());
        this.conf.setDataRatisConsensusMaxSleepTimeMs(ratisConfig.getDataMaxSleepTime());
        this.conf.setSchemaRatisConsensusMaxRetryAttempts(ratisConfig.getSchemaMaxRetryAttempts());
        this.conf.setSchemaRatisConsensusInitialSleepTimeMs(ratisConfig.getSchemaInitialSleepTime());
        this.conf.setSchemaRatisConsensusMaxSleepTimeMs(ratisConfig.getSchemaMaxSleepTime());
        this.conf.setDataRatisConsensusPreserveWhenPurge(ratisConfig.getDataPreserveWhenPurge());
        this.conf.setSchemaRatisConsensusPreserveWhenPurge(ratisConfig.getSchemaPreserveWhenPurge());
        this.conf.setRatisFirstElectionTimeoutMinMs(ratisConfig.getFirstElectionTimeoutMin());
        this.conf.setRatisFirstElectionTimeoutMaxMs(ratisConfig.getFirstElectionTimeoutMax());
        this.conf.setSchemaRatisLogMax(ratisConfig.getSchemaRegionRatisLogMax());
        this.conf.setDataRatisLogMax(ratisConfig.getDataRegionRatisLogMax());
        this.conf.setSchemaRatisPeriodicSnapshotInterval(ratisConfig.getSchemaRegionPeriodicSnapshotInterval());
        this.conf.setDataRatisPeriodicSnapshotInterval(ratisConfig.getDataRegionPeriodicSnapshotInterval());
    }

    public void loadCQConfig(TCQConfig cqConfig) {
        this.conf.setCqMinEveryIntervalInMs(cqConfig.getCqMinEveryIntervalInMs());
    }

    public void reclaimConsensusMemory() {
        this.conf.setAllocateMemoryForStorageEngine(this.conf.getAllocateMemoryForStorageEngine() + this.conf.getAllocateMemoryForConsensus());
        SystemInfo.getInstance().allocateWriteMemory();
    }

    private static class IoTDBDescriptorHolder {
        private static final IoTDBDescriptor INSTANCE = new IoTDBDescriptor();

        private IoTDBDescriptorHolder() {
        }
    }
}

