/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class NumberParser {
    private Number literal = null;
    private Class<? extends Number> clazz = null;
    static final DecimalFormat BIGDF = new DecimalFormat("0.0b", new DecimalFormatSymbols(Locale.ENGLISH));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.literal == null || this.clazz == null || Double.isNaN(this.literal.doubleValue())) {
            return "NaN";
        }
        if (BigDecimal.class.equals(this.clazz)) {
            DecimalFormat decimalFormat = BIGDF;
            synchronized (decimalFormat) {
                return BIGDF.format(this.literal);
            }
        }
        StringBuilder strb = new StringBuilder(this.literal.toString());
        if (Float.class.equals(this.clazz)) {
            strb.append('f');
        } else if (Double.class.equals(this.clazz)) {
            strb.append('d');
        } else if (BigInteger.class.equals(this.clazz)) {
            strb.append('h');
        } else if (Long.class.equals(this.clazz)) {
            strb.append('l');
        }
        return strb.toString();
    }

    Class<? extends Number> getLiteralClass() {
        return this.clazz;
    }

    boolean isInteger() {
        return Integer.class.equals(this.clazz);
    }

    Number getLiteralValue() {
        return this.literal;
    }

    static Number parseInteger(String s2) {
        NumberParser np = new NumberParser();
        np.setNatural(s2);
        return np.getLiteralValue();
    }

    static Number parseDouble(String s2) {
        NumberParser np = new NumberParser();
        np.setReal(s2);
        return np.getLiteralValue();
    }

    void setNatural(String s2) {
        Number result;
        Class rclass;
        int base;
        if (s2.charAt(0) == '0') {
            if (s2.length() > 1 && (s2.charAt(1) == 'x' || s2.charAt(1) == 'X')) {
                base = 16;
                s2 = s2.substring(2);
            } else {
                base = 8;
            }
        } else {
            base = 10;
        }
        int last = s2.length() - 1;
        switch (s2.charAt(last)) {
            case 'L': 
            case 'l': {
                rclass = Long.class;
                result = Long.valueOf(s2.substring(0, last), base);
                break;
            }
            case 'H': 
            case 'h': {
                rclass = BigInteger.class;
                result = new BigInteger(s2.substring(0, last), base);
                break;
            }
            default: {
                rclass = Integer.class;
                try {
                    result = Integer.valueOf(s2, base);
                    break;
                }
                catch (NumberFormatException take2) {
                    try {
                        result = Long.valueOf(s2, base);
                        break;
                    }
                    catch (NumberFormatException take3) {
                        result = new BigInteger(s2, base);
                    }
                }
            }
        }
        this.literal = result;
        this.clazz = rclass;
    }

    void setReal(String s2) {
        Class rclass;
        Number result;
        if ("#NaN".equals(s2) || "NaN".equals(s2)) {
            result = Double.NaN;
            rclass = Double.class;
        } else {
            int last = s2.length() - 1;
            switch (s2.charAt(last)) {
                case 'B': 
                case 'b': {
                    rclass = BigDecimal.class;
                    result = new BigDecimal(s2.substring(0, last));
                    break;
                }
                case 'F': 
                case 'f': {
                    rclass = Float.class;
                    result = Float.valueOf(s2.substring(0, last));
                    break;
                }
                case 'D': 
                case 'd': {
                    rclass = Double.class;
                    result = Double.valueOf(s2.substring(0, last));
                    break;
                }
                default: {
                    rclass = Double.class;
                    try {
                        result = Double.valueOf(s2);
                        break;
                    }
                    catch (NumberFormatException take3) {
                        result = new BigDecimal(s2);
                    }
                }
            }
        }
        this.literal = result;
        this.clazz = rclass;
    }
}

