/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.net.SocketAddress;
import reactor.netty.Metrics;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;

final class MicrometerPooledConnectionProviderMeterRegistrar {
    static final String ACTIVE_CONNECTIONS_DESCRIPTION = "The number of the connections that have been successfully acquired and are in active use";
    static final String IDLE_CONNECTIONS_DESCRIPTION = "The number of the idle connections";
    static final String MAX_CONNECTIONS_DESCRIPTIONS = "The maximum number of active connections that are allowed";
    static final String MAX_PENDING_CONNECTIONS_DESCRIPTIONS = "The maximum number of requests that will be queued while waiting for a ready connection";
    static final String PENDING_CONNECTIONS_DESCRIPTION = "The number of the request, that are pending acquire a connection";
    static final String TOTAL_CONNECTIONS_DESCRIPTION = "The number of all connections, active or idle.";
    static final MicrometerPooledConnectionProviderMeterRegistrar INSTANCE = new MicrometerPooledConnectionProviderMeterRegistrar();

    private MicrometerPooledConnectionProviderMeterRegistrar() {
    }

    void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of("id", id, "remote.address", addressAsString, "name", poolName);
        Gauge.builder("reactor.netty.connection.provider.total.connections", metrics, InstrumentedPool.PoolMetrics::allocatedSize).description(TOTAL_CONNECTIONS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder("reactor.netty.connection.provider.active.connections", metrics, InstrumentedPool.PoolMetrics::acquiredSize).description(ACTIVE_CONNECTIONS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder("reactor.netty.connection.provider.idle.connections", metrics, InstrumentedPool.PoolMetrics::idleSize).description(IDLE_CONNECTIONS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder("reactor.netty.connection.provider.pending.connections", metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).description(PENDING_CONNECTIONS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder("reactor.netty.connection.provider.max.connections", metrics, InstrumentedPool.PoolMetrics::getMaxAllocatedSize).description(MAX_CONNECTIONS_DESCRIPTIONS).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder("reactor.netty.connection.provider.max.pending.connections", metrics, InstrumentedPool.PoolMetrics::getMaxPendingAcquireSize).description(MAX_PENDING_CONNECTIONS_DESCRIPTIONS).tags(tags).register(Metrics.REGISTRY);
    }
}

