/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.reporter;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.jmx.JmxMeterRegistry;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.micrometer.reporter.MicrometerJmxConfig;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerJmxReporter
implements JmxReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerJmxReporter.class);

    @Override
    public boolean start() {
        try {
            Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(JmxMeterRegistry.class::isInstance).collect(Collectors.toSet());
            if (!meterRegistrySet.isEmpty()) {
                LOGGER.warn("Micrometer JmxReporter already start!");
                return false;
            }
            Metrics.addRegistry(new JmxMeterRegistry(MicrometerJmxConfig.DEFAULT, Clock.SYSTEM));
        }
        catch (Exception e) {
            LOGGER.warn("Micrometer JmxReporter failed to start, because ", e);
            return false;
        }
        LOGGER.info("Micrometer JmxReporter start!");
        return true;
    }

    @Override
    public boolean stop() {
        try {
            Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(JmxMeterRegistry.class::isInstance).collect(Collectors.toSet());
            for (MeterRegistry meterRegistry : meterRegistrySet) {
                if (meterRegistry.isClosed()) continue;
                ((JmxMeterRegistry)meterRegistry).stop();
                meterRegistry.close();
                Metrics.removeRegistry(meterRegistry);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Micrometer JmxReporter failed to stop, because ", e);
            return false;
        }
        LOGGER.info("Micrometer JmxReporter stop!");
        return true;
    }

    @Override
    public ReporterType getReporterType() {
        return ReporterType.JMX;
    }

    @Override
    public void setMetricManager(AbstractMetricManager metricManager) {
    }
}

