/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.curator5.com.google.common.cache.Cache;
import org.apache.flink.shaded.curator5.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.iotdb.flink.sql.common.Options;
import org.apache.iotdb.flink.sql.common.Utils;
import org.apache.iotdb.flink.sql.exception.IllegalSchemaException;
import org.apache.iotdb.flink.sql.wrapper.SchemaWrapper;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class IoTDBLookupFunction
extends TableFunction<RowData> {
    private final List<Tuple2<String, DataType>> schema;
    private final int cacheMaxRows;
    private final int cacheTTLSec;
    private final List<String> nodeUrls;
    private final String user;
    private final String password;
    private final String sql;
    private Session session;
    private transient Cache<RowData, RowData> cache;

    public IoTDBLookupFunction(ReadableConfig options, SchemaWrapper schemaWrapper) {
        this.schema = schemaWrapper.getSchema();
        this.sql = (String)options.get(Options.SQL);
        this.cacheMaxRows = (Integer)options.get(Options.LOOKUP_CACHE_MAX_ROWS);
        this.cacheTTLSec = (Integer)options.get(Options.LOOKUP_CACHE_TTL_SEC);
        this.nodeUrls = Arrays.asList(((String)options.get(Options.NODE_URLS)).split(","));
        this.user = (String)options.get(Options.USER);
        this.password = (String)options.get(Options.PASSWORD);
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        this.session = new Session.Builder().nodeUrls(this.nodeUrls).username(this.user).password(this.password).build();
        this.session.open(false);
        if (this.cacheMaxRows > 0 && this.cacheTTLSec > 0) {
            this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)this.cacheTTLSec, TimeUnit.SECONDS).maximumSize((long)this.cacheMaxRows).build();
        }
    }

    public void close() throws Exception {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
        if (this.session != null) {
            this.session.close();
        }
        super.close();
    }

    public void eval(Object obj) throws IoTDBConnectionException, StatementExecutionException {
        RowData cacheRow;
        GenericRowData lookupKey = GenericRowData.of((Object[])new Object[]{obj});
        if (this.cache != null && (cacheRow = (RowData)this.cache.getIfPresent((Object)lookupKey)) != null) {
            this.collect(cacheRow);
            return;
        }
        long timestamp = lookupKey.getLong(0);
        String sql = String.format("%s WHERE TIME=%d", this.sql, timestamp);
        SessionDataSet dataSet = this.session.executeQueryStatement(sql);
        List<String> columnNames = dataSet.getColumnNames();
        columnNames.remove("Time");
        RowRecord rowRecord = dataSet.next();
        if (rowRecord == null) {
            ArrayList<Long> values = new ArrayList<Long>();
            values.add(timestamp);
            for (int i = 0; i < this.schema.size(); ++i) {
                values.add(null);
            }
            GenericRowData rowData = GenericRowData.of((Object[])values.toArray());
            this.collect(rowData);
            return;
        }
        List<Field> fields = rowRecord.getFields();
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(timestamp);
        for (Tuple2<String, DataType> field : this.schema) {
            if (!columnNames.contains(field.f0)) {
                values.add(null);
                continue;
            }
            int index = columnNames.indexOf(field.f0);
            DataType flinkType = (DataType)field.f1;
            TSDataType iotdbType = fields.get(index).getDataType();
            if (!Utils.isTypeEqual(iotdbType, flinkType)) {
                throw new IllegalSchemaException(String.format("The data type of column `%s` is different in IoTDB and Flink", field.f0));
            }
            values.add(Utils.getValue(fields.get(index), (DataType)field.f1));
        }
        GenericRowData rowData = GenericRowData.of((Object[])values.toArray());
        if (this.cache != null) {
            this.cache.put((Object)lookupKey, (Object)rowData);
        }
        this.collect(rowData);
    }
}

