/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.builtin;

import org.apache.iotdb.commons.pipe.plugin.builtin.connector.DoNothingConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBLegacyPipeConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBThriftAsyncConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBThriftConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBThriftSyncConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.WebSocketConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.extractor.IoTDBExtractor;
import org.apache.iotdb.commons.pipe.plugin.builtin.processor.DoNothingProcessor;

public enum BuiltinPipePlugin {
    IOTDB_EXTRACTOR("iotdb-extractor", IoTDBExtractor.class),
    DO_NOTHING_PROCESSOR("do-nothing-processor", DoNothingProcessor.class),
    DO_NOTHING_CONNECTOR("do-nothing-connector", DoNothingConnector.class),
    IOTDB_THRIFT_CONNECTOR("iotdb-thrift-connector", IoTDBThriftConnector.class),
    IOTDB_THRIFT_SYNC_CONNECTOR("iotdb-thrift-sync-connector", IoTDBThriftSyncConnector.class),
    IOTDB_THRIFT_ASYNC_CONNECTOR("iotdb-thrift-async-connector", IoTDBThriftAsyncConnector.class),
    IOTDB_LEGACY_PIPE_CONNECTOR("iotdb-legacy-pipe-connector", IoTDBLegacyPipeConnector.class),
    WEBSOCKET_CONNECTOR("websocket-connector", WebSocketConnector.class);

    private final String pipePluginName;
    private final Class<?> pipePluginClass;
    private final String className;

    private BuiltinPipePlugin(String pipePluginName, Class<?> pipePluginClass) {
        this.pipePluginName = pipePluginName;
        this.pipePluginClass = pipePluginClass;
        this.className = pipePluginClass.getName();
    }

    public String getPipePluginName() {
        return this.pipePluginName;
    }

    public Class<?> getPipePluginClass() {
        return this.pipePluginClass;
    }

    public String getClassName() {
        return this.className;
    }
}

