/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class SeriesPartitionTable {
    private final TreeMap<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionMap;

    public SeriesPartitionTable() {
        this.seriesPartitionMap = new TreeMap();
    }

    public SeriesPartitionTable(Map<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionMap) {
        this.seriesPartitionMap = new TreeMap<TTimePartitionSlot, List<TConsensusGroupId>>(seriesPartitionMap);
    }

    public Map<TTimePartitionSlot, List<TConsensusGroupId>> getSeriesPartitionMap() {
        return this.seriesPartitionMap;
    }

    public void putDataPartition(TTimePartitionSlot timePartitionSlot, TConsensusGroupId groupId) {
        this.seriesPartitionMap.computeIfAbsent(timePartitionSlot, empty -> new ArrayList()).add(groupId);
    }

    public boolean getDataPartition(TTimeSlotList partitionSlotList, SeriesPartitionTable seriesPartitionTable) {
        AtomicBoolean result = new AtomicBoolean(true);
        List<TTimePartitionSlot> partitionSlots = partitionSlotList.getTimePartitionSlots();
        if (partitionSlots.isEmpty()) {
            seriesPartitionTable.getSeriesPartitionMap().putAll(this.seriesPartitionMap);
        } else {
            boolean isNeedLeftAll = partitionSlotList.isNeedLeftAll();
            boolean isNeedRightAll = partitionSlotList.isNeedRightAll();
            if (isNeedLeftAll || isNeedRightAll) {
                long leftMargin = isNeedLeftAll ? partitionSlots.get(0).getStartTime() : Long.MIN_VALUE;
                long rightMargin = isNeedRightAll ? partitionSlots.get(partitionSlots.size() - 1).getStartTime() : Long.MAX_VALUE;
                seriesPartitionTable.getSeriesPartitionMap().putAll(this.seriesPartitionMap.entrySet().stream().filter(entry -> {
                    long startTime = ((TTimePartitionSlot)entry.getKey()).getStartTime();
                    return startTime < leftMargin || startTime > rightMargin;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            partitionSlots.forEach(timePartitionSlot -> {
                if (this.seriesPartitionMap.containsKey(timePartitionSlot)) {
                    seriesPartitionTable.getSeriesPartitionMap().put((TTimePartitionSlot)timePartitionSlot, this.seriesPartitionMap.get(timePartitionSlot));
                } else {
                    result.set(false);
                }
            });
        }
        return result.get();
    }

    public TConsensusGroupId getSuccessorDataPartition(TTimePartitionSlot timePartitionSlot) {
        TTimePartitionSlot successorSlot = this.seriesPartitionMap.higherKey(timePartitionSlot);
        return successorSlot == null ? null : this.seriesPartitionMap.get(successorSlot).get(0);
    }

    public TConsensusGroupId getPredecessorDataPartition(TTimePartitionSlot timePartitionSlot) {
        TTimePartitionSlot predecessorSlot = this.seriesPartitionMap.lowerKey(timePartitionSlot);
        return predecessorSlot == null ? null : this.seriesPartitionMap.get(predecessorSlot).get(0);
    }

    List<TConsensusGroupId> getRegionId(TTimePartitionSlot timeSlotId) {
        if (timeSlotId.getStartTime() != -1L) {
            if (!this.seriesPartitionMap.containsKey(timeSlotId)) {
                return new ArrayList<TConsensusGroupId>();
            }
            return this.seriesPartitionMap.get(timeSlotId);
        }
        return this.seriesPartitionMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<TTimePartitionSlot> getTimeSlotList(TConsensusGroupId regionId, long startTime, long endTime) {
        if (regionId.getId() == -1) {
            return this.seriesPartitionMap.keySet().stream().filter(e -> e.getStartTime() >= startTime && e.getStartTime() < endTime).collect(Collectors.toList());
        }
        return this.seriesPartitionMap.keySet().stream().filter(e -> e.getStartTime() >= startTime && e.getStartTime() < endTime).filter(e -> this.seriesPartitionMap.get(e).contains(regionId)).collect(Collectors.toList());
    }

    public void createDataPartition(SeriesPartitionTable assignedSeriesPartitionTable, TSeriesPartitionSlot seriesPartitionSlot, Map<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>> groupDeltaMap) {
        assignedSeriesPartitionTable.getSeriesPartitionMap().forEach((timePartitionSlot, consensusGroupIds) -> {
            this.seriesPartitionMap.put((TTimePartitionSlot)timePartitionSlot, new Vector(consensusGroupIds));
            consensusGroupIds.forEach(consensusGroupId -> groupDeltaMap.computeIfAbsent((TConsensusGroupId)consensusGroupId, empty -> new ConcurrentHashMap()).computeIfAbsent(seriesPartitionSlot, empty -> new AtomicLong(0L)).getAndIncrement());
        });
    }

    public synchronized List<TTimePartitionSlot> filterUnassignedDataPartitionSlots(List<TTimePartitionSlot> partitionSlots) {
        Vector<TTimePartitionSlot> result = new Vector<TTimePartitionSlot>();
        partitionSlots.forEach(timePartitionSlot -> {
            if (!this.seriesPartitionMap.containsKey(timePartitionSlot)) {
                result.add((TTimePartitionSlot)timePartitionSlot);
            }
        });
        return result;
    }

    public TConsensusGroupId getLastConsensusGroupId() {
        Map.Entry<TTimePartitionSlot, List<TConsensusGroupId>> lastEntry = this.seriesPartitionMap.lastEntry();
        if (lastEntry == null) {
            return null;
        }
        return lastEntry.getValue().get(lastEntry.getValue().size() - 1);
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write(this.seriesPartitionMap.size(), outputStream);
        for (Map.Entry<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionEntry : this.seriesPartitionMap.entrySet()) {
            seriesPartitionEntry.getKey().write(protocol);
            ReadWriteIOUtils.write(seriesPartitionEntry.getValue().size(), outputStream);
            for (TConsensusGroupId consensusGroupId : seriesPartitionEntry.getValue()) {
                consensusGroupId.write(protocol);
            }
        }
    }

    public void deserialize(ByteBuffer buffer) {
        int timePartitionSlotNum = buffer.getInt();
        for (int i = 0; i < timePartitionSlotNum; ++i) {
            TTimePartitionSlot timePartitionSlot = ThriftCommonsSerDeUtils.deserializeTTimePartitionSlot(buffer);
            int consensusGroupIdNum = buffer.getInt();
            Vector<TConsensusGroupId> consensusGroupIds = new Vector<TConsensusGroupId>();
            for (int j = 0; j < consensusGroupIdNum; ++j) {
                consensusGroupIds.add(ThriftCommonsSerDeUtils.deserializeTConsensusGroupId(buffer));
            }
            this.seriesPartitionMap.put(timePartitionSlot, consensusGroupIds);
        }
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        int timePartitionSlotNum = ReadWriteIOUtils.readInt(inputStream);
        for (int i = 0; i < timePartitionSlotNum; ++i) {
            TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot();
            timePartitionSlot.read(protocol);
            int consensusGroupIdNum = ReadWriteIOUtils.readInt(inputStream);
            Vector<TConsensusGroupId> consensusGroupIds = new Vector<TConsensusGroupId>();
            for (int j = 0; j < consensusGroupIdNum; ++j) {
                TConsensusGroupId consensusGroupId = new TConsensusGroupId();
                consensusGroupId.read(protocol);
                consensusGroupIds.add(consensusGroupId);
            }
            this.seriesPartitionMap.put(timePartitionSlot, consensusGroupIds);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeriesPartitionTable that = (SeriesPartitionTable)o;
        return this.seriesPartitionMap.equals(that.seriesPartitionMap);
    }

    public int hashCode() {
        return Objects.hash(this.seriesPartitionMap);
    }
}

