/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.enums;

import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HandleSystemErrorStrategy {
    CHANGE_TO_READ_ONLY,
    SHUTDOWN;

    private static final Logger logger;

    public void handle() {
        if (this == CHANGE_TO_READ_ONLY) {
            logger.error("Unrecoverable error occurs! Change system status to read-only because handle_system_error is CHANGE_TO_READ_ONLY. Only query statements are permitted!", new RuntimeException("System mode is set to READ_ONLY"));
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
        } else if (this == SHUTDOWN) {
            logger.error("Unrecoverable error occurs! Shutdown system directly because handle_system_error is SHUTDOWN.", new RuntimeException("Unrecoverable error occurs! Shutdown system directly."));
            System.exit(-1);
        }
    }

    static {
        logger = LoggerFactory.getLogger(HandleSystemErrorStrategy.class);
    }
}

