/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class HybridProgressIndex
implements ProgressIndex {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Short, ProgressIndex> type2Index = new HashMap<Short, ProgressIndex>();

    public HybridProgressIndex() {
    }

    public HybridProgressIndex(short type, ProgressIndex progressIndex) {
        this.type2Index.put(type, progressIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.HYBRID_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write(this.type2Index.size(), byteBuffer);
            for (Map.Entry<Short, ProgressIndex> entry : this.type2Index.entrySet()) {
                ReadWriteIOUtils.write((short)entry.getKey(), byteBuffer);
                entry.getValue().serialize(byteBuffer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.HYBRID_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write(this.type2Index.size(), stream);
            for (Map.Entry<Short, ProgressIndex> entry : this.type2Index.entrySet()) {
                ReadWriteIOUtils.write((short)entry.getKey(), stream);
                entry.getValue().serialize(stream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (!(progressIndex instanceof HybridProgressIndex)) {
                short type = progressIndex.getType().getType();
                boolean bl = this.type2Index.containsKey(type) && this.type2Index.get(type).isAfter(progressIndex);
                return bl;
            }
            HybridProgressIndex thisHybridProgressIndex = this;
            HybridProgressIndex thatHybridProgressIndex = (HybridProgressIndex)progressIndex;
            boolean bl = thatHybridProgressIndex.type2Index.entrySet().stream().noneMatch(entry -> !thisHybridProgressIndex.type2Index.containsKey(entry.getKey()) || !thisHybridProgressIndex.type2Index.get(entry.getKey()).isAfter((ProgressIndex)entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isGivenProgressIndexAfterSelf(ProgressIndex progressIndex) {
        return this.type2Index.size() == 1 && this.type2Index.containsKey(progressIndex.getType().getType()) && progressIndex.isAfter(this.type2Index.get(progressIndex.getType().getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof HybridProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            HybridProgressIndex thisHybridProgressIndex = this;
            HybridProgressIndex thatHybridProgressIndex = (HybridProgressIndex)progressIndex;
            boolean bl = thisHybridProgressIndex.type2Index.size() == thatHybridProgressIndex.type2Index.size() && thatHybridProgressIndex.type2Index.entrySet().stream().allMatch(entry -> thisHybridProgressIndex.type2Index.containsKey(entry.getKey()) && thisHybridProgressIndex.type2Index.get(entry.getKey()).equals((ProgressIndex)entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HybridProgressIndex)) {
            return false;
        }
        return this.equals((HybridProgressIndex)obj);
    }

    public int hashCode() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (progressIndex == null || progressIndex instanceof MinimumProgressIndex) {
                HybridProgressIndex hybridProgressIndex = this;
                return hybridProgressIndex;
            }
            if (!(progressIndex instanceof HybridProgressIndex)) {
                this.type2Index.compute(progressIndex.getType().getType(), (thisK, thisV) -> thisV == null ? progressIndex : thisV.updateToMinimumIsAfterProgressIndex(progressIndex));
                HybridProgressIndex hybridProgressIndex = this;
                return hybridProgressIndex;
            }
            HybridProgressIndex thisHybridProgressIndex = this;
            HybridProgressIndex thatHybridProgressIndex = (HybridProgressIndex)progressIndex;
            thatHybridProgressIndex.type2Index.forEach((thatK, thatV) -> thisHybridProgressIndex.type2Index.compute((Short)thatK, (thisK, thisV) -> thisV == null ? thatV : thisV.updateToMinimumIsAfterProgressIndex((ProgressIndex)thatV)));
            HybridProgressIndex hybridProgressIndex = this;
            return hybridProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.HYBRID_PROGRESS_INDEX;
    }

    public static HybridProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        HybridProgressIndex hybridProgressIndex = new HybridProgressIndex();
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (int i = 0; i < size; ++i) {
            short type = ReadWriteIOUtils.readShort(byteBuffer);
            ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(byteBuffer);
            hybridProgressIndex.type2Index.put(type, progressIndex);
        }
        return hybridProgressIndex;
    }

    public static HybridProgressIndex deserializeFrom(InputStream stream) throws IOException {
        HybridProgressIndex hybridProgressIndex = new HybridProgressIndex();
        int size = ReadWriteIOUtils.readInt(stream);
        for (int i = 0; i < size; ++i) {
            short type = ReadWriteIOUtils.readShort(stream);
            ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(stream);
            hybridProgressIndex.type2Index.put(type, progressIndex);
        }
        return hybridProgressIndex;
    }

    public String toString() {
        return "HybridProgressIndex{type2Index=" + this.type2Index + '}';
    }
}

