/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.entities;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import java.net.URI;
import java.util.List;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class FederationEntityMetadata
implements JSONAware {
    private URI federationAPIEndpoint;
    private EntityID trustAnchorID;
    private String name;
    private List<String> contacts;
    private URI policyURI;
    private URI homepageURI;

    public FederationEntityMetadata(URI federationEndpoint) {
        this.federationAPIEndpoint = federationEndpoint;
    }

    public URI getFederationAPIEndpointURI() {
        return this.federationAPIEndpoint;
    }

    public EntityID getTrustAnchorID() {
        return this.trustAnchorID;
    }

    public void setTrustAnchorID(EntityID trustAnchorID) {
        this.trustAnchorID = trustAnchorID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI policyURI) {
        this.policyURI = policyURI;
    }

    public URI getHomepageURI() {
        return this.homepageURI;
    }

    public void setHomepageURI(URI homepageURI) {
        this.homepageURI = homepageURI;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.getFederationAPIEndpointURI() != null) {
            o.put("federation_api_endpoint", this.getFederationAPIEndpointURI().toString());
        }
        if (this.getTrustAnchorID() != null) {
            o.put("trust_anchor_id", this.getTrustAnchorID().getValue());
        }
        if (this.getName() != null) {
            o.put("name", this.getName());
        }
        if (this.getContacts() != null) {
            o.put("contacts", this.getContacts());
        }
        if (this.getPolicyURI() != null) {
            o.put("policy_uri", this.getPolicyURI().toString());
        }
        if (this.getHomepageURI() != null) {
            o.put("homepage_uri", this.getHomepageURI().toString());
        }
        return o;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public static FederationEntityMetadata parse(JSONObject jsonObject) throws ParseException {
        URI federationAPIEndpoint = JSONObjectUtils.getURI(jsonObject, "federation_api_endpoint", null);
        FederationEntityMetadata metadata = new FederationEntityMetadata(federationAPIEndpoint);
        if (jsonObject.get("trust_anchor_id") != null) {
            metadata.setTrustAnchorID(new EntityID(JSONObjectUtils.getString(jsonObject, "trust_anchor_id")));
        }
        metadata.setName(JSONObjectUtils.getString(jsonObject, "name", null));
        metadata.setContacts(JSONObjectUtils.getStringList(jsonObject, "contacts", null));
        metadata.setPolicyURI(JSONObjectUtils.getURI(jsonObject, "policy_uri", null));
        metadata.setHomepageURI(JSONObjectUtils.getURI(jsonObject, "homepage_uri", null));
        return metadata;
    }

    public static FederationEntityMetadata parse(String json) throws ParseException {
        return FederationEntityMetadata.parse(JSONObjectUtils.parse(json));
    }
}

