/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.util.Properties;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDescriptor.class);
    private final CommonConfig config = new CommonConfig();

    private CommonDescriptor() {
    }

    public static CommonDescriptor getInstance() {
        return CommonDescriptorHolder.INSTANCE;
    }

    public CommonConfig getConfig() {
        return this.config;
    }

    public void initCommonConfigDir(String systemDir) {
        this.config.setUserFolder(systemDir + File.separator + "users");
        this.config.setRoleFolder(systemDir + File.separator + "roles");
        this.config.setProcedureWalFolder(systemDir + File.separator + "procedure");
    }

    public void loadCommonProps(Properties properties) {
        this.config.setAuthorizerProvider(properties.getProperty("authorizer_provider_class", this.config.getAuthorizerProvider()).trim());
        this.config.setOpenIdProviderUrl(properties.getProperty("openID_url", this.config.getOpenIdProviderUrl()).trim());
        this.config.setEncryptDecryptProvider(properties.getProperty("iotdb_server_encrypt_decrypt_provider", this.config.getEncryptDecryptProvider()).trim());
        this.config.setEncryptDecryptProviderParameter(properties.getProperty("iotdb_server_encrypt_decrypt_provider_parameter", this.config.getEncryptDecryptProviderParameter()));
        CharSequence[] tierTTLStr = new String[this.config.getTierTTLInMs().length];
        for (int i = 0; i < tierTTLStr.length; ++i) {
            tierTTLStr[i] = String.valueOf(this.config.getTierTTLInMs()[i]);
        }
        tierTTLStr = properties.getProperty("default_ttl_in_ms", String.join((CharSequence)";", tierTTLStr)).split(";");
        long[] tierTTL = new long[tierTTLStr.length];
        for (int i = 0; i < tierTTL.length; ++i) {
            tierTTL[i] = Long.parseLong((String)tierTTLStr[i]);
            if (tierTTL[i] >= 0L) continue;
            tierTTL[i] = Long.MAX_VALUE;
        }
        this.config.setTierTTLInMs(tierTTL);
        this.config.setSyncDir(properties.getProperty("dn_sync_dir", this.config.getSyncDir()).trim());
        this.config.setWalDirs(properties.getProperty("dn_wal_dirs", String.join((CharSequence)",", this.config.getWalDirs())).trim().split(","));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("cn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("cn_connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("cn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setCoreClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_core_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getCoreClientNumForEachNode())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("dn_connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS())).trim()));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("dn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("dn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setCoreClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_core_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getCoreClientNumForEachNode())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setHandleSystemErrorStrategy(HandleSystemErrorStrategy.valueOf(properties.getProperty("handle_system_error", String.valueOf((Object)this.config.getHandleSystemErrorStrategy())).trim()));
        this.config.setDiskSpaceWarningThreshold(Double.parseDouble(properties.getProperty("disk_space_warning_threshold", String.valueOf(this.config.getDiskSpaceWarningThreshold())).trim()));
        this.config.setTimestampPrecision(properties.getProperty("timestamp_precision", this.config.getTimestampPrecision()).trim());
        String endPointUrl = properties.getProperty("target_ml_node_endpoint", NodeUrlUtils.convertTEndPointUrl(this.config.getTargetMLNodeEndPoint()));
        this.loadPipeProps(properties);
        try {
            this.config.setTargetMLNodeEndPoint(NodeUrlUtils.parseTEndPointUrl(endPointUrl));
        }
        catch (BadNodeUrlException e) {
            LOGGER.warn("Illegal target MLNode endpoint url format in config file: {}, use default configuration.", (Object)endPointUrl);
        }
        this.config.setSchemaEngineMode(properties.getProperty("schema_engine_mode", String.valueOf(this.config.getSchemaEngineMode())));
        this.config.setLastCacheEnable(Boolean.parseBoolean(properties.getProperty("enable_last_cache", Boolean.toString(this.config.isLastCacheEnable()))));
        if (this.config.getSchemaEngineMode().equals("Rocksdb_based")) {
            this.config.setLastCacheEnable(false);
        }
        this.config.setTagAttributeTotalSize(Integer.parseInt(properties.getProperty("tag_attribute_total_size", String.valueOf(this.config.getTagAttributeTotalSize()))));
        this.config.setTimePartitionInterval(Long.parseLong(properties.getProperty("time_partition_interval", String.valueOf(this.config.getTimePartitionInterval()))));
        this.config.setDatabaseLimitThreshold(Integer.parseInt(properties.getProperty("database_limit_threshold", String.valueOf(this.config.getDatabaseLimitThreshold()))));
    }

    private void loadPipeProps(Properties properties) {
        this.config.setPipeHardlinkBaseDirName(properties.getProperty("pipe_hardlink_base_dir_name", this.config.getPipeHardlinkBaseDirName()));
        this.config.setPipeHardlinkTsFileDirName(properties.getProperty("pipe_hardlink_tsfile_dir_name", this.config.getPipeHardlinkTsFileDirName()));
        this.config.setPipeHardlinkWALDirName(properties.getProperty("pipe_hardlink_wal_dir_name", this.config.getPipeHardlinkWALDirName()));
        this.config.setPipeHardLinkWALEnabled(Boolean.parseBoolean(properties.getProperty("pipe_hardlink_wal_enabled", Boolean.toString(this.config.getPipeHardLinkWALEnabled()))));
        this.config.setPipeDataStructureTabletRowSize(Integer.parseInt(properties.getProperty("pipe_data_structure_tablet_row_size", String.valueOf(this.config.getPipeDataStructureTabletRowSize()))));
        this.config.setPipeSubtaskExecutorMaxThreadNum(Integer.parseInt(properties.getProperty("pipe_subtask_executor_max_thread_num", Integer.toString(this.config.getPipeSubtaskExecutorMaxThreadNum()))));
        if (this.config.getPipeSubtaskExecutorMaxThreadNum() <= 0) {
            this.config.setPipeSubtaskExecutorMaxThreadNum(5);
        }
        this.config.setPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount(Integer.parseInt(properties.getProperty("pipe_subtask_executor_basic_check_point_interval_by_consumed_event_count", String.valueOf(this.config.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount()))));
        this.config.setPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration(Long.parseLong(properties.getProperty("pipe_subtask_executor_basic_check_point_interval_by_time_duration", String.valueOf(this.config.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration()))));
        this.config.setPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs(Long.parseLong(properties.getProperty("pipe_subtask_executor_pending_queue_max_blocking_time_ms", String.valueOf(this.config.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs()))));
        this.config.setPipeExtractorAssignerDisruptorRingBufferSize(Integer.parseInt(properties.getProperty("pipe_extractor_assigner_disruptor_ring_buffer_size", String.valueOf(this.config.getPipeExtractorAssignerDisruptorRingBufferSize()))));
        this.config.setPipeExtractorMatcherCacheSize(Integer.parseInt(properties.getProperty("pipe_extractor_matcher_cache_size", String.valueOf(this.config.getPipeExtractorMatcherCacheSize()))));
        this.config.setPipeExtractorPendingQueueCapacity(Integer.parseInt(properties.getProperty("pipe_extractor_pending_queue_capacity", String.valueOf(this.config.getPipeExtractorPendingQueueCapacity()))));
        this.config.setPipeExtractorPendingQueueTabletLimit(Integer.parseInt(properties.getProperty("pipe_extractor_pending_queue_tablet_limit", String.valueOf(this.config.getPipeExtractorPendingQueueTabletLimit()))));
        this.config.setPipeConnectorTimeoutMs(Long.parseLong(properties.getProperty("pipe_connector_timeout_ms", String.valueOf(this.config.getPipeConnectorTimeoutMs()))));
        this.config.setPipeConnectorReadFileBufferSize(Integer.parseInt(properties.getProperty("pipe_connector_read_file_buffer_size", String.valueOf(this.config.getPipeConnectorReadFileBufferSize()))));
        this.config.setPipeConnectorRetryIntervalMs(Long.parseLong(properties.getProperty("pipe_connector_retry_interval_ms", String.valueOf(this.config.getPipeConnectorRetryIntervalMs()))));
        this.config.setPipeConnectorPendingQueueSize(Integer.parseInt(properties.getProperty("pipe_connector_pending_queue_size", String.valueOf(this.config.getPipeConnectorPendingQueueSize()))));
        this.config.setPipeConnectorRPCThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("pipe_connector_rpc_thrift_compression_enabled", String.valueOf(this.config.isPipeConnectorRPCThriftCompressionEnabled()))));
        this.config.setPipeAsyncConnectorSelectorNumber(Integer.parseInt(properties.getProperty("pipe_async_connector_selector_number", String.valueOf(this.config.getPipeAsyncConnectorSelectorNumber()))));
        this.config.setPipeAsyncConnectorCoreClientNumber(Integer.parseInt(properties.getProperty("pipe_async_connector_core_client_number", String.valueOf(this.config.getPipeAsyncConnectorCoreClientNumber()))));
        this.config.setPipeAsyncConnectorMaxClientNumber(Integer.parseInt(properties.getProperty("pipe_async_connector_max_client_number", String.valueOf(this.config.getPipeAsyncConnectorMaxClientNumber()))));
        this.config.setSeperatedPipeHeartbeatEnabled(Boolean.parseBoolean(properties.getProperty("pipe_heartbeat_seperated_mode_enabled", String.valueOf(this.config.isSeperatedPipeHeartbeatEnabled()))));
        this.config.setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(Integer.parseInt(properties.getProperty("pipe_heartbeat_interval_seconds_for_collecting_pipe_meta", String.valueOf(this.config.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta()))));
        this.config.setPipeMetaSyncerInitialSyncDelayMinutes(Long.parseLong(properties.getProperty("pipe_meta_syncer_initial_sync_delay_minutes", String.valueOf(this.config.getPipeMetaSyncerInitialSyncDelayMinutes()))));
        this.config.setPipeMetaSyncerSyncIntervalMinutes(Long.parseLong(properties.getProperty("pipe_meta_syncer_sync_interval_minutes", String.valueOf(this.config.getPipeMetaSyncerSyncIntervalMinutes()))));
        this.config.setPipeMetaSyncerAutoRestartPipeCheckIntervalRound(Long.parseLong(properties.getProperty("pipe_meta_syncer_auto_restart_pipe_check_interval_round", String.valueOf(this.config.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound()))));
        this.config.setPipeAutoRestartEnabled(Boolean.parseBoolean(properties.getProperty("pipe_auto_restart_enabled", String.valueOf(this.config.getPipeAutoRestartEnabled()))));
        this.config.setPipeAirGapReceiverEnabled(Boolean.parseBoolean(properties.getProperty("pipe_air_gap_receiver_enabled", Boolean.toString(this.config.getPipeAirGapReceiverEnabled()))));
        this.config.setPipeAirGapReceiverPort(Integer.parseInt(properties.getProperty("pipe_air_gap_receiver_port", Integer.toString(this.config.getPipeAirGapReceiverPort()))));
    }

    public void loadGlobalConfig(TGlobalConfig globalConfig) {
        this.config.setTimePartitionInterval(CommonDateTimeUtils.convertMilliTimeWithPrecision(globalConfig.timePartitionInterval, this.config.getTimestampPrecision()));
        this.config.setTimestampPrecision(globalConfig.timestampPrecision);
        this.config.setSchemaEngineMode(globalConfig.schemaEngineMode);
        this.config.setTagAttributeTotalSize(globalConfig.tagAttributeTotalSize);
        this.config.setDiskSpaceWarningThreshold(globalConfig.getDiskSpaceWarningThreshold());
    }

    private static class CommonDescriptorHolder {
        private static final CommonDescriptor INSTANCE = new CommonDescriptor();

        private CommonDescriptorHolder() {
        }
    }
}

