/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionFileCountExceededException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionMemoryNotEnoughException;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private long totalStorageGroupMemCost = 0L;
    private volatile boolean rejected = false;
    private long memorySizeForMemtable;
    private long memorySizeForCompaction;
    private Map<DataRegionInfo, Long> reportedStorageGroupMemCostMap = new HashMap<DataRegionInfo, Long>();
    private long flushingMemTablesCost = 0L;
    private AtomicLong compactionMemoryCost = new AtomicLong(0L);
    private AtomicInteger compactionFileNumCost = new AtomicInteger(0);
    private int totalFileLimitForCrossTask = config.getTotalFileLimitForCrossTask();
    private ExecutorService flushTaskSubmitThreadPool = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.FLUSH_TASK_SUBMIT.getName());
    private double FLUSH_THERSHOLD = (double)this.memorySizeForMemtable * config.getFlushProportion();
    private double REJECT_THERSHOLD = (double)this.memorySizeForMemtable * config.getRejectProportion();
    private volatile boolean isEncodingFasterThanIo = true;

    private SystemInfo() {
        this.allocateWriteMemory();
    }

    public synchronized boolean reportStorageGroupStatus(DataRegionInfo dataRegionInfo, TsFileProcessor tsFileProcessor) throws WriteProcessRejectException {
        long currentDataRegionMemCost = dataRegionInfo.getMemCost();
        long delta = currentDataRegionMemCost - this.reportedStorageGroupMemCostMap.getOrDefault(dataRegionInfo, 0L);
        this.totalStorageGroupMemCost += delta;
        if (logger.isDebugEnabled()) {
            logger.debug("Report database Status to the system. After adding {}, current sg mem cost is {}.", (Object)delta, (Object)this.totalStorageGroupMemCost);
        }
        this.reportedStorageGroupMemCostMap.put(dataRegionInfo, currentDataRegionMemCost);
        dataRegionInfo.setLastReportedSize(currentDataRegionMemCost);
        if ((double)this.totalStorageGroupMemCost < this.FLUSH_THERSHOLD) {
            return true;
        }
        if ((double)this.totalStorageGroupMemCost >= this.FLUSH_THERSHOLD && (double)this.totalStorageGroupMemCost < this.REJECT_THERSHOLD) {
            logger.debug("The total database mem costs are too large, call for flushing. Current sg cost is {}", (Object)this.totalStorageGroupMemCost);
            this.chooseMemTablesToMarkFlush(tsFileProcessor);
            return true;
        }
        logger.info("Change system to reject status. Triggered by: logical SG ({}), mem cost delta ({}), totalSgMemCost ({}), REJECT_THERSHOLD ({})", new Object[]{dataRegionInfo.getDataRegion().getDatabaseName(), delta, this.totalStorageGroupMemCost, this.REJECT_THERSHOLD});
        this.rejected = true;
        if (this.chooseMemTablesToMarkFlush(tsFileProcessor)) {
            if (this.totalStorageGroupMemCost < this.memorySizeForMemtable) {
                return true;
            }
            throw new WriteProcessRejectException("Total database MemCost " + this.totalStorageGroupMemCost + " is over than memorySizeForWriting " + this.memorySizeForMemtable);
        }
        return false;
    }

    public synchronized void resetStorageGroupStatus(DataRegionInfo dataRegionInfo) {
        long currentDataRegionMemCost = dataRegionInfo.getMemCost();
        long delta = 0L;
        if (this.reportedStorageGroupMemCostMap.containsKey(dataRegionInfo)) {
            delta = this.reportedStorageGroupMemCostMap.get(dataRegionInfo) - currentDataRegionMemCost;
            this.totalStorageGroupMemCost -= delta;
            dataRegionInfo.setLastReportedSize(currentDataRegionMemCost);
            dataRegionInfo.setNeedToReportToSystem(true);
            this.reportedStorageGroupMemCostMap.put(dataRegionInfo, currentDataRegionMemCost);
        }
        if ((double)this.totalStorageGroupMemCost >= this.FLUSH_THERSHOLD && (double)this.totalStorageGroupMemCost < this.REJECT_THERSHOLD) {
            logger.debug("SG ({}) released memory (delta: {}) but still exceeding flush proportion (totalSgMemCost: {}), call flush.", new Object[]{dataRegionInfo.getDataRegion().getDatabaseName(), delta, this.totalStorageGroupMemCost});
            if (this.rejected) {
                logger.info("SG ({}) released memory (delta: {}), set system to normal status (totalSgMemCost: {}).", new Object[]{dataRegionInfo.getDataRegion().getDatabaseName(), delta, this.totalStorageGroupMemCost});
            }
            this.logCurrentTotalSGMemory();
            this.rejected = false;
        } else if ((double)this.totalStorageGroupMemCost >= this.REJECT_THERSHOLD) {
            logger.warn("SG ({}) released memory (delta: {}), but system is still in reject status (totalSgMemCost: {}).", new Object[]{dataRegionInfo.getDataRegion().getDatabaseName(), delta, this.totalStorageGroupMemCost});
            this.logCurrentTotalSGMemory();
            this.rejected = true;
        } else {
            logger.debug("SG ({}) released memory (delta: {}), system is in normal status (totalSgMemCost: {}).", new Object[]{dataRegionInfo.getDataRegion().getDatabaseName(), delta, this.totalStorageGroupMemCost});
            this.logCurrentTotalSGMemory();
            this.rejected = false;
        }
    }

    public synchronized void addFlushingMemTableCost(long flushingMemTableCost) {
        this.flushingMemTablesCost += flushingMemTableCost;
    }

    public synchronized void resetFlushingMemTableCost(long flushingMemTableCost) {
        this.flushingMemTablesCost -= flushingMemTableCost;
    }

    public void addCompactionFileNum(int fileNum, long timeOutInSecond) throws InterruptedException, CompactionFileCountExceededException {
        if (fileNum > this.totalFileLimitForCrossTask) {
            throw new CompactionFileCountExceededException(String.format("Required file num %d is greater than the max file num %d for compaction.", fileNum, this.totalFileLimitForCrossTask));
        }
        long startTime = System.currentTimeMillis();
        int originFileNum = this.compactionFileNumCost.get();
        while (originFileNum + fileNum > this.totalFileLimitForCrossTask || !this.compactionFileNumCost.compareAndSet(originFileNum, originFileNum + fileNum)) {
            if (System.currentTimeMillis() - startTime >= timeOutInSecond * 1000L) {
                throw new CompactionFileCountExceededException(String.format("Failed to allocate %d files for compaction after %d seconds, max file num for compaction module is %d, %d files is used.", fileNum, timeOutInSecond, this.totalFileLimitForCrossTask, originFileNum));
            }
            Thread.sleep(100L);
            originFileNum = this.compactionFileNumCost.get();
        }
    }

    public void addCompactionMemoryCost(long memoryCost, long timeOutInSecond) throws InterruptedException, CompactionMemoryNotEnoughException {
        if (!config.isEnableCompactionMemControl()) {
            return;
        }
        if (memoryCost > this.memorySizeForCompaction) {
            throw new CompactionMemoryNotEnoughException(String.format("Required memory cost %d bytes is greater than the total memory budget for compaction %d bytes", memoryCost, this.memorySizeForCompaction));
        }
        long startTime = System.currentTimeMillis();
        long originSize = this.compactionMemoryCost.get();
        while (originSize + memoryCost > this.memorySizeForCompaction || !this.compactionMemoryCost.compareAndSet(originSize, originSize + memoryCost)) {
            if (System.currentTimeMillis() - startTime >= timeOutInSecond * 1000L) {
                throw new CompactionMemoryNotEnoughException(String.format("Failed to allocate %d bytes memory for compaction after %d seconds, total memory budget for compaction module is %d bytes, %d bytes is used", memoryCost, timeOutInSecond, this.memorySizeForCompaction, originSize));
            }
            Thread.sleep(100L);
            originSize = this.compactionMemoryCost.get();
        }
    }

    public synchronized void resetCompactionMemoryCost(long compactionMemoryCost) {
        if (!config.isEnableCompactionMemControl()) {
            return;
        }
        this.compactionMemoryCost.addAndGet(-compactionMemoryCost);
    }

    public synchronized void decreaseCompactionFileNumCost(int fileNum) {
        this.compactionFileNumCost.addAndGet(-fileNum);
    }

    public long getMemorySizeForCompaction() {
        if (config.isEnableMemControl()) {
            return this.memorySizeForCompaction;
        }
        return Long.MAX_VALUE;
    }

    public void allocateWriteMemory() {
        this.memorySizeForMemtable = (long)((double)config.getAllocateMemoryForStorageEngine() * config.getWriteProportionForMemtable());
        this.memorySizeForCompaction = (long)((double)config.getAllocateMemoryForStorageEngine() * config.getCompactionProportion());
        this.FLUSH_THERSHOLD = (double)this.memorySizeForMemtable * config.getFlushProportion();
        this.REJECT_THERSHOLD = (double)this.memorySizeForMemtable * config.getRejectProportion();
    }

    public void setMemorySizeForCompaction(long size) {
        this.memorySizeForCompaction = size;
    }

    public void setTotalFileLimitForCrossTask(int totalFileLimitForCrossTask) {
        this.totalFileLimitForCrossTask = totalFileLimitForCrossTask;
    }

    public int getTotalFileLimitForCrossTask() {
        return this.totalFileLimitForCrossTask;
    }

    public AtomicLong getCompactionMemoryCost() {
        return this.compactionMemoryCost;
    }

    public AtomicInteger getCompactionFileNumCost() {
        return this.compactionFileNumCost;
    }

    private void logCurrentTotalSGMemory() {
        logger.debug("Current Sg cost is {}", (Object)this.totalStorageGroupMemCost);
    }

    private boolean chooseMemTablesToMarkFlush(TsFileProcessor currentTsFileProcessor) {
        if (this.reportedStorageGroupMemCostMap.size() == 0) {
            return false;
        }
        PriorityQueue<TsFileProcessor> allTsFileProcessors = new PriorityQueue<TsFileProcessor>((o1, o2) -> Long.compare(o2.getWorkMemTableRamCost(), o1.getWorkMemTableRamCost()));
        for (DataRegionInfo dataRegionInfo : this.reportedStorageGroupMemCostMap.keySet()) {
            allTsFileProcessors.addAll(dataRegionInfo.getAllReportedTsp());
        }
        boolean isCurrentTsFileProcessorSelected = false;
        long memCost = 0L;
        long activeMemSize = this.totalStorageGroupMemCost - this.flushingMemTablesCost;
        while ((double)(activeMemSize - memCost) > this.FLUSH_THERSHOLD) {
            if (allTsFileProcessors.isEmpty() || ((TsFileProcessor)allTsFileProcessors.peek()).getWorkMemTableRamCost() == 0L) {
                return false;
            }
            TsFileProcessor selectedTsFileProcessor = (TsFileProcessor)allTsFileProcessors.peek();
            memCost += selectedTsFileProcessor.getWorkMemTableRamCost();
            selectedTsFileProcessor.setWorkMemTableShouldFlush();
            this.flushTaskSubmitThreadPool.submit(() -> selectedTsFileProcessor.submitAFlushTask());
            if (selectedTsFileProcessor == currentTsFileProcessor) {
                isCurrentTsFileProcessorSelected = true;
            }
            allTsFileProcessors.poll();
        }
        return isCurrentTsFileProcessorSelected;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setEncodingFasterThanIo(boolean isEncodingFasterThanIo) {
        this.isEncodingFasterThanIo = isEncodingFasterThanIo;
    }

    public boolean isEncodingFasterThanIo() {
        return this.isEncodingFasterThanIo;
    }

    public void close() {
        this.reportedStorageGroupMemCostMap.clear();
        this.totalStorageGroupMemCost = 0L;
        this.rejected = false;
    }

    public static SystemInfo getInstance() {
        return InstanceHolder.instance;
    }

    public synchronized void applyTemporaryMemoryForFlushing(long estimatedTemporaryMemSize) {
        this.memorySizeForMemtable -= estimatedTemporaryMemSize;
        this.FLUSH_THERSHOLD = (double)this.memorySizeForMemtable * config.getFlushProportion();
        this.REJECT_THERSHOLD = (double)this.memorySizeForMemtable * config.getRejectProportion();
    }

    public synchronized void releaseTemporaryMemoryForFlushing(long estimatedTemporaryMemSize) {
        this.memorySizeForMemtable += estimatedTemporaryMemSize;
        this.FLUSH_THERSHOLD = (double)this.memorySizeForMemtable * config.getFlushProportion();
        this.REJECT_THERSHOLD = (double)this.memorySizeForMemtable * config.getRejectProportion();
    }

    public long getTotalMemTableSize() {
        return this.totalStorageGroupMemCost;
    }

    public double getFlushThershold() {
        return this.FLUSH_THERSHOLD;
    }

    public double getRejectThershold() {
        return this.REJECT_THERSHOLD;
    }

    public int flushingMemTableNum() {
        return FlushManager.getInstance().getNumberOfWorkingTasks();
    }

    private static class InstanceHolder {
        private static SystemInfo instance = new SystemInfo();

        private InstanceHolder() {
        }
    }
}

