/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedChunkReader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;

public class MemAlignedChunkLoader
implements IChunkLoader {
    private final AlignedReadOnlyMemChunk chunk;
    private final boolean queryAllSensors;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public MemAlignedChunkLoader(AlignedReadOnlyMemChunk chunk, boolean queryAllSensors) {
        this.chunk = chunk;
        this.queryAllSensors = queryAllSensors;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter timeFilter) {
        long startTime = System.nanoTime();
        try {
            MemAlignedChunkReader memAlignedChunkReader = new MemAlignedChunkReader(this.chunk, timeFilter, this.queryAllSensors);
            return memAlignedChunkReader;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("construct_chunk_reader_aligned_mem", duration);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_aligned_mem", duration);
        }
    }
}

