/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.flush;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionRatio {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionRatio.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    static final String COMPRESSION_RATIO_DIR = "compression_ratio";
    private static final String FILE_PREFIX = "Ratio-";
    private static final String SEPARATOR = "-";
    static final String RATIO_FILE_PATH_FORMAT = "Ratio-%f-%d";
    private static final double DEFAULT_COMPRESSION_RATIO = 2.0;
    private AtomicDouble compressionRatio = new AtomicDouble(2.0);
    private double compressionRatioSum;
    private long calcTimes;
    private File directory = SystemFileFactory.INSTANCE.getFile(FilePathUtils.regularizePath((String)CONFIG.getSystemDir()) + "compression_ratio");

    private CompressionRatio() {
        try {
            this.restore();
        }
        catch (IOException e) {
            LOGGER.error("restore file error caused by ", (Throwable)e);
        }
    }

    public synchronized void updateRatio(double currentCompressionRatio) throws IOException {
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.directory, String.format(Locale.ENGLISH, RATIO_FILE_PATH_FORMAT, this.compressionRatioSum, this.calcTimes));
        this.compressionRatioSum += currentCompressionRatio;
        ++this.calcTimes;
        File newFile = SystemFileFactory.INSTANCE.getFile(this.directory, String.format(Locale.ENGLISH, RATIO_FILE_PATH_FORMAT, this.compressionRatioSum, this.calcTimes));
        this.persist(oldFile, newFile);
        this.compressionRatio.set(this.compressionRatioSum / (double)this.calcTimes);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Compression ratio is {}", (Object)this.compressionRatio.get());
        }
    }

    public double getRatio() {
        return this.compressionRatio.get();
    }

    private void persist(File oldFile, File newFile) throws IOException {
        this.checkDirectoryExist();
        if (!oldFile.exists()) {
            Files.createFile(newFile.toPath(), new FileAttribute[0]);
            LOGGER.debug("Old ratio file {} doesn't exist, force create ratio file {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
        } else {
            FileUtils.moveFile((File)oldFile, (File)newFile);
            LOGGER.debug("Compression ratio file updated, previous: {}, current: {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
        }
    }

    private void checkDirectoryExist() throws IOException {
        if (!this.directory.exists()) {
            FileUtils.forceMkdir((File)this.directory);
        }
    }

    void restore() throws IOException {
        if (!this.directory.exists()) {
            return;
        }
        File[] ratioFiles = this.directory.listFiles((dir, name) -> name.startsWith(FILE_PREFIX));
        if (ratioFiles != null && ratioFiles.length > 0) {
            int i;
            long maxTimes = 0L;
            double maxCompressionRatioSum = 0.0;
            int maxRatioIndex = 0;
            for (i = 0; i < ratioFiles.length; ++i) {
                String[] splits = ratioFiles[i].getName().split(SEPARATOR);
                long times = Long.parseLong(splits[2]);
                if (times <= maxTimes) continue;
                maxTimes = times;
                maxCompressionRatioSum = Double.parseDouble(splits[1]);
                maxRatioIndex = i;
            }
            this.calcTimes = maxTimes;
            this.compressionRatioSum = maxCompressionRatioSum;
            if (this.calcTimes != 0L) {
                this.compressionRatio.set(this.compressionRatioSum / (double)this.calcTimes);
            }
            LOGGER.debug("After restoring from compression ratio file, compressionRatioSum = {}, calcTimes = {}", (Object)this.compressionRatioSum, (Object)this.calcTimes);
            for (i = 0; i < ratioFiles.length; ++i) {
                if (i == maxRatioIndex) continue;
                Files.delete(ratioFiles[i].toPath());
                ratioFiles[i].delete();
            }
        }
    }

    void reset() {
        this.calcTimes = 0L;
        this.compressionRatioSum = 0.0;
    }

    public double getCompressionRatioSum() {
        return this.compressionRatioSum;
    }

    long getCalcTimes() {
        return this.calcTimes;
    }

    public static CompressionRatio getInstance() {
        return CompressionRatioHolder.INSTANCE;
    }

    private static class CompressionRatioHolder {
        private static final CompressionRatio INSTANCE = new CompressionRatio();

        private CompressionRatioHolder() {
        }
    }
}

