/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionValidationLevel;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator.NoneCompactionValidator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator.ResourceAndTsfileCompactionValidator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator.ResourceOnlyCompactionValidator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public interface CompactionValidator {
    public boolean validateCompaction(TsFileManager var1, List<TsFileResource> var2, String var3, long var4, boolean var6) throws IOException;

    public static CompactionValidator getInstance() {
        CompactionValidationLevel level = IoTDBDescriptor.getInstance().getConfig().getCompactionValidationLevel();
        switch (level) {
            case NONE: {
                return NoneCompactionValidator.getInstance();
            }
            case RESOURCE_ONLY: {
                return ResourceOnlyCompactionValidator.getInstance();
            }
        }
        return ResourceAndTsfileCompactionValidator.getInstance();
    }
}

