/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.helper.CastFunctionHelper;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;
import org.apache.iotdb.tsfile.utils.Binary;

public class CastFunctionColumnTransformer
extends UnaryColumnTransformer {
    private static final String ERROR_MSG = "Unsupported target dataType: %s";

    public CastFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer) {
        super(returnType, childColumnTransformer);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        TypeEnum sourceType = this.childColumnTransformer.getType().getTypeEnum();
        Type childType = this.childColumnTransformer.getType();
        int n = column.getPositionCount();
        block8: for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                switch (sourceType) {
                    case INT32: {
                        this.cast(columnBuilder, childType.getInt(column, i));
                        continue block8;
                    }
                    case INT64: {
                        this.cast(columnBuilder, childType.getLong(column, i));
                        continue block8;
                    }
                    case FLOAT: {
                        this.cast(columnBuilder, childType.getFloat(column, i));
                        continue block8;
                    }
                    case DOUBLE: {
                        this.cast(columnBuilder, childType.getDouble(column, i));
                        continue block8;
                    }
                    case BOOLEAN: {
                        this.cast(columnBuilder, childType.getBoolean(column, i));
                        continue block8;
                    }
                    case BINARY: {
                        this.cast(columnBuilder, childType.getBinary(column, i));
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", this.childColumnTransformer.getType().getTypeEnum()));
                    }
                }
            }
            columnBuilder.appendNull();
        }
    }

    private void cast(ColumnBuilder columnBuilder, int value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: {
                this.returnType.writeInt(columnBuilder, value);
                break;
            }
            case INT64: {
                this.returnType.writeLong(columnBuilder, (long)value);
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, (float)value);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, (double)value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0);
                break;
            }
            case BINARY: {
                this.returnType.writeBinary(columnBuilder, Binary.valueOf((String)String.valueOf(value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ERROR_MSG, this.returnType.getTypeEnum()));
            }
        }
    }

    private void cast(ColumnBuilder columnBuilder, long value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: {
                this.returnType.writeInt(columnBuilder, CastFunctionHelper.castLongToInt(value));
                break;
            }
            case INT64: {
                this.returnType.writeLong(columnBuilder, value);
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, (float)value);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, (double)value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0L);
                break;
            }
            case BINARY: {
                this.returnType.writeBinary(columnBuilder, Binary.valueOf((String)String.valueOf(value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ERROR_MSG, this.returnType.getTypeEnum()));
            }
        }
    }

    private void cast(ColumnBuilder columnBuilder, float value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: {
                this.returnType.writeInt(columnBuilder, CastFunctionHelper.castFloatToInt(value));
                break;
            }
            case INT64: {
                this.returnType.writeLong(columnBuilder, CastFunctionHelper.castFloatToLong(value));
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, value);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, (double)value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0.0f);
                break;
            }
            case BINARY: {
                this.returnType.writeBinary(columnBuilder, Binary.valueOf((String)String.valueOf(value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ERROR_MSG, this.returnType.getTypeEnum()));
            }
        }
    }

    private void cast(ColumnBuilder columnBuilder, double value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: {
                this.returnType.writeInt(columnBuilder, CastFunctionHelper.castDoubleToInt(value));
                break;
            }
            case INT64: {
                this.returnType.writeLong(columnBuilder, CastFunctionHelper.castDoubleToLong(value));
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, CastFunctionHelper.castDoubleToFloat(value));
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0.0);
                break;
            }
            case BINARY: {
                this.returnType.writeBinary(columnBuilder, Binary.valueOf((String)String.valueOf(value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ERROR_MSG, this.returnType.getTypeEnum()));
            }
        }
    }

    private void cast(ColumnBuilder columnBuilder, boolean value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: {
                this.returnType.writeInt(columnBuilder, value ? 1 : 0);
                break;
            }
            case INT64: {
                this.returnType.writeLong(columnBuilder, value ? 1L : 0L);
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, value ? 1.0f : 0.0f);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, value ? 1.0 : 0.0);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value);
                break;
            }
            case BINARY: {
                this.returnType.writeBinary(columnBuilder, Binary.valueOf((String)String.valueOf(value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ERROR_MSG, this.returnType.getTypeEnum()));
            }
        }
    }

    private void cast(ColumnBuilder columnBuilder, Binary value) {
        String stringValue = value.getStringValue();
        switch (this.returnType.getTypeEnum()) {
            case INT32: {
                this.returnType.writeInt(columnBuilder, Integer.parseInt(stringValue));
                break;
            }
            case INT64: {
                this.returnType.writeLong(columnBuilder, Long.parseLong(stringValue));
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, CastFunctionHelper.castTextToFloat(stringValue));
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, CastFunctionHelper.castTextToDouble(stringValue).doubleValue());
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, CastFunctionHelper.castTextToBoolean(stringValue));
                break;
            }
            case BINARY: {
                this.returnType.writeBinary(columnBuilder, value);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ERROR_MSG, this.returnType.getTypeEnum()));
            }
        }
    }
}

