/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class InsertTabletNode
extends InsertNode
implements WALEntryValue {
    private static final String DATATYPE_UNSUPPORTED = "Data type %s is not supported.";
    private long[] times;
    private BitMap[] bitMaps;
    private Object[] columns;
    private int rowCount = 0;
    private List<Integer> range;

    public InsertTabletNode(PlanNodeId id) {
        super(id);
    }

    public InsertTabletNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, long[] times, BitMap[] bitMaps, Object[] columns, int rowCount) {
        super(id, devicePath, isAligned, measurements, dataTypes);
        this.times = times;
        this.bitMaps = bitMaps;
        this.columns = columns;
        this.rowCount = rowCount;
    }

    public InsertTabletNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, MeasurementSchema[] measurementSchemas, long[] times, BitMap[] bitMaps, Object[] columns, int rowCount) {
        super(id, devicePath, isAligned, measurements, dataTypes);
        this.measurementSchemas = measurementSchemas;
        this.times = times;
        this.bitMaps = bitMaps;
        this.columns = columns;
        this.rowCount = rowCount;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public BitMap[] getBitMaps() {
        return this.bitMaps;
    }

    public void setBitMaps(BitMap[] bitMaps) {
        this.bitMaps = bitMaps;
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public List<Integer> getRange() {
        return this.range;
    }

    public void setRange(List<Integer> range) {
        this.range = range;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of Insert is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        if (this.times.length == 0) {
            return Collections.emptyList();
        }
        long startTime = this.times[0] / TimePartitionUtils.timePartitionInterval * TimePartitionUtils.timePartitionInterval;
        long endTime = startTime + TimePartitionUtils.timePartitionInterval;
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartition(this.times[0]);
        int startLoc = 0;
        ArrayList<TTimePartitionSlot> timePartitionSlots = new ArrayList<TTimePartitionSlot>();
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        for (int i = 1; i < this.times.length; ++i) {
            if (this.times[i] < endTime) continue;
            ranges.add(startLoc);
            ranges.add(i);
            timePartitionSlots.add(timePartitionSlot);
            startLoc = i;
            startTime = endTime;
            endTime = (this.times[i] / TimePartitionUtils.timePartitionInterval + 1L) * TimePartitionUtils.timePartitionInterval;
            timePartitionSlot = TimePartitionUtils.getTimePartition(this.times[i]);
        }
        ranges.add(startLoc);
        ranges.add(this.times.length);
        timePartitionSlots.add(timePartitionSlot);
        List dataRegionReplicaSets = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(this.devicePath.getFullPath(), timePartitionSlots);
        analysis.addEndPointToRedirectNodeList(((TDataNodeLocation)((TRegionReplicaSet)dataRegionReplicaSets.get(dataRegionReplicaSets.size() - 1)).getDataNodeLocations().get(0)).getClientRpcEndPoint());
        HashMap<TRegionReplicaSet, List> splitMap = new HashMap<TRegionReplicaSet, List>();
        for (int i = 0; i < dataRegionReplicaSets.size(); ++i) {
            List sub_ranges = splitMap.computeIfAbsent((TRegionReplicaSet)dataRegionReplicaSets.get(i), x -> new ArrayList());
            sub_ranges.add((Integer)ranges.get(2 * i));
            sub_ranges.add((Integer)ranges.get(2 * i + 1));
        }
        for (Map.Entry entry : splitMap.entrySet()) {
            List locs = (List)entry.getValue();
            if (splitMap.size() == 1 && locs.size() == 2) {
                this.setRange(locs);
                this.setDataRegionReplicaSet((TRegionReplicaSet)entry.getKey());
                result.add(this);
                return result;
            }
            for (int i = 0; i < locs.size(); i += 2) {
                int start = (Integer)locs.get(i);
                int end = (Integer)locs.get(i + 1);
                int count = end - start;
                long[] subTimes = new long[count];
                int destLoc = 0;
                Object[] values = this.initTabletValues(this.dataTypes.length, count, this.dataTypes);
                BitMap[] bitMaps = this.bitMaps == null ? null : this.initBitmaps(this.dataTypes.length, count);
                System.arraycopy(this.times, start, subTimes, destLoc, end - start);
                for (int k = 0; k < values.length; ++k) {
                    System.arraycopy(this.columns[k], start, values[k], destLoc, end - start);
                    if (bitMaps == null || this.bitMaps[k] == null) continue;
                    BitMap.copyOfRange((BitMap)this.bitMaps[k], (int)start, (BitMap)bitMaps[k], (int)destLoc, (int)(end - start));
                }
                InsertTabletNode subNode = new InsertTabletNode(this.getPlanNodeId(), this.devicePath, this.isAligned, this.measurements, this.dataTypes, this.measurementSchemas, subTimes, bitMaps, values, subTimes.length);
                subNode.setRange(locs);
                subNode.setDataRegionReplicaSet((TRegionReplicaSet)entry.getKey());
                result.add(subNode);
            }
        }
        return result;
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        long startTime = this.times[0] / TimePartitionUtils.timePartitionInterval * TimePartitionUtils.timePartitionInterval;
        long endTime = startTime + TimePartitionUtils.timePartitionInterval;
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartition(this.times[0]);
        for (int i = 1; i < this.times.length; ++i) {
            if (this.times[i] < endTime) continue;
            result.add(timePartitionSlot);
            endTime = (this.times[i] / TimePartitionUtils.timePartitionInterval + 1L) * TimePartitionUtils.timePartitionInterval;
            timePartitionSlot = TimePartitionUtils.getTimePartition(this.times[i]);
        }
        result.add(timePartitionSlot);
        return result;
    }

    private Object[] initTabletValues(int columnSize, int rowSize, TSDataType[] dataTypes) {
        Object[] values = new Object[columnSize];
        block8: for (int i = 0; i < values.length; ++i) {
            switch (dataTypes[i]) {
                case TEXT: {
                    values[i] = new Binary[rowSize];
                    continue block8;
                }
                case FLOAT: {
                    values[i] = new float[rowSize];
                    continue block8;
                }
                case INT32: {
                    values[i] = new int[rowSize];
                    continue block8;
                }
                case INT64: {
                    values[i] = new long[rowSize];
                    continue block8;
                }
                case DOUBLE: {
                    values[i] = new double[rowSize];
                    continue block8;
                }
                case BOOLEAN: {
                    values[i] = new boolean[rowSize];
                }
            }
        }
        return values;
    }

    private BitMap[] initBitmaps(int columnSize, int rowSize) {
        BitMap[] bitMaps = new BitMap[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            bitMaps[i] = new BitMap(rowSize);
        }
        return bitMaps;
    }

    @Override
    public void markFailedMeasurement(int index) {
        if (this.measurements[index] == null) {
            return;
        }
        this.measurements[index] = null;
        this.dataTypes[index] = null;
        this.columns[index] = null;
    }

    @Override
    public long getMinTime() {
        return this.times[0];
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INSERT_TABLET.serialize(byteBuffer);
        this.subSerialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INSERT_TABLET.serialize(stream);
        this.subSerialize(stream);
    }

    void subSerialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((String)this.devicePath.getFullPath(), (ByteBuffer)buffer);
        this.writeMeasurementsOrSchemas(buffer);
        this.writeDataTypes(buffer);
        this.writeTimes(buffer);
        this.writeBitMaps(buffer);
        this.writeValues(buffer);
        ReadWriteIOUtils.write((byte)((byte)(this.isAligned ? 1 : 0)), (ByteBuffer)buffer);
    }

    void subSerialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.devicePath.getFullPath(), (OutputStream)stream);
        this.writeMeasurementsOrSchemas(stream);
        this.writeDataTypes(stream);
        this.writeTimes(stream);
        this.writeBitMaps(stream);
        this.writeValues(stream);
        ReadWriteIOUtils.write((byte)((byte)(this.isAligned ? 1 : 0)), (OutputStream)stream);
    }

    private void writeMeasurementsOrSchemas(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)(this.measurements.length - this.getFailedMeasurementNumber()), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((byte)((byte)(this.measurementSchemas != null ? 1 : 0)), (ByteBuffer)buffer);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.measurementSchemas != null) {
                this.measurementSchemas[i].serializeTo(buffer);
                continue;
            }
            ReadWriteIOUtils.write((String)this.measurements[i], (ByteBuffer)buffer);
        }
    }

    private void writeMeasurementsOrSchemas(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)(this.measurements.length - this.getFailedMeasurementNumber()), (OutputStream)stream);
        ReadWriteIOUtils.write((byte)((byte)(this.measurementSchemas != null ? 1 : 0)), (OutputStream)stream);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.measurementSchemas != null) {
                this.measurementSchemas[i].serializeTo((OutputStream)stream);
                continue;
            }
            ReadWriteIOUtils.write((String)this.measurements[i], (OutputStream)stream);
        }
    }

    private void writeDataTypes(ByteBuffer buffer) {
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.dataTypes[i].serializeTo(buffer);
        }
    }

    private void writeDataTypes(DataOutputStream stream) throws IOException {
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.dataTypes[i].serializeTo(stream);
        }
    }

    private void writeTimes(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)this.rowCount, (ByteBuffer)buffer);
        for (long time : this.times) {
            ReadWriteIOUtils.write((long)time, (ByteBuffer)buffer);
        }
    }

    private void writeTimes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.rowCount, (OutputStream)stream);
        for (long time : this.times) {
            ReadWriteIOUtils.write((long)time, (OutputStream)stream);
        }
    }

    private void writeBitMaps(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0), (ByteBuffer)buffer);
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)false), (ByteBuffer)buffer);
                    continue;
                }
                ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)true), (ByteBuffer)buffer);
                buffer.put(this.bitMaps[i].getByteArray());
            }
        }
    }

    private void writeBitMaps(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0), (OutputStream)stream);
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)false), (OutputStream)stream);
                    continue;
                }
                ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)true), (OutputStream)stream);
                stream.write(this.bitMaps[i].getByteArray());
            }
        }
    }

    private void writeValues(ByteBuffer buffer) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], buffer);
        }
    }

    private void writeValues(DataOutputStream stream) throws IOException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], stream);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, ByteBuffer buffer) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((int)intValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((long)longValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((float)floatValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((double)doubleValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)boolValues[j]), (ByteBuffer)buffer);
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((Binary)binaryValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, DataOutputStream stream) throws IOException {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((int)intValues[j], (OutputStream)stream);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((long)longValues[j], (OutputStream)stream);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((float)floatValues[j], (OutputStream)stream);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((double)doubleValues[j], (OutputStream)stream);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)boolValues[j]), (OutputStream)stream);
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((Binary)binaryValues[j], (OutputStream)stream);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    public static InsertTabletNode deserialize(ByteBuffer byteBuffer) {
        InsertTabletNode insertNode = new InsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserialize(byteBuffer);
        insertNode.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return insertNode;
    }

    public void subDeserialize(ByteBuffer buffer) {
        int i;
        boolean hasSchema;
        try {
            this.devicePath = new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertTabletNode", e);
        }
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        boolean bl = hasSchema = buffer.get() == 1;
        if (hasSchema) {
            this.measurementSchemas = new MeasurementSchema[measurementSize];
            for (i = 0; i < measurementSize; ++i) {
                this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((ByteBuffer)buffer);
                this.measurements[i] = this.measurementSchemas[i].getMeasurementId();
            }
        } else {
            for (i = 0; i < measurementSize; ++i) {
                this.measurements[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            }
        }
        this.dataTypes = new TSDataType[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.dataTypes[i] = TSDataType.deserialize((byte)buffer.get());
        }
        this.rowCount = buffer.getInt();
        this.times = new long[this.rowCount];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, this.rowCount);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)buffer.get());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromBuffer(buffer, measurementSize, this.rowCount).orElse(null);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromBuffer(buffer, this.dataTypes, measurementSize, this.rowCount);
        this.isAligned = buffer.get() == 1;
    }

    @Override
    public int serializedSize() {
        return this.serializedSize(0, this.rowCount);
    }

    public int serializedSize(int start, int end) {
        return 2 + this.subSerializeSize(start, end);
    }

    int subSerializeSize(int start, int end) {
        int i;
        int size = 0;
        size += 8;
        size += ReadWriteIOUtils.sizeToWrite((String)this.devicePath.getFullPath());
        size += 4;
        size += this.serializeMeasurementSchemasSize();
        size += 4;
        size += 8 * (end - start);
        ++size;
        if (this.bitMaps != null) {
            for (i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                ++size;
                if (this.bitMaps[i] == null) continue;
                int len = end - start;
                BitMap partBitMap = new BitMap(len);
                BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)start, (BitMap)partBitMap, (int)0, (int)len);
                size += partBitMap.getByteArray().length;
            }
        }
        for (i = 0; i < this.dataTypes.length; ++i) {
            if (this.columns[i] == null) continue;
            size += this.getColumnSize(this.dataTypes[i], this.columns[i], start, end);
        }
        return ++size;
    }

    private int getColumnSize(TSDataType dataType, Object column, int start, int end) {
        int size = 0;
        switch (dataType) {
            case INT32: {
                size += 4 * (end - start);
                break;
            }
            case INT64: {
                size += 8 * (end - start);
                break;
            }
            case FLOAT: {
                size += 4 * (end - start);
                break;
            }
            case DOUBLE: {
                size += 8 * (end - start);
                break;
            }
            case BOOLEAN: {
                size += 1 * (end - start);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    size += ReadWriteIOUtils.sizeToWrite((Binary)binaryValues[j]);
                }
                break;
            }
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        this.serializeToWAL(buffer, 0, this.rowCount);
    }

    public void serializeToWAL(IWALByteBufferView buffer, int start, int end) {
        buffer.putShort(PlanNodeType.INSERT_TABLET.getNodeType());
        this.subSerialize(buffer, start, end);
    }

    void subSerialize(IWALByteBufferView buffer, int start, int end) {
        buffer.putLong(this.searchIndex);
        WALWriteUtils.write(this.devicePath.getFullPath(), buffer);
        this.writeMeasurementSchemas(buffer);
        this.writeTimes(buffer, start, end);
        this.writeBitMaps(buffer, start, end);
        this.writeValues(buffer, start, end);
        buffer.put((byte)(this.isAligned ? 1 : 0));
    }

    private void writeMeasurementSchemas(IWALByteBufferView buffer) {
        buffer.putInt(this.measurements.length - this.getFailedMeasurementNumber());
        this.serializeMeasurementSchemasToWAL(buffer);
    }

    private void writeTimes(IWALByteBufferView buffer, int start, int end) {
        buffer.putInt(end - start);
        for (int i = start; i < end; ++i) {
            buffer.putLong(this.times[i]);
        }
    }

    private void writeBitMaps(IWALByteBufferView buffer, int start, int end) {
        buffer.put(BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0));
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    buffer.put(BytesUtils.boolToByte((boolean)false));
                    continue;
                }
                buffer.put(BytesUtils.boolToByte((boolean)true));
                int len = end - start;
                BitMap partBitMap = new BitMap(len);
                BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)start, (BitMap)partBitMap, (int)0, (int)len);
                buffer.put(partBitMap.getByteArray());
            }
        }
    }

    private void writeValues(IWALByteBufferView buffer, int start, int end) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], buffer, start, end);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, IWALByteBufferView buffer, int start, int end) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(intValues[j]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = start; j < end; ++j) {
                    buffer.put(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(binaryValues[j].getLength());
                    buffer.put(binaryValues[j].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    public static InsertTabletNode deserializeFromWAL(DataInputStream stream) throws IOException {
        InsertTabletNode insertNode = new InsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserializeFromWAL(stream);
        return insertNode;
    }

    private void subDeserializeFromWAL(DataInputStream stream) throws IOException {
        this.searchIndex = stream.readLong();
        try {
            this.devicePath = new PartialPath(ReadWriteIOUtils.readString((InputStream)stream));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertTabletNode", e);
        }
        int measurementSize = stream.readInt();
        this.measurements = new String[measurementSize];
        this.measurementSchemas = new MeasurementSchema[measurementSize];
        this.dataTypes = new TSDataType[measurementSize];
        this.deserializeMeasurementSchemas(stream);
        this.rowCount = stream.readInt();
        this.times = new long[this.rowCount];
        this.times = QueryDataSetUtils.readTimesFromStream(stream, this.rowCount);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)stream.readByte());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromStream(stream, measurementSize, this.rowCount).orElse(null);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromStream(stream, this.dataTypes, measurementSize, this.rowCount);
        this.isAligned = stream.readByte() == 1;
    }

    public static InsertTabletNode deserializeFromWAL(ByteBuffer buffer) {
        InsertTabletNode insertNode = new InsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserializeFromWAL(buffer);
        return insertNode;
    }

    private void subDeserializeFromWAL(ByteBuffer buffer) {
        this.searchIndex = buffer.getLong();
        try {
            this.devicePath = new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertTabletNode", e);
        }
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        this.measurementSchemas = new MeasurementSchema[measurementSize];
        this.deserializeMeasurementSchemas(buffer);
        this.dataTypes = new TSDataType[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.dataTypes[i] = this.measurementSchemas[i].getType();
        }
        this.rowCount = buffer.getInt();
        this.times = new long[this.rowCount];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, this.rowCount);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)buffer.get());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromBuffer(buffer, measurementSize, this.rowCount).orElse(null);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromBuffer(buffer, this.dataTypes, measurementSize, this.rowCount);
        this.isAligned = buffer.get() == 1;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.rowCount, this.range);
        result = 31 * result + Arrays.hashCode(this.times);
        result = 31 * result + Arrays.hashCode(this.bitMaps);
        result = 31 * result + Arrays.deepHashCode(this.columns);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertTabletNode that = (InsertTabletNode)o;
        return this.rowCount == that.rowCount && Arrays.equals(this.times, that.times) && Arrays.equals(this.bitMaps, that.bitMaps) && this.equals(that.columns) && Objects.equals(this.range, that.range);
    }

    private boolean equals(Object[] columns) {
        if (this.columns == columns) {
            return true;
        }
        if (columns == null || this.columns == null || columns.length != this.columns.length) {
            return false;
        }
        block8: for (int i = 0; i < columns.length; ++i) {
            if (this.dataTypes[i] != null) {
                switch (this.dataTypes[i]) {
                    case INT32: {
                        if (Arrays.equals((int[])this.columns[i], (int[])columns[i])) continue block8;
                        return false;
                    }
                    case INT64: {
                        if (Arrays.equals((long[])this.columns[i], (long[])columns[i])) continue block8;
                        return false;
                    }
                    case FLOAT: {
                        if (Arrays.equals((float[])this.columns[i], (float[])columns[i])) continue block8;
                        return false;
                    }
                    case DOUBLE: {
                        if (Arrays.equals((double[])this.columns[i], (double[])columns[i])) continue block8;
                        return false;
                    }
                    case BOOLEAN: {
                        if (Arrays.equals((boolean[])this.columns[i], (boolean[])columns[i])) continue block8;
                        return false;
                    }
                    case TEXT: {
                        if (Arrays.equals((Binary[])this.columns[i], (Binary[])columns[i])) continue block8;
                        return false;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[i]));
                    }
                }
            }
            if (columns[i].equals(columns)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInsertTablet(this, context);
    }

    public TimeValuePair composeLastTimeValuePair(int measurementIndex) {
        TsPrimitiveType.TsInt value;
        int lastIdx;
        if (measurementIndex >= this.columns.length) {
            return null;
        }
        if (this.bitMaps != null && this.bitMaps[measurementIndex] != null) {
            BitMap bitMap = this.bitMaps[measurementIndex];
            for (lastIdx = this.rowCount - 1; lastIdx >= 0 && bitMap.isMarked(lastIdx); --lastIdx) {
            }
        }
        if (lastIdx < 0) {
            return null;
        }
        switch (this.dataTypes[measurementIndex]) {
            case INT32: {
                int[] intValues = (int[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsInt(intValues[lastIdx]);
                break;
            }
            case INT64: {
                long[] longValues = (long[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsLong(longValues[lastIdx]);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsFloat(floatValues[lastIdx]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsDouble(doubleValues[lastIdx]);
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBoolean(boolValues[lastIdx]);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBinary(binaryValues[lastIdx]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[measurementIndex]));
            }
        }
        return new TimeValuePair(this.times[lastIdx], (TsPrimitiveType)value);
    }
}

