/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.stage;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.plugin.builtin.processor.DoNothingProcessor;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskRuntimeEnvironment;
import org.apache.iotdb.db.pipe.execution.executor.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.execution.executor.PipeSubtaskExecutorManager;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.task.connection.EventSupplier;
import org.apache.iotdb.db.pipe.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskStage;
import org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtask;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeTaskProcessorStage
extends PipeTaskStage {
    private final PipeProcessorSubtaskExecutor executor = PipeSubtaskExecutorManager.getInstance().getProcessorSubtaskExecutor();
    private final PipeProcessorSubtask pipeProcessorSubtask;

    public PipeTaskProcessorStage(String pipeName, long creationTime, PipeParameters pipeProcessorParameters, TConsensusGroupId dataRegionId, EventSupplier pipeExtractorInputEventSupplier, BoundedBlockingPendingQueue<Event> pipeConnectorOutputPendingQueue) {
        DoNothingProcessor pipeProcessor = pipeProcessorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()).equals(BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()) ? new DoNothingProcessor() : PipeAgent.plugin().reflectProcessor(pipeProcessorParameters);
        try {
            pipeProcessor.validate(new PipeParameterValidator(pipeProcessorParameters));
            PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration(new PipeTaskRuntimeEnvironment(pipeName, creationTime));
            pipeProcessor.customize(pipeProcessorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration);
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
        String taskId = pipeName + "_" + dataRegionId + "_" + creationTime;
        PipeEventCollector pipeConnectorOutputEventCollector = new PipeEventCollector(pipeConnectorOutputPendingQueue);
        this.pipeProcessorSubtask = new PipeProcessorSubtask(taskId, pipeExtractorInputEventSupplier, (PipeProcessor)pipeProcessor, pipeConnectorOutputEventCollector);
    }

    @Override
    public void createSubtask() throws PipeException {
        this.executor.register(this.pipeProcessorSubtask);
    }

    @Override
    public void startSubtask() throws PipeException {
        this.executor.start(this.pipeProcessorSubtask.getTaskID());
    }

    @Override
    public void stopSubtask() throws PipeException {
        this.executor.stop(this.pipeProcessorSubtask.getTaskID());
    }

    @Override
    public void dropSubtask() throws PipeException {
        this.executor.deregister(this.pipeProcessorSubtask.getTaskID());
    }
}

