/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime.assigner;

import com.lmax.disruptor.EventHandler;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.assigner.DisruptorQueue;
import org.apache.iotdb.db.pipe.extractor.realtime.matcher.CachedSchemaPatternMatcher;
import org.apache.iotdb.db.pipe.extractor.realtime.matcher.PipeDataRegionMatcher;

public class PipeDataRegionAssigner {
    private final PipeDataRegionMatcher matcher = new CachedSchemaPatternMatcher();
    private final DisruptorQueue disruptor = new DisruptorQueue((EventHandler<PipeRealtimeEvent>)((EventHandler)this::assignToExtractor));

    public void publishToAssign(PipeRealtimeEvent event) {
        event.increaseReferenceCount(PipeDataRegionAssigner.class.getName());
        this.disruptor.publish(event);
        if (event.getEvent() instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event.getEvent()).onPublished();
        }
    }

    public void assignToExtractor(PipeRealtimeEvent event, long sequence, boolean endOfBatch) {
        this.matcher.match(event).forEach(extractor -> {
            if (event.getEvent().isGeneratedByPipe() && !extractor.isForwardingPipeRequests()) {
                return;
            }
            PipeRealtimeEvent copiedEvent = event.shallowCopySelfAndBindPipeTaskMetaForProgressReport(extractor.getPipeTaskMeta(), extractor.getPattern());
            copiedEvent.increaseReferenceCount(PipeDataRegionAssigner.class.getName());
            extractor.extract(copiedEvent);
            EnrichedEvent innerEvent = copiedEvent.getEvent();
            if (innerEvent instanceof PipeHeartbeatEvent) {
                ((PipeHeartbeatEvent)innerEvent).bindPipeName(extractor.getPipeName());
                ((PipeHeartbeatEvent)innerEvent).onAssigned();
            }
        });
        event.gcSchemaInfo();
        event.decreaseReferenceCount(PipeDataRegionAssigner.class.getName(), false);
    }

    public void startAssignTo(PipeRealtimeDataRegionExtractor extractor) {
        this.matcher.register(extractor);
    }

    public void stopAssignTo(PipeRealtimeDataRegionExtractor extractor) {
        this.matcher.deregister(extractor);
    }

    public boolean notMoreExtractorNeededToBeAssigned() {
        return this.matcher.getRegisterCount() == 0;
    }

    public void gc() {
        this.matcher.clear();
        this.disruptor.clear();
    }
}

