/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.agent.runtime.PipeAgentLauncher;
import org.apache.iotdb.db.pipe.agent.runtime.PipeCronEventInjector;
import org.apache.iotdb.db.pipe.agent.runtime.SimpleConsensusProgressIndexAssigner;
import org.apache.iotdb.db.pipe.resource.PipeHardlinkFileDirStartupCleaner;
import org.apache.iotdb.db.service.ResourcesInformationHolder;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRuntimeAgent
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRuntimeAgent.class);
    private static final int DATA_NODE_ID = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final PipeCronEventInjector pipeCronEventInjector = new PipeCronEventInjector();
    private final SimpleConsensusProgressIndexAssigner simpleConsensusProgressIndexAssigner = new SimpleConsensusProgressIndexAssigner();

    public synchronized void preparePipeResources(ResourcesInformationHolder resourcesInformationHolder) throws StartupException {
        PipeHardlinkFileDirStartupCleaner.clean();
        PipeAgent.receiver().cleanPipeReceiverDir();
        PipeAgentLauncher.launchPipePluginAgent(resourcesInformationHolder);
        this.simpleConsensusProgressIndexAssigner.start();
    }

    public synchronized void start() throws StartupException {
        PipeConfig.getInstance().printAllConfigs();
        PipeAgentLauncher.launchPipeTaskAgent();
        this.pipeCronEventInjector.start();
        this.isShutdown.set(false);
    }

    public synchronized void stop() {
        if (this.isShutdown.get()) {
            return;
        }
        this.isShutdown.set(true);
        this.pipeCronEventInjector.stop();
        PipeAgent.task().dropAllPipeTasks();
    }

    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    public ServiceType getID() {
        return ServiceType.PIPE_RUNTIME_AGENT;
    }

    public void assignSimpleProgressIndexIfNeeded(TsFileResource tsFileResource) {
        this.simpleConsensusProgressIndexAssigner.assignIfNeeded(tsFileResource);
    }

    public void assignRecoverProgressIndexForTsFileRecovery(TsFileResource tsFileResource) {
        tsFileResource.recoverProgressIndex((ProgressIndex)new RecoverProgressIndex(DATA_NODE_ID, this.simpleConsensusProgressIndexAssigner.getSimpleProgressIndexForTsFileRecovery()));
    }

    public void assignUpdateProgressIndexForTsFileRecovery(TsFileResource tsFileResource) {
        tsFileResource.updateProgressIndex((ProgressIndex)new RecoverProgressIndex(DATA_NODE_ID, this.simpleConsensusProgressIndexAssigner.getSimpleProgressIndexForTsFileRecovery()));
    }

    public void report(PipeTaskMeta pipeTaskMeta, PipeRuntimeException pipeRuntimeException) {
        LOGGER.warn("Report PipeRuntimeException to local PipeTaskMeta({}), exception message: {}", new Object[]{pipeTaskMeta, pipeRuntimeException.getMessage(), pipeRuntimeException});
        pipeTaskMeta.trackExceptionMessage(pipeRuntimeException);
        if (pipeRuntimeException instanceof PipeRuntimeCriticalException) {
            PipeAgent.task().stopAllPipesWithCriticalException();
        }
    }
}

