/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;

public abstract class BinaryFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 1039585564327602465L;
    protected Filter left;
    protected Filter right;

    protected BinaryFilter() {
    }

    protected BinaryFilter(Filter left, Filter right) {
        this.left = left;
        this.right = right;
    }

    public void setLeft(Filter left) {
        this.left = left;
    }

    public Filter getLeft() {
        return this.left;
    }

    public void setRight(Filter right) {
        this.right = right;
    }

    public Filter getRight() {
        return this.right;
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            this.left.serialize(outputStream);
            this.right.serialize(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.left = FilterFactory.deserialize(buffer);
        this.right = FilterFactory.deserialize(buffer);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryFilter)) {
            return false;
        }
        BinaryFilter other = (BinaryFilter)obj;
        return this.left.equals(other.left) && this.right.equals(other.right) && this.getSerializeId().equals((Object)other.getSerializeId());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.right, this.getSerializeId()});
    }
}

