/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;

public class AlignedTimeSeriesMetadata
implements ITimeSeriesMetadata {
    private final TimeseriesMetadata timeseriesMetadata;
    private final List<TimeseriesMetadata> valueTimeseriesMetadataList;
    private IChunkMetadataLoader chunkMetadataLoader;

    public AlignedTimeSeriesMetadata(TimeseriesMetadata timeseriesMetadata, List<TimeseriesMetadata> valueTimeseriesMetadataList) {
        this.timeseriesMetadata = timeseriesMetadata;
        this.valueTimeseriesMetadataList = valueTimeseriesMetadataList;
    }

    @Override
    public Statistics getStatistics() {
        return this.valueTimeseriesMetadataList.size() == 1 && this.valueTimeseriesMetadataList.get(0) != null ? this.valueTimeseriesMetadataList.get(0).getStatistics() : this.timeseriesMetadata.getStatistics();
    }

    public Statistics getStatistics(int index) {
        TimeseriesMetadata v = this.valueTimeseriesMetadataList.get(index);
        return v == null ? null : v.getStatistics();
    }

    public List<Statistics> getValueStatisticsList() {
        ArrayList<Statistics> valueStatisticsList = new ArrayList<Statistics>();
        for (TimeseriesMetadata v : this.valueTimeseriesMetadataList) {
            valueStatisticsList.add(v == null ? null : v.getStatistics());
        }
        return valueStatisticsList;
    }

    public Statistics getTimeStatistics() {
        return this.timeseriesMetadata.getStatistics();
    }

    @Override
    public boolean isModified() {
        return this.timeseriesMetadata.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        this.timeseriesMetadata.setModified(modified);
        for (TimeseriesMetadata subSensor : this.valueTimeseriesMetadataList) {
            if (subSensor == null) continue;
            subSensor.setModified(modified);
        }
    }

    @Override
    public boolean isSeq() {
        return this.timeseriesMetadata.isSeq();
    }

    @Override
    public void setSeq(boolean seq) {
        this.timeseriesMetadata.setSeq(seq);
        for (TimeseriesMetadata subSensor : this.valueTimeseriesMetadataList) {
            if (subSensor == null) continue;
            subSensor.setSeq(seq);
        }
    }

    @Override
    public List<IChunkMetadata> loadChunkMetadataList() {
        return this.chunkMetadataLoader.loadChunkMetadataList(this);
    }

    public List<AlignedChunkMetadata> getCopiedChunkMetadataList() {
        List<IChunkMetadata> timeChunkMetadata = this.timeseriesMetadata.getCopiedChunkMetadataList();
        ArrayList<List<IChunkMetadata>> valueChunkMetadataList = new ArrayList<List<IChunkMetadata>>();
        for (TimeseriesMetadata metadata : this.valueTimeseriesMetadataList) {
            valueChunkMetadataList.add(metadata == null ? null : metadata.getCopiedChunkMetadataList());
        }
        return this.getAlignedChunkMetadata(timeChunkMetadata, valueChunkMetadataList);
    }

    public List<AlignedChunkMetadata> getChunkMetadataList() {
        List<IChunkMetadata> timeChunkMetadata = this.timeseriesMetadata.getChunkMetadataList();
        ArrayList<List<IChunkMetadata>> valueChunkMetadataList = new ArrayList<List<IChunkMetadata>>();
        for (TimeseriesMetadata metadata : this.valueTimeseriesMetadataList) {
            valueChunkMetadataList.add(metadata == null ? null : metadata.getChunkMetadataList());
        }
        return this.getAlignedChunkMetadata(timeChunkMetadata, valueChunkMetadataList);
    }

    private List<AlignedChunkMetadata> getAlignedChunkMetadata(List<IChunkMetadata> timeChunkMetadata, List<List<IChunkMetadata>> valueChunkMetadataList) {
        ArrayList<AlignedChunkMetadata> res = new ArrayList<AlignedChunkMetadata>();
        for (int i = 0; i < timeChunkMetadata.size(); ++i) {
            if (this.valueTimeseriesMetadataList.isEmpty()) {
                res.add(new AlignedChunkMetadata(timeChunkMetadata.get(i), Collections.emptyList()));
                continue;
            }
            ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>();
            boolean exits = false;
            for (List<IChunkMetadata> chunkMetadata : valueChunkMetadataList) {
                IChunkMetadata v = chunkMetadata == null || chunkMetadata.get(i).getStatistics().getCount() == 0L ? null : chunkMetadata.get(i);
                exits = exits || v != null;
                chunkMetadataList.add(v);
            }
            if (!exits) continue;
            res.add(new AlignedChunkMetadata(timeChunkMetadata.get(i), chunkMetadataList));
        }
        return res;
    }

    @Override
    public void setChunkMetadataLoader(IChunkMetadataLoader chunkMetadataLoader) {
        this.chunkMetadataLoader = chunkMetadataLoader;
    }

    public List<TimeseriesMetadata> getValueTimeseriesMetadataList() {
        return this.valueTimeseriesMetadataList;
    }

    public TimeseriesMetadata getTimeseriesMetadata() {
        return this.timeseriesMetadata;
    }
}

