/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.runtime.StorageEngineFailureException;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.WALNodeRecoverTask;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALRecoverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALRecoverManager {
    private static final Logger logger = LoggerFactory.getLogger(WALRecoverManager.class);
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private volatile boolean hasStarted = false;
    private volatile CountDownLatch allDataRegionScannedLatch;
    private ExecutorService recoverThreadPool;
    private final Map<String, UnsealedTsFileRecoverPerformer> absolutePath2RecoverPerformer = new ConcurrentHashMap<String, UnsealedTsFileRecoverPerformer>();

    private WALRecoverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws WALRecoverException {
        block22: {
            logger.info("Start recovering wal.");
            try {
                ArrayList walNodeDirs = new ArrayList();
                for (String walDir : commonConfig.getWalDirs()) {
                    File walDirFile = SystemFileFactory.INSTANCE.getFile(walDir);
                    File[] nodeDirs = walDirFile.listFiles(File::isDirectory);
                    if (nodeDirs == null) continue;
                    for (File nodeDir : nodeDirs) {
                        if (!nodeDir.isDirectory()) continue;
                        walNodeDirs.add(nodeDir);
                    }
                }
                try {
                    this.allDataRegionScannedLatch.await();
                    this.hasStarted = true;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new WALRecoverException("Fail to recover wal.", interruptedException);
                }
                logger.info("Data regions have submitted all unsealed TsFiles, start recovering TsFiles in each wal node.");
                if (!walNodeDirs.isEmpty()) {
                    this.recoverThreadPool = IoTDBThreadPoolFactory.newCachedThreadPool((String)ThreadName.WAL_RECOVER.getName());
                    CountDownLatch countDownLatch = new CountDownLatch(walNodeDirs.size());
                    Iterator iterator = walNodeDirs.iterator();
                    while (iterator.hasNext()) {
                        File walNodeDir = (File)iterator.next();
                        this.recoverThreadPool.submit(new WALNodeRecoverTask(walNodeDir, countDownLatch));
                    }
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WALRecoverException("Fail to recover wal.", e);
                    }
                }
                this.asyncRecoverLeftTsFiles();
            }
            catch (Exception e) {
                for (UnsealedTsFileRecoverPerformer recoverPerformer : this.absolutePath2RecoverPerformer.values()) {
                    recoverPerformer.getRecoverListener().fail(e);
                }
                break block22;
            }
            finally {
                for (UnsealedTsFileRecoverPerformer unsealedTsFileRecoverPerformer : this.absolutePath2RecoverPerformer.values()) {
                    try {
                        if (unsealedTsFileRecoverPerformer.canWrite()) continue;
                        unsealedTsFileRecoverPerformer.close();
                    }
                    catch (Exception exception) {}
                }
                this.stop();
            }
            for (UnsealedTsFileRecoverPerformer unsealedTsFileRecoverPerformer : this.absolutePath2RecoverPerformer.values()) {
                try {
                    if (unsealedTsFileRecoverPerformer.canWrite()) continue;
                    unsealedTsFileRecoverPerformer.close();
                }
                catch (Exception e) {}
            }
            this.stop();
        }
        logger.info("Successfully recover all wal nodes.");
    }

    private void asyncRecoverLeftTsFiles() {
        if (this.absolutePath2RecoverPerformer.isEmpty()) {
            return;
        }
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ExecutorService recoverTsFilesThreadPool = IoTDBThreadPoolFactory.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors(), (String)ThreadName.TSFILE_RECOVER.getName());
        for (UnsealedTsFileRecoverPerformer unsealedTsFileRecoverPerformer : this.absolutePath2RecoverPerformer.values()) {
            Callable<Void> recoverTsFileTask = () -> {
                try {
                    recoverPerformer.startRecovery();
                    recoverPerformer.endRecovery();
                    recoverPerformer.getRecoverListener().succeed();
                }
                catch (IOException | DataRegionException | WALRecoverException e) {
                    logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverPerformer.getTsFileAbsolutePath(), e);
                    recoverPerformer.getRecoverListener().fail((Exception)e);
                }
                return null;
            };
            futures.add(recoverTsFilesThreadPool.submit(recoverTsFileTask));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
            }
        }
        recoverTsFilesThreadPool.shutdown();
    }

    public WALRecoverListener addRecoverPerformer(UnsealedTsFileRecoverPerformer recoverPerformer) {
        if (this.hasStarted) {
            logger.error("Cannot recover tsfile from wal because wal recovery has already started");
            return null;
        }
        try {
            String canonicalPath = recoverPerformer.getTsFileResource().getTsFile().getCanonicalPath();
            this.absolutePath2RecoverPerformer.put(canonicalPath, recoverPerformer);
        }
        catch (IOException e) {
            logger.error("Fail to add recover performer for file {}", (Object)recoverPerformer.getTsFileAbsolutePath(), (Object)e);
        }
        return recoverPerformer.getRecoverListener();
    }

    UnsealedTsFileRecoverPerformer removeRecoverPerformer(File file) {
        try {
            String canonicalPath = file.getCanonicalPath();
            return this.absolutePath2RecoverPerformer.remove(canonicalPath);
        }
        catch (IOException e) {
            logger.error("Fail to remove recover performer for file {}", (Object)file, (Object)e);
            return null;
        }
    }

    public CountDownLatch getAllDataRegionScannedLatch() {
        return this.allDataRegionScannedLatch;
    }

    public void setAllDataRegionScannedLatch(CountDownLatch allDataRegionScannedLatch) {
        this.allDataRegionScannedLatch = allDataRegionScannedLatch;
    }

    public void stop() {
        this.absolutePath2RecoverPerformer.clear();
        if (this.recoverThreadPool != null) {
            this.recoverThreadPool.shutdown();
            this.recoverThreadPool = null;
        }
    }

    public void clear() {
        this.stop();
        this.hasStarted = false;
    }

    public static WALRecoverManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final WALRecoverManager INSTANCE = new WALRecoverManager();

        private InstanceHolder() {
        }
    }
}

