/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class CompactionTsFileWriter
extends TsFileIOWriter {
    CompactionType type;
    private volatile boolean isWritingAligned = false;

    public CompactionTsFileWriter(File file, boolean enableMemoryControl, long maxMetadataSize, CompactionType type) throws IOException {
        super(file, enableMemoryControl, maxMetadataSize);
        this.type = type;
    }

    public void markStartingWritingAligned() {
        this.isWritingAligned = true;
    }

    public void markEndingWritingAligned() {
        this.isWritingAligned = false;
    }

    public void writeChunk(IChunkWriter chunkWriter) throws IOException {
        boolean isAligned = chunkWriter instanceof AlignedChunkWriterImpl;
        long beforeOffset = this.getPos();
        chunkWriter.writeToFileWriter((TsFileIOWriter)this);
        long writtenDataSize = this.getPos() - beforeOffset;
        this.acquireWrittenDataSizeWithCompactionWriteRateLimiter(writtenDataSize);
        CompactionMetrics.getInstance().recordWriteInfo(this.type, isAligned ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, writtenDataSize);
    }

    public void writeChunk(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        long beforeOffset = this.getPos();
        super.writeChunk(chunk, chunkMetadata);
        long writtenDataSize = this.getPos() - beforeOffset;
        this.acquireWrittenDataSizeWithCompactionWriteRateLimiter(writtenDataSize);
        CompactionMetrics.getInstance().recordWriteInfo(this.type, this.isWritingAligned ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, writtenDataSize);
    }

    public void writeEmptyValueChunk(String measurementId, CompressionType compressionType, TSDataType tsDataType, TSEncoding encodingType, Statistics<? extends Serializable> statistics) throws IOException {
        long beforeOffset = this.getPos();
        super.writeEmptyValueChunk(measurementId, compressionType, tsDataType, encodingType, statistics);
        long writtenDataSize = this.getPos() - beforeOffset;
        CompactionMetrics.getInstance().recordWriteInfo(this.type, CompactionIoDataType.ALIGNED, writtenDataSize);
        this.acquireWrittenDataSizeWithCompactionWriteRateLimiter(writtenDataSize);
    }

    public int checkMetadataSizeAndMayFlush() throws IOException {
        int size = super.checkMetadataSizeAndMayFlush();
        this.acquireWrittenDataSizeWithCompactionWriteRateLimiter(size);
        CompactionMetrics.getInstance().recordWriteInfo(this.type, CompactionIoDataType.METADATA, size);
        return size;
    }

    public void endFile() throws IOException {
        long beforeSize = this.getPos();
        super.endFile();
        long writtenDataSize = this.getPos() - beforeSize;
        this.acquireWrittenDataSizeWithCompactionWriteRateLimiter(writtenDataSize);
        CompactionMetrics.getInstance().recordWriteInfo(this.type, CompactionIoDataType.METADATA, writtenDataSize);
    }

    private void acquireWrittenDataSizeWithCompactionWriteRateLimiter(long writtenDataSize) {
        while (writtenDataSize > 0L) {
            if (writtenDataSize > Integer.MAX_VALUE) {
                CompactionTaskManager.getInstance().getMergeWriteRateLimiter().acquire(Integer.MAX_VALUE);
                writtenDataSize -= Integer.MAX_VALUE;
                continue;
            }
            CompactionTaskManager.getInstance().getMergeWriteRateLimiter().acquire((int)writtenDataSize);
            return;
        }
    }
}

