/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class PathsUsingTemplateSource
implements ISchemaSource<IDeviceSchemaInfo> {
    private final List<PartialPath> pathPatternList;
    private final int templateId;

    PathsUsingTemplateSource(List<PartialPath> pathPatternList, int templateId) {
        this.pathPatternList = pathPatternList;
        this.templateId = templateId;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        return new DevicesUsingTemplateReader(this.pathPatternList.iterator(), schemaRegion);
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return ColumnHeaderConstant.showPathsUsingTemplateHeaders;
    }

    @Override
    public void transformToTsBlockColumns(IDeviceSchemaInfo device, TsBlockBuilder builder, String database) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(device.getFullPath()));
        builder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return false;
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return schemaRegion.getSchemaRegionStatistics().getTemplateActivatedNumber();
    }

    private class DevicesUsingTemplateReader
    implements ISchemaReader<IDeviceSchemaInfo> {
        final Iterator<PartialPath> pathPatternIterator;
        final ISchemaRegion schemaRegion;
        private Throwable throwable;
        ISchemaReader<IDeviceSchemaInfo> currentDeviceReader;

        DevicesUsingTemplateReader(Iterator<PartialPath> pathPatternIterator, ISchemaRegion schemaRegion) {
            this.pathPatternIterator = pathPatternIterator;
            this.schemaRegion = schemaRegion;
            this.throwable = null;
        }

        @Override
        public void close() throws Exception {
            if (this.currentDeviceReader != null) {
                this.currentDeviceReader.close();
            }
        }

        @Override
        public ListenableFuture<?> isBlocked() {
            return NOT_BLOCKED;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.throwable != null) {
                    return false;
                }
                if (this.currentDeviceReader != null) {
                    if (this.currentDeviceReader.hasNext()) {
                        return true;
                    }
                    this.currentDeviceReader.close();
                    if (!this.currentDeviceReader.isSuccess()) {
                        this.throwable = this.currentDeviceReader.getFailure();
                        return false;
                    }
                }
                while (this.pathPatternIterator.hasNext()) {
                    this.currentDeviceReader = this.schemaRegion.getDeviceReader(SchemaRegionReadPlanFactory.getShowDevicesPlan(this.pathPatternIterator.next(), 0, 0, false, PathsUsingTemplateSource.this.templateId));
                    if (this.currentDeviceReader.hasNext()) {
                        return true;
                    }
                    this.currentDeviceReader.close();
                }
                return false;
            }
            catch (Exception e) {
                throw new SchemaExecutionException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public IDeviceSchemaInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentDeviceReader.next();
        }

        @Override
        public boolean isSuccess() {
            return this.throwable == null && (this.currentDeviceReader == null || this.currentDeviceReader.isSuccess());
        }

        @Override
        public Throwable getFailure() {
            if (this.throwable != null) {
                return this.throwable;
            }
            if (this.currentDeviceReader != null) {
                return this.currentDeviceReader.getFailure();
            }
            return null;
        }
    }
}

