/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.stage;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.extractor.IoTDBDataRegionExtractor;
import org.apache.iotdb.db.pipe.task.connection.EventSupplier;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskStage;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeTaskExtractorStage
extends PipeTaskStage {
    private final PipeExtractor pipeExtractor;

    public PipeTaskExtractorStage(String pipeName, long creationTime, PipeParameters extractorParameters, TConsensusGroupId dataRegionId, PipeTaskMeta pipeTaskMeta) {
        this.pipeExtractor = extractorParameters.getStringOrDefault("extractor", BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()).equals(BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()) ? new IoTDBDataRegionExtractor() : PipeAgent.plugin().reflectExtractor(extractorParameters);
        try {
            this.pipeExtractor.validate(new PipeParameterValidator(extractorParameters));
            PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration(new PipeTaskExtractorRuntimeEnvironment(pipeName, creationTime, dataRegionId.getId(), pipeTaskMeta));
            this.pipeExtractor.customize(extractorParameters, (PipeExtractorRuntimeConfiguration)runtimeConfiguration);
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void createSubtask() throws PipeException {
    }

    @Override
    public void startSubtask() throws PipeException {
        try {
            this.pipeExtractor.start();
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stopSubtask() throws PipeException {
    }

    @Override
    public void dropSubtask() throws PipeException {
        try {
            this.pipeExtractor.close();
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }

    public EventSupplier getEventSupplier() {
        return () -> ((PipeExtractor)this.pipeExtractor).supply();
    }
}

