/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;

public class PipeEventCollector
implements EventCollector,
AutoCloseable {
    private final BoundedBlockingPendingQueue<Event> pendingQueue;
    private final Deque<Event> bufferQueue;

    public PipeEventCollector(BoundedBlockingPendingQueue<Event> pendingQueue) {
        this.pendingQueue = pendingQueue;
        this.bufferQueue = new LinkedList<Event>();
    }

    public synchronized void collect(Event event) {
        if (event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName());
        }
        if (event instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event).recordBufferQueueSize(this.bufferQueue);
            ((PipeHeartbeatEvent)event).recordConnectorQueueSize(this.pendingQueue);
        }
        while (!this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.waitedOffer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            if (event instanceof PipeHeartbeatEvent && this.bufferQueue.peekLast() instanceof PipeHeartbeatEvent) {
                ((EnrichedEvent)event).decreaseReferenceCount(PipeEventCollector.class.getName(), false);
            } else {
                this.bufferQueue.offer(event);
            }
            return;
        }
        if (!this.pendingQueue.waitedOffer(event)) {
            this.bufferQueue.offer(event);
        }
    }

    public synchronized boolean tryCollectBufferedEvents() {
        while (!this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.waitedOffer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        this.bufferQueue.forEach(event -> {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeEventCollector.class.getName());
            }
        });
        this.bufferQueue.clear();
    }
}

