/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.airgap;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.connector.payload.airgap.AirGapOneByteResponse;
import org.apache.iotdb.db.pipe.connector.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.db.pipe.receiver.thrift.IoTDBThriftReceiverAgent;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBAirGapReceiver
extends WrappedRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBAirGapReceiver.class);
    private final Socket socket;
    private final long receiverId;
    private final IoTDBThriftReceiverAgent agent;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;

    public IoTDBAirGapReceiver(Socket socket, long receiverId) {
        this.socket = socket;
        this.receiverId = receiverId;
        this.agent = PipeAgent.receiver().thrift();
        this.partitionFetcher = ClusterPartitionFetcher.getInstance();
        this.schemaFetcher = ClusterSchemaFetcher.getInstance();
    }

    public void runMayThrow() throws Throwable {
        this.socket.setSoTimeout((int)PipeConfig.getInstance().getPipeConnectorTimeoutMs());
        this.socket.setKeepAlive(true);
        LOGGER.info("Pipe air gap receiver {} started. Socket: {}", (Object)this.receiverId, (Object)this.socket);
        try {
            while (!this.socket.isClosed()) {
                this.receive();
            }
            LOGGER.info("Pipe air gap receiver {} closed because socket is closed. Socket: {}", (Object)this.receiverId, (Object)this.socket);
        }
        catch (Exception e) {
            LOGGER.warn("Pipe air gap receiver {} closed because of exception. Socket: {}", new Object[]{this.receiverId, this.socket, e});
            throw e;
        }
        finally {
            PipeAgent.receiver().thrift().handleClientExit();
            this.socket.close();
        }
    }

    private void receive() throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(this.socket.getInputStream());
        try {
            byte[] data = this.readData(inputStream);
            if (!this.checkSum(data)) {
                LOGGER.warn("Checksum failed, receiverId: {}", (Object)this.receiverId);
                this.fail();
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, 8, data.length - 8);
            AirGapPseudoTPipeTransferRequest req = (AirGapPseudoTPipeTransferRequest)new AirGapPseudoTPipeTransferRequest().setVersion(ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)).setType(ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer)).setBody(byteBuffer.slice());
            TPipeTransferResp resp = this.agent.receive(req, this.partitionFetcher, this.schemaFetcher);
            if (resp.getStatus().code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.ok();
            } else {
                LOGGER.warn("Handle data failed, receiverId: {}, status: {}, req: {}", new Object[]{this.receiverId, resp.getStatus(), req});
                this.fail();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception during handling receiving, receiverId: {}", (Object)this.receiverId, (Object)e);
            this.fail();
        }
    }

    private void ok() throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(AirGapOneByteResponse.OK);
        outputStream.flush();
    }

    private void fail() throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(AirGapOneByteResponse.FAIL);
        outputStream.flush();
    }

    private boolean checkSum(byte[] bytes) {
        try {
            CRC32 crc32 = new CRC32();
            crc32.update(bytes, 8, bytes.length - 8);
            return BytesUtils.bytesToLong((byte[])BytesUtils.subBytes((byte[])bytes, (int)0, (int)8)) == crc32.getValue();
        }
        catch (Exception e) {
            return false;
        }
    }

    private byte[] readData(InputStream inputStream) throws IOException {
        int currentReadBytes;
        int length = this.readLength(inputStream);
        if (length == 0) {
            return new byte[0];
        }
        ByteBuffer resultBuffer = ByteBuffer.allocate(length);
        byte[] readBuffer = new byte[length];
        for (int alreadyReadBytes = 0; alreadyReadBytes < length; alreadyReadBytes += currentReadBytes) {
            currentReadBytes = inputStream.read(readBuffer, 0, length - alreadyReadBytes);
            resultBuffer.put(readBuffer, 0, currentReadBytes);
        }
        return resultBuffer.array();
    }

    private int readLength(InputStream inputStream) throws IOException {
        byte[] lengthBytes0 = new byte[4];
        if (inputStream.read(lengthBytes0) < 4) {
            return 0;
        }
        byte[] lengthBytes1 = new byte[4];
        if (inputStream.read(lengthBytes1) < 4) {
            return 0;
        }
        return Arrays.equals(lengthBytes0, lengthBytes1) ? BytesUtils.bytesToInt((byte[])lengthBytes0) : 0;
    }
}

