/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;

public abstract class PipeRealtimeDataRegionExtractor
implements PipeExtractor {
    protected String pattern;
    protected boolean isForwardingPipeRequests = true;
    protected String pipeName;
    protected String dataRegionId;
    protected PipeTaskMeta pipeTaskMeta;
    protected final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue();
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);

    protected PipeRealtimeDataRegionExtractor() {
    }

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        this.pattern = parameters.getStringOrDefault("extractor.pattern", "root");
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeName = environment.getPipeName();
        this.dataRegionId = String.valueOf(environment.getRegionId());
        this.pipeTaskMeta = environment.getPipeTaskMeta();
    }

    public void start() throws Exception {
        PipeInsertionDataNodeListener.getInstance().startListenAndAssign(this.dataRegionId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        PipeInsertionDataNodeListener.getInstance().stopListenAndAssign(this.dataRegionId, this);
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            this.clearPendingQueue();
            this.isClosed.set(true);
        }
    }

    private void clearPendingQueue() {
        ArrayList eventsToDrop = new ArrayList(this.pendingQueue.size());
        this.pendingQueue.forEach(eventsToDrop::add);
        this.pendingQueue.clear();
        eventsToDrop.forEach(event -> {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeRealtimeDataRegionExtractor.class.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(PipeRealtimeEvent event) {
        this.doExtract(event);
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            if (this.isClosed.get()) {
                this.clearPendingQueue();
            }
        }
    }

    protected abstract void doExtract(PipeRealtimeEvent var1);

    public abstract boolean isNeedListenToTsFile();

    public abstract boolean isNeedListenToInsertNode();

    public final String getPattern() {
        return this.pattern;
    }

    public final boolean isForwardingPipeRequests() {
        return this.isForwardingPipeRequests;
    }

    public final String getPipeName() {
        return this.pipeName;
    }

    public final PipeTaskMeta getPipeTaskMeta() {
        return this.pipeTaskMeta;
    }

    public String toString() {
        return "PipeRealtimeDataRegionExtractor{pattern='" + this.pattern + '\'' + ", dataRegionId='" + this.dataRegionId + '\'' + '}';
    }
}

