/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.TabletInsertionDataContainer;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInsertNodeTabletInsertionEvent
extends EnrichedEvent
implements TabletInsertionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInsertNodeTabletInsertionEvent.class);
    private final WALEntryHandler walEntryHandler;
    private final ProgressIndex progressIndex;
    private final boolean isAligned;
    private final boolean isGeneratedByPipe;
    private TabletInsertionDataContainer dataContainer;

    public PipeInsertNodeTabletInsertionEvent(WALEntryHandler walEntryHandler, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe) {
        this(walEntryHandler, progressIndex, isAligned, isGeneratedByPipe, null, null);
    }

    private PipeInsertNodeTabletInsertionEvent(WALEntryHandler walEntryHandler, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe, PipeTaskMeta pipeTaskMeta, String pattern) {
        super(pipeTaskMeta, pattern);
        this.walEntryHandler = walEntryHandler;
        this.progressIndex = progressIndex;
        this.isAligned = isAligned;
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    public InsertNode getInsertNode() throws WALPipeException {
        return this.walEntryHandler.getInsertNode();
    }

    public ByteBuffer getByteBuffer() throws WALPipeException {
        return this.walEntryHandler.getByteBuffer();
    }

    public InsertNode getInsertNodeViaCacheIfPossible() {
        return this.walEntryHandler.getInsertNodeViaCacheIfPossible();
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.wal().pin(this.walEntryHandler);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for memtable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.wal().unpin(this.walEntryHandler);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for memtable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return this.progressIndex == null ? MinimumProgressIndex.INSTANCE : this.progressIndex;
    }

    @Override
    public PipeInsertNodeTabletInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta pipeTaskMeta, String pattern) {
        return new PipeInsertNodeTabletInsertionEvent(this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe, pipeTaskMeta, pattern);
    }

    @Override
    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.getInsertNode(), this.getPattern());
            }
            return this.dataContainer.processRowByRow(consumer);
        }
        catch (Exception e) {
            throw new PipeException("Process row by row error.", (Throwable)e);
        }
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.getInsertNode(), this.getPattern());
            }
            return this.dataContainer.processTablet(consumer);
        }
        catch (Exception e) {
            throw new PipeException("Process tablet error.", (Throwable)e);
        }
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public Tablet convertToTablet() {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.getInsertNode(), this.getPattern());
            }
            return this.dataContainer.convertToTablet();
        }
        catch (Exception e) {
            throw new PipeException("Convert to tablet error.", (Throwable)e);
        }
    }

    public TabletInsertionEvent parseEventWithPattern() {
        return new PipeRawTabletInsertionEvent(this.convertToTablet(), this.isAligned, this.pipeTaskMeta, this, true);
    }

    public String toString() {
        return "PipeInsertNodeTabletInsertionEvent{walEntryHandler=" + this.walEntryHandler + ", progressIndex=" + this.progressIndex + ", isAligned=" + this.isAligned + '}';
    }
}

