/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.dataregion.DataRegionStateMachine;
import org.apache.iotdb.db.consensus.statemachine.dataregion.IoTConsensusDataRegionStateMachine;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

public class DataRegionConsensusImpl {
    private DataRegionConsensusImpl() {
    }

    public static IConsensus getInstance() {
        return DataRegionConsensusImplHolder.INSTANCE;
    }

    private static class DataRegionConsensusImplHolder {
        private static final IoTDBConfig CONF = IoTDBDescriptor.getInstance().getConfig();
        private static final IConsensus INSTANCE = (IConsensus)ConsensusFactory.getConsensusImpl((String)CONF.getDataRegionConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(CONF.getDataNodeId()).setThisNode(new TEndPoint(CONF.getInternalAddress(), CONF.getDataRegionConsensusPort())).setStorageDir(CONF.getDataRegionConsensusDir()).setConsensusGroupType(TConsensusGroupType.DataRegion).setIoTConsensusConfig(IoTConsensusConfig.newBuilder().setRpc(IoTConsensusConfig.RPC.newBuilder().setConnectionTimeoutInMs(CONF.getConnectionTimeoutInMS()).setRpcSelectorThreadNum(CONF.getRpcSelectorThreadCount()).setRpcMinConcurrentClientNum(CONF.getRpcMinConcurrentClientNum()).setRpcMaxConcurrentClientNum(CONF.getRpcMaxConcurrentClientNum()).setRpcThriftCompressionEnabled(CONF.isRpcThriftCompressionEnable()).setSelectorNumOfClientManager(CONF.getSelectorNumOfClientManager()).setThriftServerAwaitTimeForStopService(CONF.getThriftServerAwaitTimeForStopService()).setThriftMaxFrameSize(CONF.getThriftMaxFrameSize()).setCoreClientNumForEachNode(CONF.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(CONF.getMaxClientNumForEachNode()).build()).setReplication(IoTConsensusConfig.Replication.newBuilder().setWalThrottleThreshold(CONF.getThrottleThreshold()).setAllocateMemoryForConsensus(CONF.getAllocateMemoryForConsensus()).setMaxLogEntriesNumPerBatch(CONF.getMaxLogEntriesNumPerBatch()).setMaxSizePerBatch(CONF.getMaxSizePerBatch()).setMaxPendingBatchesNum(CONF.getMaxPendingBatchesNum()).setMaxMemoryRatioForQueue(CONF.getMaxMemoryRatioForQueue()).build()).build()).setRatisConfig(RatisConfig.newBuilder().setSnapshot(RatisConfig.Snapshot.newBuilder().setCreationGap(1L).setAutoTriggerThreshold(CONF.getDataRatisConsensusSnapshotTriggerThreshold()).build()).setLog(RatisConfig.Log.newBuilder().setUnsafeFlushEnabled(CONF.isDataRatisConsensusLogUnsafeFlushEnable()).setForceSyncNum(CONF.getDataRatisConsensusLogForceSyncNum()).setSegmentSizeMax(SizeInBytes.valueOf((long)CONF.getDataRatisConsensusLogSegmentSizeMax())).setPreserveNumsWhenPurge(CONF.getDataRatisConsensusPreserveWhenPurge()).build()).setGrpc(RatisConfig.Grpc.newBuilder().setFlowControlWindow(SizeInBytes.valueOf((long)CONF.getDataRatisConsensusGrpcFlowControlWindow())).setLeaderOutstandingAppendsMax(CONF.getDataRatisConsensusGrpcLeaderOutstandingAppendsMax()).build()).setRpc(RatisConfig.Rpc.newBuilder().setTimeoutMin(TimeDuration.valueOf((long)CONF.getDataRatisConsensusLeaderElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setTimeoutMax(TimeDuration.valueOf((long)CONF.getDataRatisConsensusLeaderElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setRequestTimeout(TimeDuration.valueOf((long)CONF.getDataRatisConsensusRequestTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMin(TimeDuration.valueOf((long)CONF.getRatisFirstElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMax(TimeDuration.valueOf((long)CONF.getRatisFirstElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).setClient(RatisConfig.Client.newBuilder().setClientRequestTimeoutMillis(CONF.getDataRatisConsensusRequestTimeoutMs()).setClientMaxRetryAttempt(CONF.getDataRatisConsensusMaxRetryAttempts()).setClientRetryInitialSleepTimeMs(CONF.getDataRatisConsensusInitialSleepTimeMs()).setClientRetryMaxSleepTimeMs(CONF.getDataRatisConsensusMaxSleepTimeMs()).setCoreClientNumForEachNode(CONF.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(CONF.getMaxClientNumForEachNode()).build()).setImpl(RatisConfig.Impl.newBuilder().setTriggerSnapshotFileSize(CONF.getDataRatisLogMax()).build()).setLeaderLogAppender(RatisConfig.LeaderLogAppender.newBuilder().setBufferByteLimit(CONF.getDataRatisConsensusLogAppenderBufferSizeMax()).build()).setRead(RatisConfig.Read.newBuilder().setReadTimeout(TimeDuration.valueOf((long)CONF.getConnectionTimeoutInMS(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).build()).build(), DataRegionConsensusImplHolder::createDataRegionStateMachine).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", CONF.getDataRegionConsensusProtocolClass())));

        private DataRegionConsensusImplHolder() {
        }

        private static DataRegionStateMachine createDataRegionStateMachine(ConsensusGroupId gid) {
            DataRegion dataRegion = StorageEngine.getInstance().getDataRegion((DataRegionId)gid);
            if ("org.apache.iotdb.consensus.iot.IoTConsensus".equals(CONF.getDataRegionConsensusProtocolClass())) {
                return new IoTConsensusDataRegionStateMachine(dataRegion);
            }
            return new DataRegionStateMachine(dataRegion);
        }
    }
}

