/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.CompositeReporter;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalMemoryReporter;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalReporter;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBSessionReporter;
import org.apache.iotdb.metrics.reporter.prometheus.PrometheusReporter;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetricService.class);
    protected static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    protected AbstractMetricManager metricManager = new DoNothingMetricManager();
    protected CompositeReporter compositeReporter = new CompositeReporter();
    protected IoTDBInternalReporter internalReporter = new IoTDBInternalMemoryReporter();
    protected Set<IMetricSet> metricSets = new HashSet<IMetricSet>();

    protected AbstractMetricService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() {
        this.startCoreModule();
        AbstractMetricService abstractMetricService = this;
        synchronized (abstractMetricService) {
            for (IMetricSet metricSet : this.metricSets) {
                metricSet.bindTo(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        AbstractMetricService abstractMetricService = this;
        synchronized (abstractMetricService) {
            for (IMetricSet metricSet : this.metricSets) {
                metricSet.unbindFrom(this);
            }
        }
        this.stopCoreModule();
    }

    protected void startCoreModule() {
        LOGGER.info("Start metric service at level: {}", (Object)METRIC_CONFIG.getMetricLevel().name());
        this.loadManager();
        this.loadReporter();
        this.startAllReporter();
    }

    protected void stopCoreModule() {
        this.stopAllReporter();
        this.metricManager.stop();
        this.metricManager = new DoNothingMetricManager();
        this.compositeReporter = new CompositeReporter();
    }

    private void loadManager() {
        LOGGER.info("Load metricManager, type: {}", (Object)METRIC_CONFIG.getMetricFrameType());
        ServiceLoader<AbstractMetricManager> metricManagers = ServiceLoader.load(AbstractMetricManager.class);
        int size = 0;
        for (AbstractMetricManager mf : metricManagers) {
            ++size;
            if (!mf.getClass().getName().toLowerCase().contains(METRIC_CONFIG.getMetricFrameType().name().toLowerCase())) continue;
            this.metricManager = mf;
            break;
        }
        if (size == 0 || this.metricManager == null) {
            this.metricManager = new DoNothingMetricManager();
        } else if (size > 1) {
            LOGGER.info("Detect more than one MetricManager, will use {}", (Object)this.metricManager.getClass().getName());
        }
    }

    protected void loadReporter() {
        LOGGER.info("Load metric reporters, type: {}", METRIC_CONFIG.getMetricReporterList());
        this.compositeReporter.clearReporter();
        if (METRIC_CONFIG.getMetricReporterList() == null) {
            return;
        }
        for (ReporterType reporterType : METRIC_CONFIG.getMetricReporterList()) {
            Reporter reporter = null;
            switch (reporterType) {
                case JMX: {
                    ServiceLoader<JmxReporter> reporters = ServiceLoader.load(JmxReporter.class);
                    for (JmxReporter jmxReporter : reporters) {
                        if (!jmxReporter.getClass().getName().toLowerCase().contains(METRIC_CONFIG.getMetricFrameType().name().toLowerCase())) continue;
                        jmxReporter.setMetricManager(this.metricManager);
                        reporter = jmxReporter;
                    }
                    break;
                }
                case PROMETHEUS: {
                    reporter = new PrometheusReporter(this.metricManager);
                    break;
                }
                case IOTDB: {
                    reporter = new IoTDBSessionReporter(this.metricManager);
                    break;
                }
            }
            if (reporter == null) {
                LOGGER.warn("Failed to load reporter which type is {}", (Object)reporterType);
                continue;
            }
            this.compositeReporter.addReporter(reporter);
        }
    }

    public abstract void reloadInternalReporter(IoTDBInternalReporter var1);

    protected abstract void reloadService(ReloadLevel var1);

    public void startAllReporter() {
        this.compositeReporter.startAll();
    }

    public void stopAllReporter() {
        this.compositeReporter.stopAll();
    }

    public void start(ReporterType type) {
        this.compositeReporter.start(type);
    }

    public void stop(ReporterType type) {
        this.compositeReporter.stop(type);
    }

    public Counter getOrCreateCounter(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateCounter(metric, metricLevel, tags);
    }

    public <T> AutoGauge createAutoGauge(String metric, MetricLevel metricLevel, T obj, ToDoubleFunction<T> mapper, String ... tags) {
        return this.metricManager.createAutoGauge(metric, metricLevel, obj, mapper, tags);
    }

    public AutoGauge getAutoGauge(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getAutoGauge(metric, metricLevel, tags);
    }

    public Gauge getOrCreateGauge(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateGauge(metric, metricLevel, tags);
    }

    public Rate getOrCreateRate(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateRate(metric, metricLevel, tags);
    }

    public Histogram getOrCreateHistogram(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateHistogram(metric, metricLevel, tags);
    }

    public Timer getOrCreateTimer(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateTimer(metric, metricLevel, tags);
    }

    public void count(long delta, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.count(delta, metric, metricLevel, tags);
    }

    public void gauge(long value, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.gauge(value, metric, metricLevel, tags);
    }

    public void rate(long value, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.rate(value, metric, metricLevel, tags);
    }

    public void histogram(long value, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.histogram(value, metric, metricLevel, tags);
    }

    public void timer(long delta, TimeUnit timeUnit, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.timer(delta, timeUnit, metric, metricLevel, tags);
    }

    public Counter getOrCreateCounterWithInternalReport(String metric, MetricLevel metricLevel, long time, String ... tags) {
        Counter counter = this.metricManager.getOrCreateCounter(metric, metricLevel, tags);
        this.internalReporter.writeMetricToIoTDB(counter, metric, time, tags);
        return counter;
    }

    public <T> AutoGauge createAutoGaugeWithInternalReport(String metric, MetricLevel metricLevel, T obj, ToDoubleFunction<T> mapper, String ... tags) {
        AutoGauge gauge = this.metricManager.createAutoGauge(metric, metricLevel, obj, mapper, tags);
        this.internalReporter.addAutoGauge(gauge, metric, tags);
        return gauge;
    }

    public Gauge getOrCreateGaugeWithInternalReport(String metric, MetricLevel metricLevel, long time, String ... tags) {
        Gauge gauge = this.metricManager.getOrCreateGauge(metric, metricLevel, tags);
        this.internalReporter.writeMetricToIoTDB(gauge, metric, time, tags);
        return gauge;
    }

    public Rate getOrCreateRateWithInternalReport(String metric, MetricLevel metricLevel, long time, String ... tags) {
        Rate rate = this.metricManager.getOrCreateRate(metric, metricLevel, tags);
        this.internalReporter.writeMetricToIoTDB(rate, metric, time, tags);
        return rate;
    }

    public Histogram getOrCreateHistogramWithInternalReport(String metric, MetricLevel metricLevel, long time, String ... tags) {
        Histogram histogram = this.metricManager.getOrCreateHistogram(metric, metricLevel, tags);
        this.internalReporter.writeMetricToIoTDB(histogram, metric, time, tags);
        return histogram;
    }

    public Timer getOrCreateTimerWithInternalReport(String metric, MetricLevel metricLevel, long time, String ... tags) {
        Timer timer = this.metricManager.getOrCreateTimer(metric, metricLevel, tags);
        this.internalReporter.writeMetricToIoTDB(timer, metric, time, tags);
        return timer;
    }

    public void countWithInternalReportAsync(long delta, String metric, MetricLevel metricLevel, long time, String ... tags) {
        this.internalReporter.writeMetricToIoTDB(this.metricManager.count(delta, metric, metricLevel, tags), metric, time, tags);
    }

    public void gaugeWithInternalReportAsync(long value, String metric, MetricLevel metricLevel, long time, String ... tags) {
        this.internalReporter.writeMetricToIoTDB(this.metricManager.gauge(value, metric, metricLevel, tags), metric, time, tags);
    }

    public void rateWithInternalReportAsync(long value, String metric, MetricLevel metricLevel, long time, String ... tags) {
        this.internalReporter.writeMetricToIoTDB(this.metricManager.rate(value, metric, metricLevel, tags), metric, time, tags);
    }

    public void histogramWithInternalReportAsync(long value, String metric, MetricLevel metricLevel, long time, String ... tags) {
        this.internalReporter.writeMetricToIoTDB(this.metricManager.histogram(value, metric, metricLevel, tags), metric, time, tags);
    }

    public void timerWithInternalReportAsync(long delta, TimeUnit timeUnit, String metric, MetricLevel metricLevel, long time, String ... tags) {
        this.internalReporter.writeMetricToIoTDB(this.metricManager.timer(delta, timeUnit, metric, metricLevel, tags), metric, time, tags);
    }

    public List<Pair<String, String[]>> getAllMetricKeys() {
        return this.metricManager.getAllMetricKeys();
    }

    public Map<MetricInfo, IMetric> getAllMetrics() {
        return this.metricManager.getAllMetrics();
    }

    public Map<MetricInfo, IMetric> getMetricsByType(MetricType metricType) {
        return this.metricManager.getMetricsByType(metricType);
    }

    public void remove(MetricType type, String metric, String ... tags) {
        this.metricManager.remove(type, metric, tags);
    }

    public AbstractMetricManager getMetricManager() {
        return this.metricManager;
    }

    public synchronized void addMetricSet(IMetricSet metricSet) {
        if (!this.metricSets.contains(metricSet)) {
            metricSet.bindTo(this);
            this.metricSets.add(metricSet);
        }
    }

    public synchronized void removeMetricSet(IMetricSet metricSet) {
        if (this.metricSets.contains(metricSet)) {
            metricSet.unbindFrom(this);
            this.metricSets.remove(metricSet);
        }
    }
}

