/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.File;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.iterator.MNodeIterator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.iterator.MemoryTraverserIterator;
import org.apache.iotdb.db.schemaengine.template.Template;

public class ConfigMTreeStore
implements IMTreeStore<IConfigMNode> {
    private IConfigMNode root;
    private final IMNodeFactory<IConfigMNode> nodeFactory;

    public ConfigMTreeStore(IMNodeFactory<IConfigMNode> nodeFactory) {
        this.root = (IConfigMNode)nodeFactory.createInternalMNode(null, "root");
        this.nodeFactory = nodeFactory;
    }

    public IConfigMNode generatePrefix(PartialPath storageGroupPath) {
        throw new UnsupportedOperationException();
    }

    public IConfigMNode getRoot() {
        return this.root;
    }

    public boolean hasChild(IConfigMNode parent, String name) {
        return parent.hasChild(name);
    }

    public IConfigMNode getChild(IConfigMNode parent, String name) {
        return (IConfigMNode)parent.getChild(name);
    }

    public IMNodeIterator<IConfigMNode> getChildrenIterator(IConfigMNode parent) {
        return new MNodeIterator(parent.getChildren().values().iterator());
    }

    public IMNodeIterator<IConfigMNode> getTraverserIterator(IConfigMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        if (parent.isDevice()) {
            MemoryTraverserIterator iterator = new MemoryTraverserIterator((IMTreeStore)this, parent.getAsDeviceMNode(), templateMap, this.nodeFactory);
            iterator.setSkipPreDeletedSchema(skipPreDeletedSchema);
            return iterator;
        }
        return this.getChildrenIterator(parent);
    }

    public IConfigMNode addChild(IConfigMNode parent, String childName, IConfigMNode child) {
        return (IConfigMNode)parent.addChild(childName, child);
    }

    public void deleteChild(IConfigMNode parent, String childName) {
        parent.deleteChild(childName);
    }

    public void updateMNode(IConfigMNode node) {
    }

    public IDeviceMNode<IConfigMNode> setToEntity(IConfigMNode node) {
        throw new UnsupportedOperationException();
    }

    public IConfigMNode setToInternal(IDeviceMNode<IConfigMNode> entityMNode) {
        throw new UnsupportedOperationException();
    }

    public void setAlias(IMeasurementMNode<IConfigMNode> measurementMNode, String alias) {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        measurementMNode.setAlias(alias);
    }

    public void pin(IConfigMNode node) {
    }

    public void unPin(IConfigMNode node) {
    }

    public void unPinPath(IConfigMNode node) {
    }

    public IMTreeStore getWithReentrantReadLock() {
        return this;
    }

    public void clear() {
        this.root = (IConfigMNode)this.nodeFactory.createInternalMNode(null, "root");
    }

    public boolean createSnapshot(File snapshotDir) {
        throw new UnsupportedOperationException();
    }
}

