/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.plugin.meta.ConfigNodePipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.pipe.plugin.GetPipePluginJarPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.CreatePipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.DropPipePluginPlan;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.consensus.response.pipe.plugin.PipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePluginInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginInfo.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String SNAPSHOT_FILE_NAME = "pipe_plugin_info.bin";
    private final ReentrantLock pipePluginInfoLock = new ReentrantLock();
    private final ConfigNodePipePluginMetaKeeper pipePluginMetaKeeper = new ConfigNodePipePluginMetaKeeper();
    private final PipePluginExecutableManager pipePluginExecutableManager = PipePluginExecutableManager.setupAndGetInstance((String)CONFIG_NODE_CONF.getPipeTemporaryLibDir(), (String)CONFIG_NODE_CONF.getPipeDir());

    public void acquirePipePluginInfoLock() {
        this.pipePluginInfoLock.lock();
    }

    public void releasePipePluginInfoLock() {
        this.pipePluginInfoLock.unlock();
    }

    public void validateBeforeCreatingPipePlugin(String pluginName, String jarName, String jarMD5) {
        if (this.pipePluginMetaKeeper.containsPipePlugin(pluginName)) {
            throw new PipeException(String.format("Failed to create PipePlugin [%s], the same name PipePlugin has been created", pluginName));
        }
        if (this.pipePluginMetaKeeper.jarNameExistsAndMatchesMd5(jarName, jarMD5)) {
            throw new PipeException(String.format("Failed to create PipePlugin [%s], the same name Jar [%s] but different MD5 [%s] has existed", pluginName, jarName, jarMD5));
        }
    }

    public void validateBeforeDroppingPipePlugin(String pluginName) {
        if (this.pipePluginMetaKeeper.containsPipePlugin(pluginName) && this.pipePluginMetaKeeper.getPipePluginMeta(pluginName).isBuiltin()) {
            throw new PipeException(String.format("Failed to drop PipePlugin [%s], the PipePlugin is a built-in PipePlugin", pluginName));
        }
    }

    public boolean isJarNeededToBeSavedWhenCreatingPipePlugin(String jarName) {
        return !this.pipePluginMetaKeeper.containsJar(jarName);
    }

    public void checkBeforeCreatePipe(TCreatePipeReq createPipeRequest) {
        PipeParameters extractorParameters = new PipeParameters(createPipeRequest.getExtractorAttributes());
        String extractorPluginName = extractorParameters.getStringOrDefault("extractor", BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName());
        if (!this.pipePluginMetaKeeper.containsPipePlugin(extractorPluginName)) {
            String exceptionMessage = String.format("Failed to create pipe, the pipe extractor plugin %s does not exist", extractorPluginName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeParameters processorParameters = new PipeParameters(createPipeRequest.getProcessorAttributes());
        String processorPluginName = processorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName());
        if (!this.pipePluginMetaKeeper.containsPipePlugin(processorPluginName)) {
            String exceptionMessage = String.format("Failed to create pipe, the pipe processor plugin %s does not exist", processorPluginName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeParameters connectorParameters = new PipeParameters(createPipeRequest.getConnectorAttributes());
        if (!connectorParameters.hasAttribute("connector")) {
            String exceptionMessage = "Failed to create pipe, the pipe connector plugin is not specified";
            LOGGER.warn("Failed to create pipe, the pipe connector plugin is not specified");
            throw new PipeException("Failed to create pipe, the pipe connector plugin is not specified");
        }
        String connectorPluginName = connectorParameters.getString("connector");
        if (!this.pipePluginMetaKeeper.containsPipePlugin(connectorPluginName)) {
            String exceptionMessage = String.format("Failed to create pipe, the pipe connector plugin %s does not exist", connectorPluginName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public TSStatus createPipePlugin(CreatePipePluginPlan createPipePluginPlan) {
        try {
            PipePluginMeta pipePluginMeta = createPipePluginPlan.getPipePluginMeta();
            this.dropPipePlugin(new DropPipePluginPlan(pipePluginMeta.getPluginName()));
            this.pipePluginMetaKeeper.addPipePluginMeta(pipePluginMeta.getPluginName(), pipePluginMeta);
            this.pipePluginMetaKeeper.addJarNameAndMd5(pipePluginMeta.getJarName(), pipePluginMeta.getJarMD5());
            if (createPipePluginPlan.getJarFile() != null) {
                this.pipePluginExecutableManager.saveToInstallDir(ByteBuffer.wrap(createPipePluginPlan.getJarFile().getValues()), pipePluginMeta.getJarName());
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to execute createPipePlugin(%s) on config nodes, because of %s", createPipePluginPlan.getPipePluginMeta().getPluginName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    public TSStatus dropPipePlugin(DropPipePluginPlan dropPipePluginPlan) {
        String pluginName = dropPipePluginPlan.getPluginName();
        if (this.pipePluginMetaKeeper.containsPipePlugin(pluginName)) {
            this.pipePluginMetaKeeper.removeJarNameAndMd5IfPossible(this.pipePluginMetaKeeper.getPipePluginMeta(pluginName).getJarName());
            this.pipePluginMetaKeeper.removePipePluginMeta(pluginName);
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public DataSet showPipePlugins() {
        return new PipePluginTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), Arrays.asList(this.pipePluginMetaKeeper.getAllPipePluginMeta()));
    }

    public JarResp getPipePluginJar(GetPipePluginJarPlan getPipePluginJarPlan) {
        try {
            ArrayList<ByteBuffer> jarList = new ArrayList<ByteBuffer>();
            for (String jarName : getPipePluginJarPlan.getJarNames()) {
                jarList.add(ExecutableManager.transferToBytebuffer((String)PipePluginExecutableManager.getInstance().getFileStringUnderInstallByName(jarName)));
            }
            return new JarResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), jarList);
        }
        catch (Exception e) {
            LOGGER.error("Get PipePlugin_Jar failed", (Throwable)e);
            return new JarResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage("Get PipePlugin_Jar failed, because " + e.getMessage()), Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.acquirePipePluginInfoLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (snapshotFile.exists() && snapshotFile.isFile()) {
                LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.pipePluginMetaKeeper.processTakeSnapshot((OutputStream)fileOutputStream);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releasePipePluginInfoLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.acquirePipePluginInfoLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (!snapshotFile.exists() || !snapshotFile.isFile()) {
                LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
                this.pipePluginMetaKeeper.processLoadSnapshot((InputStream)fileInputStream);
            }
        }
        finally {
            this.releasePipePluginInfoLock();
        }
    }

    public int hashCode() {
        return Objects.hash(this.pipePluginMetaKeeper, this.pipePluginExecutableManager);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PipePluginInfo other = (PipePluginInfo)obj;
        return Objects.equals(this.pipePluginExecutableManager, other.pipePluginExecutableManager) && Objects.equals(this.pipePluginMetaKeeper, other.pipePluginMetaKeeper);
    }

    public String toString() {
        return "PipePluginInfo [pipePluginMetaKeeper=" + this.pipePluginMetaKeeper + ", pipePluginExecutableManager=" + this.pipePluginExecutableManager + "]";
    }
}

