/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.RegionRoleType;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.UpdateVersionInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.response.datanode.ConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeToStatusResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.TriggerManager;
import org.apache.iotdb.confignode.manager.UDFManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.cache.node.ConfigNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.node.ClusterNodeStartUtils;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.partition.PartitionMetrics;
import org.apache.iotdb.confignode.manager.pipe.PipeManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.procedure.env.DataNodeRemoveHandler;
import org.apache.iotdb.confignode.rpc.thrift.TCQConfig;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TRatisConfig;
import org.apache.iotdb.confignode.rpc.thrift.TRuntimeConfiguration;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    public static final long HEARTBEAT_INTERVAL = CONF.getHeartbeatIntervalInMs();
    private final IManager configManager;
    private final NodeInfo nodeInfo;
    private final ReentrantLock removeConfigNodeLock;
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";

    public NodeManager(IManager configManager, NodeInfo nodeInfo) {
        this.configManager = configManager;
        this.nodeInfo = nodeInfo;
        this.removeConfigNodeLock = new ReentrantLock();
    }

    public DataSet getSystemConfiguration() {
        ConfigurationResp dataSet = new ConfigurationResp();
        dataSet.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        this.setGlobalConfig(dataSet);
        this.setRatisConfig(dataSet);
        this.setCQConfig(dataSet);
        return dataSet;
    }

    private void setGlobalConfig(ConfigurationResp dataSet) {
        ConfigNodeConfig configNodeConfig = ConfigNodeDescriptor.getInstance().getConf();
        CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
        TGlobalConfig globalConfig = new TGlobalConfig();
        globalConfig.setDataRegionConsensusProtocolClass(configNodeConfig.getDataRegionConsensusProtocolClass());
        globalConfig.setSchemaRegionConsensusProtocolClass(configNodeConfig.getSchemaRegionConsensusProtocolClass());
        globalConfig.setSeriesPartitionSlotNum(configNodeConfig.getSeriesSlotNum());
        globalConfig.setSeriesPartitionExecutorClass(configNodeConfig.getSeriesPartitionExecutorClass());
        globalConfig.setTimePartitionInterval(commonConfig.getTimePartitionInterval());
        globalConfig.setReadConsistencyLevel(configNodeConfig.getReadConsistencyLevel());
        globalConfig.setDiskSpaceWarningThreshold(commonConfig.getDiskSpaceWarningThreshold());
        globalConfig.setTimestampPrecision(commonConfig.getTimestampPrecision());
        globalConfig.setSchemaEngineMode(commonConfig.getSchemaEngineMode());
        globalConfig.setTagAttributeTotalSize(commonConfig.getTagAttributeTotalSize());
        dataSet.setGlobalConfig(globalConfig);
    }

    private void setRatisConfig(ConfigurationResp dataSet) {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        TRatisConfig ratisConfig = new TRatisConfig();
        ratisConfig.setDataAppenderBufferSize(conf.getDataRegionRatisConsensusLogAppenderBufferSize());
        ratisConfig.setSchemaAppenderBufferSize(conf.getSchemaRegionRatisConsensusLogAppenderBufferSize());
        ratisConfig.setDataSnapshotTriggerThreshold(conf.getDataRegionRatisSnapshotTriggerThreshold());
        ratisConfig.setSchemaSnapshotTriggerThreshold(conf.getSchemaRegionRatisSnapshotTriggerThreshold());
        ratisConfig.setDataLogUnsafeFlushEnable(conf.isDataRegionRatisLogUnsafeFlushEnable());
        ratisConfig.setSchemaLogUnsafeFlushEnable(conf.isSchemaRegionRatisLogUnsafeFlushEnable());
        ratisConfig.setDataLogSegmentSizeMax(conf.getDataRegionRatisLogSegmentSizeMax());
        ratisConfig.setSchemaLogSegmentSizeMax(conf.getSchemaRegionRatisLogSegmentSizeMax());
        ratisConfig.setDataGrpcFlowControlWindow(conf.getDataRegionRatisGrpcFlowControlWindow());
        ratisConfig.setSchemaGrpcFlowControlWindow(conf.getSchemaRegionRatisGrpcFlowControlWindow());
        ratisConfig.setDataRegionGrpcLeaderOutstandingAppendsMax(conf.getDataRegionRatisGrpcLeaderOutstandingAppendsMax());
        ratisConfig.setSchemaRegionGrpcLeaderOutstandingAppendsMax(conf.getSchemaRegionRatisGrpcLeaderOutstandingAppendsMax());
        ratisConfig.setDataRegionLogForceSyncNum(conf.getDataRegionRatisLogForceSyncNum());
        ratisConfig.setSchemaRegionLogForceSyncNum(conf.getSchemaRegionRatisLogForceSyncNum());
        ratisConfig.setDataLeaderElectionTimeoutMin(conf.getDataRegionRatisRpcLeaderElectionTimeoutMinMs());
        ratisConfig.setSchemaLeaderElectionTimeoutMin(conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs());
        ratisConfig.setDataLeaderElectionTimeoutMax(conf.getDataRegionRatisRpcLeaderElectionTimeoutMaxMs());
        ratisConfig.setSchemaLeaderElectionTimeoutMax(conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs());
        ratisConfig.setDataRequestTimeout(conf.getDataRegionRatisRequestTimeoutMs());
        ratisConfig.setSchemaRequestTimeout(conf.getSchemaRegionRatisRequestTimeoutMs());
        ratisConfig.setDataMaxRetryAttempts(conf.getDataRegionRatisMaxRetryAttempts());
        ratisConfig.setDataInitialSleepTime(conf.getDataRegionRatisInitialSleepTimeMs());
        ratisConfig.setDataMaxSleepTime(conf.getDataRegionRatisMaxSleepTimeMs());
        ratisConfig.setSchemaMaxRetryAttempts(conf.getSchemaRegionRatisMaxRetryAttempts());
        ratisConfig.setSchemaInitialSleepTime(conf.getSchemaRegionRatisInitialSleepTimeMs());
        ratisConfig.setSchemaMaxSleepTime(conf.getSchemaRegionRatisMaxSleepTimeMs());
        ratisConfig.setSchemaPreserveWhenPurge(conf.getSchemaRegionRatisPreserveLogsWhenPurge());
        ratisConfig.setDataPreserveWhenPurge(conf.getDataRegionRatisPreserveLogsWhenPurge());
        ratisConfig.setFirstElectionTimeoutMin(conf.getRatisFirstElectionTimeoutMinMs());
        ratisConfig.setFirstElectionTimeoutMax(conf.getRatisFirstElectionTimeoutMaxMs());
        ratisConfig.setSchemaRegionRatisLogMax(conf.getSchemaRegionRatisLogMax());
        ratisConfig.setDataRegionRatisLogMax(conf.getDataRegionRatisLogMax());
        dataSet.setRatisConfig(ratisConfig);
    }

    private void setCQConfig(ConfigurationResp dataSet) {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        TCQConfig cqConfig = new TCQConfig();
        cqConfig.setCqMinEveryIntervalInMs(conf.getCqMinEveryIntervalInMs());
        dataSet.setCqConfig(cqConfig);
    }

    private TRuntimeConfiguration getRuntimeConfiguration() {
        this.getPipeManager().getPipePluginCoordinator().lock();
        this.getTriggerManager().getTriggerInfo().acquireTriggerTableLock();
        this.getUDFManager().getUdfInfo().acquireUDFTableLock();
        try {
            TRuntimeConfiguration runtimeConfiguration = new TRuntimeConfiguration();
            runtimeConfiguration.setTemplateInfo(this.getClusterSchemaManager().getAllTemplateSetInfo());
            runtimeConfiguration.setAllTriggerInformation(this.getTriggerManager().getTriggerTable(false).getAllTriggerInformation());
            runtimeConfiguration.setAllUDFInformation(this.getUDFManager().getUDFTable().getAllUDFInformation());
            runtimeConfiguration.setAllPipeInformation(this.getPipeManager().getPipePluginCoordinator().getPipePluginTable().getAllPipePluginMeta());
            runtimeConfiguration.setAllTTLInformation(DataNodeRegisterResp.convertAllTTLInformation(this.getClusterSchemaManager().getAllTTLInfo()));
            TRuntimeConfiguration tRuntimeConfiguration = runtimeConfiguration;
            return tRuntimeConfiguration;
        }
        finally {
            this.getTriggerManager().getTriggerInfo().releaseTriggerTableLock();
            this.getUDFManager().getUdfInfo().releaseUDFTableLock();
            this.getPipeManager().getPipePluginCoordinator().unlock();
        }
    }

    public DataSet registerDataNode(TDataNodeRegisterReq req) {
        int dataNodeId = this.nodeInfo.generateNextNodeId();
        RegisterDataNodePlan registerDataNodePlan = new RegisterDataNodePlan(req.getDataNodeConfiguration());
        registerDataNodePlan.getDataNodeConfiguration().getLocation().setDataNodeId(dataNodeId);
        try {
            this.getConsensusManager().write(registerDataNodePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
        }
        UpdateVersionInfoPlan updateVersionInfoPlan = new UpdateVersionInfoPlan(req.getVersionInfo(), dataNodeId);
        try {
            this.getConsensusManager().write(updateVersionInfoPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
        }
        PartitionMetrics.bindDataNodePartitionMetrics((AbstractMetricService)MetricService.getInstance(), this.configManager, dataNodeId);
        this.getClusterSchemaManager().adjustMaxRegionGroupNum();
        DataNodeRegisterResp resp = new DataNodeRegisterResp();
        resp.setStatus(ClusterNodeStartUtils.ACCEPT_NODE_REGISTRATION);
        resp.setConfigNodeList(this.getRegisteredConfigNodes());
        resp.setDataNodeId(registerDataNodePlan.getDataNodeConfiguration().getLocation().getDataNodeId());
        resp.setRuntimeConfiguration(this.getRuntimeConfiguration());
        return resp;
    }

    public TDataNodeRestartResp updateDataNodeIfNecessary(TDataNodeRestartReq req) {
        int nodeId = req.getDataNodeConfiguration().getLocation().getDataNodeId();
        TDataNodeConfiguration dataNodeConfiguration = this.getRegisteredDataNode(nodeId);
        if (!req.getDataNodeConfiguration().equals(dataNodeConfiguration)) {
            UpdateDataNodePlan updateDataNodePlan = new UpdateDataNodePlan(req.getDataNodeConfiguration());
            try {
                this.getConsensusManager().write(updateDataNodePlan);
            }
            catch (ConsensusException e) {
                LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            }
        }
        TNodeVersionInfo versionInfo = this.nodeInfo.getVersionInfo(nodeId);
        if (!req.getVersionInfo().equals(versionInfo)) {
            UpdateVersionInfoPlan updateVersionInfoPlan = new UpdateVersionInfoPlan(req.getVersionInfo(), nodeId);
            try {
                this.getConsensusManager().write(updateVersionInfoPlan);
            }
            catch (ConsensusException e) {
                LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            }
        }
        TDataNodeRestartResp resp = new TDataNodeRestartResp();
        resp.setStatus(ClusterNodeStartUtils.ACCEPT_NODE_RESTART);
        resp.setConfigNodeList(this.getRegisteredConfigNodes());
        resp.setRuntimeConfiguration(this.getRuntimeConfiguration());
        return resp;
    }

    public DataSet removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status;
        LOGGER.info("NodeManager start to remove DataNode {}", (Object)removeDataNodePlan);
        DataNodeRemoveHandler dataNodeRemoveHandler = new DataNodeRemoveHandler((ConfigManager)this.configManager);
        DataNodeToStatusResp preCheckStatus = dataNodeRemoveHandler.checkRemoveDataNodeRequest(removeDataNodePlan);
        if (preCheckStatus.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.error("The remove DataNode request check failed. req: {}, check result: {}", (Object)removeDataNodePlan, (Object)preCheckStatus.getStatus());
            return preCheckStatus;
        }
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        if (this.configManager.transfer(removeDataNodePlan.getDataNodeLocations()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            dataSet.setStatus(new TSStatus(TSStatusCode.REMOVE_DATANODE_ERROR.getStatusCode()).setMessage("Fail to do transfer of the DataNodes"));
            return dataSet;
        }
        boolean removeSucceed = this.configManager.getProcedureManager().removeDataNode(removeDataNodePlan);
        if (removeSucceed) {
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setMessage("Server accepted the request");
        } else {
            status = new TSStatus(TSStatusCode.REMOVE_DATANODE_ERROR.getStatusCode());
            status.setMessage("Server rejected the request, maybe requests are too many");
        }
        dataSet.setStatus(status);
        LOGGER.info("NodeManager submit RemoveDataNodePlan finished, removeDataNodePlan: {}", (Object)removeDataNodePlan);
        return dataSet;
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        int nodeId = this.nodeInfo.generateNextNodeId();
        req.getConfigNodeLocation().setConfigNodeId(nodeId);
        this.configManager.getProcedureManager().addConfigNode(req);
        return new TConfigNodeRegisterResp().setStatus(ClusterNodeStartUtils.ACCEPT_NODE_REGISTRATION).setConfigNodeId(nodeId);
    }

    public TSStatus updateConfigNodeIfNecessary(int configNodeId, TNodeVersionInfo versionInfo) {
        TNodeVersionInfo recordVersionInfo = this.nodeInfo.getVersionInfo(configNodeId);
        if (!recordVersionInfo.equals(versionInfo)) {
            UpdateVersionInfoPlan updateConfigNodePlan = new UpdateVersionInfoPlan(versionInfo, configNodeId);
            try {
                return this.getConsensusManager().write(updateConfigNodePlan);
            }
            catch (ConsensusException e) {
                return new TSStatus(TSStatusCode.CONSENSUS_NOT_INITIALIZED.getStatusCode());
            }
        }
        return ClusterNodeStartUtils.ACCEPT_NODE_RESTART;
    }

    public DataNodeConfigurationResp getDataNodeConfiguration(GetDataNodeConfigurationPlan req) {
        try {
            return (DataNodeConfigurationResp)this.getConsensusManager().read(req);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            DataNodeConfigurationResp response = new DataNodeConfigurationResp();
            response.setStatus(res);
            return response;
        }
    }

    public int getRegisteredDataNodeCount() {
        return this.nodeInfo.getRegisteredDataNodeCount();
    }

    public List<TDataNodeConfiguration> getRegisteredDataNodes() {
        return this.nodeInfo.getRegisteredDataNodes();
    }

    public TDataNodeConfiguration getRegisteredDataNode(int dataNodeId) {
        return this.nodeInfo.getRegisteredDataNode(dataNodeId);
    }

    public Map<Integer, TDataNodeLocation> getRegisteredDataNodeLocations() {
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocations = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        this.nodeInfo.getRegisteredDataNodes().forEach(dataNodeConfiguration -> dataNodeLocations.put(dataNodeConfiguration.getLocation().getDataNodeId(), dataNodeConfiguration.getLocation()));
        return dataNodeLocations;
    }

    public List<TDataNodeInfo> getRegisteredDataNodeInfoList() {
        ArrayList<TDataNodeInfo> dataNodeInfoList = new ArrayList<TDataNodeInfo>();
        List<TDataNodeConfiguration> registeredDataNodes = this.getRegisteredDataNodes();
        if (registeredDataNodes != null) {
            registeredDataNodes.forEach(registeredDataNode -> {
                TDataNodeInfo dataNodeInfo = new TDataNodeInfo();
                int dataNodeId = registeredDataNode.getLocation().getDataNodeId();
                dataNodeInfo.setDataNodeId(dataNodeId);
                dataNodeInfo.setStatus(this.getLoadManager().getNodeStatusWithReason(dataNodeId));
                dataNodeInfo.setRpcAddresss(registeredDataNode.getLocation().getClientRpcEndPoint().getIp());
                dataNodeInfo.setRpcPort(registeredDataNode.getLocation().getClientRpcEndPoint().getPort());
                dataNodeInfo.setDataRegionNum(0);
                dataNodeInfo.setSchemaRegionNum(0);
                dataNodeInfo.setCpuCoreNum(registeredDataNode.getResource().getCpuCoreNum());
                dataNodeInfoList.add(dataNodeInfo);
            });
        }
        HashMap dataRegionNumMap = new HashMap();
        HashMap schemaRegionNumMap = new HashMap();
        List<TRegionReplicaSet> regionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        regionReplicaSets.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> {
            switch (regionReplicaSet.getRegionId().getType()) {
                case SchemaRegion: {
                    schemaRegionNumMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), key -> new AtomicInteger()).getAndIncrement();
                    break;
                }
                default: {
                    dataRegionNumMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), key -> new AtomicInteger()).getAndIncrement();
                }
            }
        }));
        AtomicInteger zero = new AtomicInteger(0);
        dataNodeInfoList.forEach(dataNodesInfo -> {
            dataNodesInfo.setSchemaRegionNum(schemaRegionNumMap.getOrDefault(dataNodesInfo.getDataNodeId(), zero).get());
            dataNodesInfo.setDataRegionNum(dataRegionNumMap.getOrDefault(dataNodesInfo.getDataNodeId(), zero).get());
        });
        dataNodeInfoList.sort(Comparator.comparingInt(TDataNodeInfo::getDataNodeId));
        return dataNodeInfoList;
    }

    public List<TConfigNodeLocation> getRegisteredConfigNodes() {
        return this.nodeInfo.getRegisteredConfigNodes();
    }

    public Map<Integer, TNodeVersionInfo> getNodeVersionInfo() {
        return this.nodeInfo.getNodeVersionInfo();
    }

    public List<TConfigNodeInfo> getRegisteredConfigNodeInfoList() {
        ArrayList<TConfigNodeInfo> configNodeInfoList = new ArrayList<TConfigNodeInfo>();
        List<TConfigNodeLocation> registeredConfigNodes = this.getRegisteredConfigNodes();
        if (registeredConfigNodes != null) {
            registeredConfigNodes.forEach(configNodeLocation -> {
                TConfigNodeInfo info = new TConfigNodeInfo();
                int configNodeId = configNodeLocation.getConfigNodeId();
                info.setConfigNodeId(configNodeId);
                info.setStatus(this.getLoadManager().getNodeStatusWithReason(configNodeId));
                info.setInternalAddress(configNodeLocation.getInternalEndPoint().getIp());
                info.setInternalPort(configNodeLocation.getInternalEndPoint().getPort());
                info.setRoleType(configNodeLocation.getConfigNodeId() == ConfigNodeHeartbeatCache.CURRENT_NODE_ID ? RegionRoleType.Leader.name() : RegionRoleType.Follower.name());
                configNodeInfoList.add(info);
            });
        }
        configNodeInfoList.sort(Comparator.comparingInt(TConfigNodeInfo::getConfigNodeId));
        return configNodeInfoList;
    }

    public void applyConfigNode(TConfigNodeLocation configNodeLocation, TNodeVersionInfo versionInfo) {
        ApplyConfigNodePlan applyConfigNodePlan = new ApplyConfigNodePlan(configNodeLocation);
        try {
            this.getConsensusManager().write(applyConfigNodePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
        }
        UpdateVersionInfoPlan updateVersionInfoPlan = new UpdateVersionInfoPlan(versionInfo, configNodeLocation.getConfigNodeId());
        try {
            this.getConsensusManager().write(updateVersionInfoPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus checkConfigNodeBeforeRemove(RemoveConfigNodePlan removeConfigNodePlan) {
        this.removeConfigNodeLock.lock();
        try {
            if (this.filterConfigNodeThroughStatus(NodeStatus.Running).size() <= 1) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because there is only one ConfigNode in current Cluster.");
                return tSStatus;
            }
            if (!this.getRegisteredConfigNodes().contains(removeConfigNodePlan.getConfigNodeLocation())) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because the ConfigNode not in current Cluster.");
                return tSStatus;
            }
            TConfigNodeLocation leader = this.getConsensusManager().getLeader();
            if (leader == null) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because the ConfigNodeGroup is on leader election, please retry.");
                return tSStatus;
            }
            if (leader.getInternalEndPoint().equals(removeConfigNodePlan.getConfigNodeLocation().getInternalEndPoint())) {
                TSStatus tSStatus = this.transferLeader(removeConfigNodePlan, this.getConsensusManager().getConsensusGroupId());
                return tSStatus;
            }
        }
        finally {
            this.removeConfigNodeLock.unlock();
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Successfully remove confignode.");
    }

    private TSStatus transferLeader(RemoveConfigNodePlan removeConfigNodePlan, ConsensusGroupId groupId) {
        Optional<TConfigNodeLocation> optional = this.filterConfigNodeThroughStatus(NodeStatus.Running).stream().filter(e -> !e.equals(removeConfigNodePlan.getConfigNodeLocation())).findAny();
        TConfigNodeLocation newLeader = null;
        if (!optional.isPresent()) {
            return new TSStatus(TSStatusCode.TRANSFER_LEADER_ERROR.getStatusCode()).setMessage("Transfer ConfigNode leader failed because can not find any running ConfigNode.");
        }
        newLeader = optional.get();
        try {
            this.getConsensusManager().getConsensusImpl().transferLeader(groupId, new Peer(groupId, newLeader.getConfigNodeId(), newLeader.getConsensusEndPoint()));
        }
        catch (ConsensusException e2) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because transfer ConfigNode leader failed.");
        }
        return new TSStatus(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()).setRedirectNode(newLeader.getInternalEndPoint()).setMessage("The ConfigNode to be removed is leader, already transfer Leader to " + newLeader + ".");
    }

    public List<TSStatus> merge() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.MERGE, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> flush(TFlushReq req) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.FLUSH, req, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> clearCache() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.CLEAR_CACHE, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> loadConfiguration() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.LOAD_CONFIGURATION, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> setSystemStatus(String status) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.SET_SYSTEM_STATUS, status, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq setDataNodeStatusReq) {
        return SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(setDataNodeStatusReq.getTargetDataNode().getInternalEndPoint(), setDataNodeStatusReq.getStatus(), DataNodeRequestType.SET_SYSTEM_STATUS);
    }

    public TSStatus killQuery(String queryId, int dataNodeId) {
        if (dataNodeId < 0) {
            return this.killAllQueries();
        }
        return this.killSpecificQuery(queryId, this.getRegisteredDataNodeLocations().get(dataNodeId));
    }

    private TSStatus killAllQueries() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.KILL_QUERY_INSTANCE, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return RpcUtils.squashResponseStatusList(clientHandler.getResponseList());
    }

    private TSStatus killSpecificQuery(String queryId, TDataNodeLocation dataNodeLocation) {
        if (dataNodeLocation == null) {
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).setMessage("The target DataNode is not existed, please ensure your input <queryId> is correct");
        }
        return SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeLocation.getInternalEndPoint(), queryId, DataNodeRequestType.KILL_QUERY_INSTANCE);
    }

    public List<TConfigNodeLocation> filterConfigNodeThroughStatus(NodeStatus ... status) {
        return this.nodeInfo.getRegisteredConfigNodes(this.getLoadManager().filterConfigNodeThroughStatus(status));
    }

    public List<TDataNodeConfiguration> filterDataNodeThroughStatus(NodeStatus ... status) {
        return this.nodeInfo.getRegisteredDataNodes(this.getLoadManager().filterDataNodeThroughStatus(status));
    }

    public Optional<TDataNodeLocation> getLowestLoadDataNode() {
        int dataNodeId = this.getLoadManager().getLowestLoadDataNode();
        return dataNodeId < 0 ? Optional.empty() : Optional.of(this.getRegisteredDataNode(dataNodeId).getLocation());
    }

    public TDataNodeLocation getLowestLoadDataNode(Set<Integer> nodes) {
        int dataNodeId = this.getLoadManager().getLowestLoadDataNode(new ArrayList<Integer>(nodes));
        return this.getRegisteredDataNode(dataNodeId).getLocation();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    private TriggerManager getTriggerManager() {
        return this.configManager.getTriggerManager();
    }

    private PipeManager getPipeManager() {
        return this.configManager.getPipeManager();
    }

    private UDFManager getUDFManager() {
        return this.configManager.getUDFManager();
    }
}

