/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionManager.class);
    private final ConfigManager configManager;
    private final AuthorInfo authorInfo;

    public PermissionManager(ConfigManager configManager, AuthorInfo authorInfo) {
        this.configManager = configManager;
        this.authorInfo = authorInfo;
    }

    public TSStatus operatePermission(AuthorPlan authorPlan) {
        try {
            TSStatus tsStatus;
            if (authorPlan.getAuthorType() == ConfigPhysicalPlanType.CreateUser || authorPlan.getAuthorType() == ConfigPhysicalPlanType.CreateRole) {
                tsStatus = this.getConsensusManager().write(authorPlan);
            } else {
                tsStatus = this.invalidateCache(authorPlan.getUserName(), authorPlan.getRoleName());
                if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    tsStatus = this.getConsensusManager().write(authorPlan);
                }
            }
            return tsStatus;
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    public PermissionInfoResp queryPermission(AuthorPlan authorPlan) {
        try {
            return (PermissionInfoResp)this.getConsensusManager().read(authorPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new PermissionInfoResp(res, Collections.emptyMap());
        }
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TPermissionInfoResp login(String username, String password) {
        return this.authorInfo.login(username, password);
    }

    public TPermissionInfoResp checkUserPrivileges(String username, List<PartialPath> paths, int permission) {
        return this.authorInfo.checkUserPrivileges(username, paths, permission);
    }

    public TSStatus invalidateCache(String username, String roleName) {
        List<TDataNodeConfiguration> allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes();
        TInvalidatePermissionCacheReq req = new TInvalidatePermissionCacheReq();
        req.setUsername(username);
        req.setRoleName(roleName);
        for (TDataNodeConfiguration dataNodeInfo : allDataNodes) {
            TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeInfo.getLocation().getInternalEndPoint(), req, DataNodeRequestType.INVALIDATE_PERMISSION_CACHE);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return status;
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }
}

