/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeHandleLeaderChangePlan
extends ConfigPhysicalPlan {
    private Map<TConsensusGroupId, Integer> consensusGroupId2NewDataRegionLeaderIdMap = new HashMap<TConsensusGroupId, Integer>();

    public PipeHandleLeaderChangePlan() {
        super(ConfigPhysicalPlanType.PipeHandleLeaderChange);
    }

    public PipeHandleLeaderChangePlan(Map<TConsensusGroupId, Integer> consensusGroupId2NewDataRegionLeaderIdMap) {
        super(ConfigPhysicalPlanType.PipeHandleLeaderChange);
        this.consensusGroupId2NewDataRegionLeaderIdMap = consensusGroupId2NewDataRegionLeaderIdMap;
    }

    public Map<TConsensusGroupId, Integer> getConsensusGroupId2NewDataRegionLeaderIdMap() {
        return this.consensusGroupId2NewDataRegionLeaderIdMap;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.consensusGroupId2NewDataRegionLeaderIdMap.size());
        for (Map.Entry<TConsensusGroupId, Integer> entry : this.consensusGroupId2NewDataRegionLeaderIdMap.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey().getId(), (OutputStream)stream);
            ReadWriteIOUtils.write((int)entry.getValue(), (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            this.consensusGroupId2NewDataRegionLeaderIdMap.put(new TConsensusGroupId(TConsensusGroupType.DataRegion, ReadWriteIOUtils.readInt((ByteBuffer)buffer)), ReadWriteIOUtils.readInt((ByteBuffer)buffer));
        }
    }
}

