/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TrainingState;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TUpdateModelStateReq;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class UpdateModelStatePlan
extends ConfigPhysicalPlan {
    private String modelId;
    private TrainingState state;
    private String bestTrailId;

    public UpdateModelStatePlan() {
        super(ConfigPhysicalPlanType.UpdateModelState);
    }

    public UpdateModelStatePlan(TUpdateModelStateReq updateModelStateReq) {
        super(ConfigPhysicalPlanType.UpdateModelState);
        this.modelId = updateModelStateReq.getModelId();
        this.state = updateModelStateReq.getState();
        this.bestTrailId = updateModelStateReq.getBestTrailId();
    }

    public String getModelId() {
        return this.modelId;
    }

    public TrainingState getState() {
        return this.state;
    }

    public String getBestTrailId() {
        return this.bestTrailId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.state.getValue(), (OutputStream)stream);
        boolean isNull = this.bestTrailId == null;
        ReadWriteIOUtils.write((Boolean)isNull, (OutputStream)stream);
        if (!isNull) {
            ReadWriteIOUtils.write((String)this.bestTrailId, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.modelId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.state = TrainingState.findByValue((int)ReadWriteIOUtils.readInt((ByteBuffer)buffer));
        boolean isNull = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        if (!isNull) {
            this.bestTrailId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateModelStatePlan that = (UpdateModelStatePlan)o;
        return this.modelId.equals(that.modelId) && this.state == that.state && Objects.equals(this.bestTrailId, that.bestTrailId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelId, this.state, this.bestTrailId);
    }
}

