﻿<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# IoTDB Contributor 入门步骤
## 订阅邮件列表 (dev@iotdb.apache.org)
邮件列表是 Apache 唯一指定的贡献者交流渠道，所有设计和讨论尽量都在邮件列表里进行。邮件列表本质是一个邮箱，订阅之后，所有发往这个邮箱的邮件，都会转发到订阅的邮箱中，订阅方式如下：

 1. 发送订阅邮件：向 [dev-subscribe@iotdb.apache.org](dev-subscribe@iotdb.apache.org) 发送一封邮件，主题内容不限。
 2. 确认订阅邮件：完成上一步后，将收到一封来自 iotdb.apache.org 结尾的确认订阅邮件。向该邮件再次发一封主题内容不限的邮件即可确认订阅。

## 创建开发平台账号

 1. 创建 Jira 账号：[https://issues.apache.org/jira/projects/IOTDB/issues](https://issues.apache.org/jira/projects/IOTDB/issues)  ，用来认领 issue。
 2. 创建 Confluence 账号：[https://cwiki.apache.org/confluence/display/IOTDB/Home](https://cwiki.apache.org/confluence/display/IOTDB/Home) ，之后用来写设计文档。

创建好后，向邮件列表发送一封邮件，包括 **自我介绍** 以及 **Jira ID** 和 **Confluence ID**，社区PMC会为账户添加权限。

## 进用户/开发群

 - QQ用户群：659990460
 - 微信用户群：IoTDB 数据库交流x群
 - Slack：[Apache IoTDB Community](https://join.slack.com/t/apacheiotdb/shared_invite/zt-qvso1nj8-7715TpySZtZqmyG5qXQwpg)

## 关注公众号
扫码关注官方公众号：Apache IoTDB
![IoTDB公众号二维码](https://user-images.githubusercontent.com/7240743/98633970-73671c00-235d-11eb-9913-f38e570fcfc8.png)

## 长期事项
### 学习IoTDB的基本使用

 - [IoTDB下载与安装](https://iotdb.apache.org/zh/UserGuide/Master/QuickStart/WayToGetIoTDB.html)
 - [IoTDB快速上手](https://iotdb.apache.org/zh/UserGuide/Master/QuickStart/QuickStart.html)
 - [数据模式与概念](https://iotdb.apache.org/zh/UserGuide/Master/Data-Concept/Data-Model-and-Terminology.html)
 - [API接口](https://iotdb.apache.org/zh/UserGuide/Master/API/Programming-Java-Native-API.html)

### 学习如何调试IoTDB

 - [如何调试 IoTDB server](https://my.oschina.net/u/3664598/blog/4500279)

### 了解IoTDB的内部设计

 - [IoTDB设计文档](https://cwiki.apache.org/confluence/display/IOTDB/Home)

### 寻找待做任务

 - [在Jira上解决issue](https://issues.apache.org/jira/projects/IOTDB/issues)

