/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.IInnerSeqSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.IInnerUnseqSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionSelector
implements IInnerSeqSpaceSelector,
IInnerUnseqSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected String storageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected List<TsFileResource> tsFileResources;
    protected boolean sequence;
    protected TsFileManager tsFileManager;
    protected boolean hasNextTimePartition;
    private static final long MODS_FILE_SIZE_THRESHOLD = 0x3200000L;

    public SizeTieredCompactionSelector(String storageGroupName, String dataRegionId, long timePartition, boolean sequence, TsFileManager tsFileManager) {
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.sequence = sequence;
        this.tsFileManager = tsFileManager;
        this.hasNextTimePartition = tsFileManager.hasNextTimePartition(timePartition, sequence);
    }

    private List<Pair<List<TsFileResource>, Long>> selectSingleLevel(int level) throws IOException {
        ArrayList<TsFileResource> selectedFileList = new ArrayList<TsFileResource>();
        long selectedFileSize = 0L;
        long targetCompactionFileSize = config.getTargetCompactionFileSize();
        ArrayList<Pair<List<TsFileResource>, Long>> taskList = new ArrayList<Pair<List<TsFileResource>, Long>>();
        for (TsFileResource currentFile : this.tsFileResources) {
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() != level) {
                if (selectedFileList.size() > 1) {
                    taskList.add((Pair<List<TsFileResource>, Long>)new Pair(new ArrayList(selectedFileList), (Object)selectedFileSize));
                }
                selectedFileList = new ArrayList();
                selectedFileSize = 0L;
                continue;
            }
            if (currentFile.getStatus() != TsFileResourceStatus.NORMAL) {
                selectedFileList.clear();
                selectedFileSize = 0L;
                continue;
            }
            LOGGER.debug("Current File is {}, size is {}", (Object)currentFile, (Object)currentFile.getTsFileSize());
            selectedFileList.add(currentFile);
            LOGGER.debug("Add tsfile {}, current select file num is {}, size is {}", new Object[]{currentFile, selectedFileList.size(), selectedFileSize += currentFile.getTsFileSize()});
            if (selectedFileSize < targetCompactionFileSize && selectedFileList.size() < config.getFileLimitPerInnerTask()) continue;
            if (selectedFileList.size() > 1) {
                taskList.add((Pair<List<TsFileResource>, Long>)new Pair(new ArrayList(selectedFileList), (Object)selectedFileSize));
            }
            selectedFileList = new ArrayList();
            selectedFileSize = 0L;
        }
        if (this.hasNextTimePartition && selectedFileList.size() > 1) {
            taskList.add((Pair<List<TsFileResource>, Long>)new Pair(new ArrayList(selectedFileList), (Object)selectedFileSize));
        }
        return taskList;
    }

    @Override
    public List<List<TsFileResource>> selectInnerSpaceTask(List<TsFileResource> tsFileResources) {
        this.tsFileResources = tsFileResources;
        PriorityQueue<Pair<List<TsFileResource>, Long>> taskPriorityQueue = new PriorityQueue<Pair<List<TsFileResource>, Long>>(new SizeTieredCompactionTaskComparator());
        try {
            taskPriorityQueue.addAll(this.selectMaxModsFileTask());
            if (taskPriorityQueue.isEmpty()) {
                taskPriorityQueue.addAll(this.selectLevelTask());
            }
            LinkedList<List<TsFileResource>> taskList = new LinkedList<List<TsFileResource>>();
            while (!taskPriorityQueue.isEmpty()) {
                List resources = (List)taskPriorityQueue.poll().left;
                taskList.add(resources);
            }
            return taskList;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs while selecting files", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Pair<List<TsFileResource>, Long>> selectLevelTask() throws IOException {
        ArrayList<Pair<List<TsFileResource>, Long>> taskList = new ArrayList<Pair<List<TsFileResource>, Long>>();
        int maxLevel = this.searchMaxFileLevel();
        for (int currentLevel = 0; currentLevel <= maxLevel; ++currentLevel) {
            List<Pair<List<TsFileResource>, Long>> singleLevelTask = this.selectSingleLevel(currentLevel);
            if (singleLevelTask.isEmpty()) continue;
            taskList.addAll(singleLevelTask);
            break;
        }
        return taskList;
    }

    private List<Pair<List<TsFileResource>, Long>> selectMaxModsFileTask() {
        ArrayList<Pair<List<TsFileResource>, Long>> taskList = new ArrayList<Pair<List<TsFileResource>, Long>>();
        for (TsFileResource tsFileResource : this.tsFileResources) {
            ModificationFile modFile = tsFileResource.getModFile();
            if (Objects.isNull(modFile) || modFile.getSize() <= 0x3200000L) continue;
            taskList.add((Pair<List<TsFileResource>, Long>)new Pair(Collections.singletonList(tsFileResource), (Object)tsFileResource.getTsFileSize()));
            LOGGER.debug("select tsfile {},the mod file size is {}", (Object)tsFileResource, (Object)modFile.getSize());
        }
        return taskList;
    }

    private int searchMaxFileLevel() throws IOException {
        int maxLevel = -1;
        for (TsFileResource currentFile : this.tsFileResources) {
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() <= maxLevel) continue;
            maxLevel = currentName.getInnerCompactionCnt();
        }
        return maxLevel;
    }

    private class SizeTieredCompactionTaskComparator
    implements Comparator<Pair<List<TsFileResource>, Long>> {
        private SizeTieredCompactionTaskComparator() {
        }

        @Override
        public int compare(Pair<List<TsFileResource>, Long> o1, Pair<List<TsFileResource>, Long> o2) {
            TsFileResource resourceOfO1 = (TsFileResource)((List)o1.left).get(0);
            TsFileResource resourceOfO2 = (TsFileResource)((List)o2.left).get(0);
            try {
                TsFileNameGenerator.TsFileName fileNameOfO1 = TsFileNameGenerator.getTsFileName(resourceOfO1.getTsFile().getName());
                TsFileNameGenerator.TsFileName fileNameOfO2 = TsFileNameGenerator.getTsFileName(resourceOfO2.getTsFile().getName());
                if (fileNameOfO1.getInnerCompactionCnt() != fileNameOfO2.getInnerCompactionCnt()) {
                    return fileNameOfO2.getInnerCompactionCnt() - fileNameOfO1.getInnerCompactionCnt();
                }
                return (int)(fileNameOfO2.getVersion() - fileNameOfO1.getVersion());
            }
            catch (IOException e) {
                return 0;
            }
        }
    }
}

