/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public abstract class AbstractCrossCompactionWriter
extends AbstractCompactionWriter {
    protected List<CompactionTsFileWriter> targetFileWriters = new ArrayList<CompactionTsFileWriter>();
    private List<TsFileResource> seqTsFileResources;
    protected int[] seqFileIndexArray = new int[this.subTaskNum];
    protected final long[] currentDeviceEndTime;
    protected final boolean[] isEmptyFile;
    protected final boolean[] isDeviceExistedInTargetFiles;
    private int chunkGroupHeaderSize;
    protected List<TsFileResource> targetResources;

    protected AbstractCrossCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqFileResources) throws IOException {
        this.currentDeviceEndTime = new long[seqFileResources.size()];
        this.isEmptyFile = new boolean[seqFileResources.size()];
        this.isDeviceExistedInTargetFiles = new boolean[targetResources.size()];
        long memorySizeForEachWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion() / (double)targetResources.size());
        boolean enableMemoryControl = IoTDBDescriptor.getInstance().getConfig().isEnableMemControl();
        for (int i = 0; i < targetResources.size(); ++i) {
            this.targetFileWriters.add(new CompactionTsFileWriter(targetResources.get(i).getTsFile(), enableMemoryControl, memorySizeForEachWriter, CompactionType.CROSS_COMPACTION));
            this.isEmptyFile[i] = true;
        }
        this.seqTsFileResources = seqFileResources;
        this.targetResources = targetResources;
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.deviceId = deviceId;
        this.isAlign = isAlign;
        this.seqFileIndexArray = new int[this.subTaskNum];
        this.checkIsDeviceExistAndGetDeviceEndTime();
        for (int i = 0; i < this.targetFileWriters.size(); ++i) {
            this.chunkGroupHeaderSize = this.targetFileWriters.get(i).startChunkGroup(deviceId);
        }
    }

    @Override
    public void endChunkGroup() throws IOException {
        for (int i = 0; i < this.seqTsFileResources.size(); ++i) {
            CompactionTsFileWriter targetFileWriter = this.targetFileWriters.get(i);
            if (this.isDeviceExistedInTargetFiles[i]) {
                CompactionUtils.updateResource(this.targetResources.get(i), targetFileWriter, this.deviceId);
                targetFileWriter.endChunkGroup();
            } else {
                targetFileWriter.truncate(targetFileWriter.getPos() - (long)this.chunkGroupHeaderSize);
            }
            this.isDeviceExistedInTargetFiles[i] = false;
        }
        this.seqFileIndexArray = null;
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.sealChunk(this.targetFileWriters.get(this.seqFileIndexArray[subTaskId]), this.chunkWriters[subTaskId], subTaskId);
        this.seqFileIndexArray[subTaskId] = 0;
    }

    @Override
    public void write(TimeValuePair timeValuePair, int subTaskId) throws IOException {
        long timestamp = timeValuePair.getTimestamp();
        TsPrimitiveType value = timeValuePair.getValue();
        this.checkTimeAndMayFlushChunkToCurrentFile(timestamp, subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        this.writeDataPoint(timestamp, value, this.chunkWriters[subTaskId]);
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + 1;
        this.checkChunkSizeAndMayOpenANewChunk(this.targetFileWriters.get(fileIndex), this.chunkWriters[subTaskId], subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = timestamp;
    }

    @Override
    public abstract void write(TimeColumn var1, Column[] var2, int var3, int var4) throws IOException;

    @Override
    public void endFile() throws IOException {
        for (int i = 0; i < this.isEmptyFile.length; ++i) {
            this.targetFileWriters.get(i).endFile();
            if (!this.isEmptyFile[i]) continue;
            this.targetResources.get(i).forceMarkDeleted();
        }
    }

    @Override
    public void close() throws IOException {
        for (CompactionTsFileWriter targetWriter : this.targetFileWriters) {
            if (targetWriter == null || !targetWriter.canWrite()) continue;
            targetWriter.close();
        }
        this.targetFileWriters = null;
        this.seqTsFileResources = null;
    }

    @Override
    public void checkAndMayFlushChunkMetadata() throws IOException {
        for (int i = 0; i < this.targetFileWriters.size(); ++i) {
            CompactionTsFileWriter fileIoWriter = this.targetFileWriters.get(i);
            fileIoWriter.checkMetadataSizeAndMayFlush();
        }
    }

    protected void checkTimeAndMayFlushChunkToCurrentFile(long timestamp, int subTaskId) throws IOException {
        if (timestamp <= this.lastTime[subTaskId]) {
            throw new RuntimeException("Timestamp of the current point of " + this.deviceId + '.' + this.measurementId[subTaskId] + " is " + timestamp + ", which should be later than the last time " + this.lastTime[subTaskId]);
        }
        int fileIndex = this.seqFileIndexArray[subTaskId];
        boolean hasFlushedCurrentChunk = false;
        while (timestamp > this.currentDeviceEndTime[fileIndex] && fileIndex != this.seqTsFileResources.size() - 1) {
            if (!hasFlushedCurrentChunk) {
                this.sealChunk(this.targetFileWriters.get(fileIndex), this.chunkWriters[subTaskId], subTaskId);
                hasFlushedCurrentChunk = true;
            }
            this.seqFileIndexArray[subTaskId] = ++fileIndex;
        }
    }

    private void checkIsDeviceExistAndGetDeviceEndTime() throws IOException {
        for (int fileIndex = 0; fileIndex < this.seqTsFileResources.size(); ++fileIndex) {
            if (this.seqTsFileResources.get(fileIndex).getTimeIndexType() == 1) {
                this.currentDeviceEndTime[fileIndex] = this.seqTsFileResources.get(fileIndex).getEndTime(this.deviceId);
                continue;
            }
            long endTime = Long.MIN_VALUE;
            Map deviceMetadataMap = this.getFileReader(this.seqTsFileResources.get(fileIndex)).readDeviceMetadata(this.deviceId);
            for (Map.Entry entry : deviceMetadataMap.entrySet()) {
                long tmpStartTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getStartTime();
                long tmpEndTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getEndTime();
                if (tmpEndTime < tmpStartTime || endTime >= tmpEndTime) continue;
                endTime = tmpEndTime;
            }
            this.currentDeviceEndTime[fileIndex] = endTime;
        }
    }

    @Override
    public long getWriterSize() throws IOException {
        long totalSize = 0L;
        for (CompactionTsFileWriter writer : this.targetFileWriters) {
            totalSize += writer.getPos();
        }
        return totalSize;
    }

    protected abstract TsFileSequenceReader getFileReader(TsFileResource var1) throws IOException;
}

