/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.metric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.schemaengine.metric.ISchemaEngineMetric;
import org.apache.iotdb.db.schemaengine.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaEngineCachedMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaEngineMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.CacheMemoryManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;

public class SchemaMetricManager {
    private final Map<Integer, ISchemaRegionMetric> schemaRegionMetricMap = new ConcurrentHashMap<Integer, ISchemaRegionMetric>();
    private final ISchemaEngineMetric engineMetric;

    public SchemaMetricManager(ISchemaEngineStatistics engineStatistics) {
        if (CommonDescriptor.getInstance().getConfig().getSchemaEngineMode().equals("Memory")) {
            this.engineMetric = new SchemaEngineMemMetric(engineStatistics.getAsMemSchemaEngineStatistics());
        } else {
            SchemaEngineCachedMetric schemaEngineCachedMetric = new SchemaEngineCachedMetric(engineStatistics.getAsCachedSchemaEngineStatistics());
            this.engineMetric = schemaEngineCachedMetric;
            CacheMemoryManager.getInstance().setEngineMetric(schemaEngineCachedMetric);
        }
        MetricService.getInstance().addMetricSet((IMetricSet)this.engineMetric);
    }

    public void createSchemaRegionMetric(ISchemaRegion schemaRegion) {
        ISchemaRegionMetric schemaRegionMetric = schemaRegion.createSchemaRegionMetric();
        this.schemaRegionMetricMap.put(schemaRegion.getSchemaRegionId().getId(), schemaRegionMetric);
        MetricService.getInstance().addMetricSet((IMetricSet)schemaRegionMetric);
    }

    public void deleteSchemaRegionMetric(int schemaRegionId) {
        ISchemaRegionMetric schemaRegionMetric = this.schemaRegionMetricMap.remove(schemaRegionId);
        if (schemaRegionMetric != null) {
            MetricService.getInstance().removeMetricSet((IMetricSet)schemaRegionMetric);
        }
    }

    public void clear() {
        MetricService.getInstance().removeMetricSet((IMetricSet)this.engineMetric);
        for (ISchemaRegionMetric regionMetric : this.schemaRegionMetricMap.values()) {
            MetricService.getInstance().removeMetricSet((IMetricSet)regionMetric);
        }
        this.schemaRegionMetricMap.clear();
    }
}

