/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class SetTTLStatement
extends Statement
implements IConfigStatement {
    protected PartialPath databasePath;
    protected long ttl;

    public SetTTLStatement() {
        this.statementType = StatementType.TTL;
    }

    public PartialPath getDatabasePath() {
        return this.databasePath;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitSetTTL(this, context);
    }

    public void setDatabasePath(PartialPath databasePath) {
        this.databasePath = databasePath;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.databasePath != null ? Collections.singletonList(this.databasePath) : Collections.emptyList();
    }
}

